/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.msg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.pbs.business.domain.msg.service.MsgLogDomainService;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class MsgLogList
extends HRDataBaseList {
    private Map<Long, String> msgTemplatescMap = new HashMap<Long, String>(16);

    public void filterContainerInit(FilterContainerInitArgs args) {
        MsgLogDomainService.getInstance().updateMsgLogsByMsgId(null, true);
        List msgChannelComboItemList = EntityMetaDataUtils.getEntityComboFieldItems((String)"msg_template", (String)"msgchannel");
        List msgTypeComboItemList = EntityMetaDataUtils.getEntityComboFieldItems((String)"msg_template", (String)"msgtype");
        List schemeFilterCols = args.getSchemeFilterColumns().stream().map(filterFilterCol -> (SchemeFilterColumn)filterFilterCol).collect(Collectors.toList());
        for (SchemeFilterColumn schemeFilterColumn : schemeFilterCols) {
            String fieldName = schemeFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"msgchannels")) {
                schemeFilterColumn.setComboItems(msgChannelComboItemList);
            }
            if (!HRStringUtils.equals((String)fieldName, (String)"fmsgtype")) continue;
            schemeFilterColumn.setComboItems(msgTypeComboItemList);
        }
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"msgchannels")) {
                commonFilterColumn.setComboItems(msgChannelComboItemList);
            }
            if (!HRStringUtils.equals((String)fieldName, (String)"fmsgtype")) continue;
            commonFilterColumn.setComboItems(msgTypeComboItemList);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        final Map msgChannelMap = EntityMetaDataUtils.getEntityComboItemsMap((String)"msg_template", (String)"msgchannel");
        final Map msgTypeMap = EntityMetaDataUtils.getEntityComboItemsMap((String)"msg_template", (String)"msgtype");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (!rows.isEmpty()) {
                    for (DynamicObject row : rows) {
                        String msgType;
                        String msgChannels = row.getString("msgchannels");
                        if (HRStringUtils.isNotEmpty((String)msgChannels) && !msgChannelMap.isEmpty()) {
                            row.set("msgchannels", msgChannelMap.get(msgChannels));
                        }
                        if (!HRStringUtils.isNotEmpty((String)(msgType = row.getString("fmsgtype"))) || msgTypeMap.isEmpty()) continue;
                        row.set("fmsgtype", msgTypeMap.get(msgType));
                    }
                }
                return rows;
            }
        });
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        DynamicObjectCollection msgLogObjs = dataEvent.getPageData();
        ArrayList<Long> msgTemplateScIds = new ArrayList<Long>(10);
        for (DynamicObject msgLogObj : msgLogObjs) {
            String[] msgTemplateScIdStrs;
            for (String string : msgTemplateScIdStrs = msgLogObj.getString("msgtemplatesc").split(",")) {
                if (HRStringUtils.isBlank((CharSequence)string)) continue;
                msgTemplateScIds.add(Long.valueOf(string));
            }
        }
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"msg_tplscene");
        QFilter idFilter = new QFilter("id", "in", msgTemplateScIds);
        DynamicObject[] msgTemplateScObjs = serviceHelper.queryOriginalArray("id,name", new QFilter[]{idFilter});
        for (String string : msgTemplateScObjs) {
            this.msgTemplatescMap.put(string.getLong("id"), string.getString("name"));
        }
    }

    public void packageData(PackageDataEvent evt) {
        Object source = evt.getSource();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)source;
        if (HRStringUtils.equals((String)"msgtemplatesc", (String)columnDesc.getKey())) {
            this.setMsgTemplateFormatValue(evt);
        }
    }

    private void setMsgTemplateFormatValue(PackageDataEvent dataEvent) {
        DynamicObject msgLogObj = dataEvent.getRowData();
        String[] msgTemplateScIdStrs = msgLogObj.getString("msgtemplatesc").split(",");
        StringBuilder msgTemplateScSb = new StringBuilder();
        for (String msgTemplateScIdStr : msgTemplateScIdStrs) {
            String msgTemplateScName;
            if (HRStringUtils.isBlank((CharSequence)msgTemplateScIdStr) || HRStringUtils.isBlank((CharSequence)(msgTemplateScName = this.msgTemplatescMap.get(Long.valueOf(msgTemplateScIdStr))))) continue;
            msgTemplateScSb.append(msgTemplateScName);
            msgTemplateScSb.append(",");
        }
        if (msgTemplateScSb.length() > 0) {
            dataEvent.setFormatValue((Object)msgTemplateScSb.substring(0, msgTemplateScSb.length() - 1));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (HRStringUtils.equals((String)"refresh", (String)operate.getOperateKey())) {
            MsgLogDomainService.getInstance().updateMsgLogsByMsgId(null, true);
        }
    }
}

