/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.nordisrule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.opplugin.util.OrgUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.metadata.edit.HisModelBasedataEdit;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.openapi.common.util.Pair;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.pbs.business.tips.ShowConfigTipsUtils;
import kd.opmc.pbs.common.enums.ConvertOperateEnum;
import kd.opmc.pbs.common.enums.DefaultLevelStyleEnum;
import kd.opmc.pbs.common.enums.ExpTypeEnum;
import kd.opmc.pbs.common.enums.OpeTypeEnum;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class NordisRuleEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Set<String> CHANGE_DATE_OPERATION = new HashSet<String>(){
        private static final long serialVersionUID = -380547789045952065L;
        {
            this.add("save");
            this.add("changesave");
            this.add("confirmchange");
            this.add("auditconfirmchange");
            this.add("saveandnew");
            this.add("submit");
            this.add("unsubmit");
            this.add("audit");
        }
    };
    private static final String PERF_LEVEL_CHANGE_CONFIRM = "perf_level_change_confirm";
    private static final String PERF_LEVEL_MAPPING_CHANGE = "perf_level_mapping_change";
    private static final String DEFAULTLEVELSTYLE_MAPPING_CHANGE = "defaultlevelstyle_mapping_change";
    private static final String SYS_SET_DEFAULTLEVELSTYLE = "sys_set_defaultlevelstyle";
    private static final String RATIO_RULE_ENTRY_CHECK = "ratio_rule_entry_check";
    private static final String LEVEL_NOT_CONTAIN_ALL = "level_not_contain_all";
    private static final String IS_STILL_SUBMIT = "is_still_submit";
    private static final String IND_PERF_LEVEL_ID = "indperflevel.id";
    private static final String SCORE_SYSTEM_ID = "scoresystem.id";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setMustInput();
        DynamicObject dy = this.getModel().getDataEntity();
        ShowConfigTipsUtils.showPanelOrControlTips((IFormView)this.getView(), (String)"isenorgrelindlevel", (String)"pbs_nordisrule", (DynamicObject)dy);
        ShowConfigTipsUtils.showPanelOrControlTips((IFormView)this.getView(), (String)"isendeflevelrule", (String)"pbs_nordisrule", (DynamicObject)dy);
        ShowConfigTipsUtils.showPanelOrControlTips((IFormView)this.getView(), (String)"nordisrulesetap", (String)"pbs_nordisrule", (DynamicObject)dy);
        this.prepareShowRatioRulePage();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BasedataEdit indPerfLevel = (BasedataEdit)this.getControl("indperflevel");
        indPerfLevel.setQFilter(new QFilter("id", "!=", (Object)dataEntity.getLong(IND_PERF_LEVEL_ID)));
        if (dataEntity.getBoolean("isendeflevelrule")) {
            this.initDefaultLevelStyle();
            BasedataEdit scoreSys = (BasedataEdit)this.getControl("scoresystem");
            scoreSys.setQFilter(new QFilter("id", "!=", (Object)dataEntity.getLong(SCORE_SYSTEM_ID)));
            this.getModel().setDataChanged(false);
        }
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        String entityNum = dynamicObject.getDataEntityType().getName();
        String orgId = OrgUtil.getMainOrgId((DynamicObject)dynamicObject);
        boolean exist = CodeRuleServiceHelper.isExist((String)entityNum, (DynamicObject)dynamicObject, (String)orgId);
        this.getView().setEnable(Boolean.valueOf(!exist), new String[]{"number"});
    }

    private void setMustInput() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject indPerfLevel = dataEntity.getDynamicObject("indperflevel");
        FieldEdit isEnOrgRelIndLevel = (FieldEdit)this.getView().getControl("isendeflevelrule");
        isEnOrgRelIndLevel.setMustInput(!ObjectUtils.isEmpty((Object)indPerfLevel));
        ComboEdit defaultLevelStyle = (ComboEdit)this.getView().getControl("defaultlevelstyle");
        defaultLevelStyle.setMustInput(dataEntity.getBoolean("isendeflevelrule"));
    }

    private void perfLevelMappingChangeConfirm(MessageBoxClosedEvent messageBoxClosedEvent) {
        IPageCache iPageCache = this.getPageCache();
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            iPageCache.put(PERF_LEVEL_CHANGE_CONFIRM, Boolean.TRUE.toString());
            BasedataEdit indPerfLevel = (BasedataEdit)this.getControl("indperflevel");
            indPerfLevel.click();
        }
    }

    private void defaultLevelStyleMappingChangeConfirm(MessageBoxClosedEvent messageBoxClosedEvent) {
        IPageCache iPageCache = this.getPageCache();
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.initLevelConvertEntry();
            this.initDefaultLevelStyle();
        } else if (MessageBoxResult.Cancel == messageBoxClosedEvent.getResult() && !HRObjectUtils.isEmpty((Object)iPageCache.get("defaultlevelstyle"))) {
            iPageCache.put(SYS_SET_DEFAULTLEVELSTYLE, Boolean.TRUE.toString());
            this.getModel().setValue("defaultlevelstyle", (Object)iPageCache.get("defaultlevelstyle"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "perf_level_mapping_change": {
                this.perfLevelMappingChangeConfirm(messageBoxClosedEvent);
                break;
            }
            case "defaultlevelstyle_mapping_change": {
                this.defaultLevelStyleMappingChangeConfirm(messageBoxClosedEvent);
                break;
            }
            case "level_not_contain_all": {
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) break;
                this.getPageCache().put(IS_STILL_SUBMIT, "true");
                this.getView().invokeOperation("submit");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String name = changedArgs.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (name) {
            case "indperflevel": {
                this.indPerfLevelChange();
                BasedataEdit indPerfLevel = (BasedataEdit)this.getControl("indperflevel");
                indPerfLevel.setQFilter(new QFilter("id", "!=", (Object)dataEntity.getLong(IND_PERF_LEVEL_ID)));
                ChangeData changeData = changedArgs.getChangeSet()[0];
                if (!HRObjectUtils.isEmpty((Object)changeData.getNewValue())) break;
                this.getModel().setValue("isendeflevelrule", (Object)Boolean.FALSE);
                break;
            }
            case "isendeflevelrule": {
                ComboEdit defaultLevelStyle = (ComboEdit)this.getView().getControl("defaultlevelstyle");
                defaultLevelStyle.setMustInput(true);
                if (dataEntity.getBoolean("isendeflevelrule") && this.isRuleLevelReOpen()) {
                    this.initLevelConvertEntry();
                }
                this.initDefaultLevelStyle();
                break;
            }
            case "defaultlevelstyle": {
                this.defaultLevelStyleChange(changedArgs);
                break;
            }
            case "scoreminoperation": {
                if (!HRStringUtils.equals((String)dataEntity.getString("defaultlevelstyle"), (String)DefaultLevelStyleEnum.SCORE_SEGMENT.getStyle())) break;
                this.updateMaxOperation(changedArgs);
                break;
            }
            case "scoremaxoperation": {
                if (!HRStringUtils.equals((String)dataEntity.getString("defaultlevelstyle"), (String)DefaultLevelStyleEnum.RANKING.getStyle())) break;
                this.updateMinOperation(changedArgs);
                break;
            }
            case "minscore": {
                this.minScoreChange(changedArgs);
                break;
            }
            case "maxrank": {
                this.maxRankChange(changedArgs);
                break;
            }
            case "scoresystem": {
                BasedataEdit scoreSys = (BasedataEdit)this.getControl("scoresystem");
                scoreSys.setQFilter(new QFilter("id", "!=", (Object)dataEntity.getLong(SCORE_SYSTEM_ID)));
                break;
            }
        }
    }

    private boolean isRuleLevelReOpen() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject dynamicObject = dataEntity.getDynamicObject("indperflevel");
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        if (dynamicObject == null) {
            return false;
        }
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : dynamicObjectCollection) {
            if (object.getDynamicObjectCollection("levelconvertentry").size() == entryEntity.size()) continue;
            return true;
        }
        return false;
    }

    private void showRatioRulePage(int index) {
        boolean isEdit;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbs_ratiorule");
        String status = dataEntity.getString("status");
        boolean checkPermission = this.checkPermission(this.getView().getFormShowParameter().getStatus());
        boolean bl = isEdit = HRStringUtils.equals((String)"A", (String)status) && checkPermission;
        if (!isEdit) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setStatus(OperationStatus.EDIT);
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("nordisrulesetap");
        showParameter.setCustomParam("parentId", (Object)this.getView().getPageId());
        showParameter.setCustomParam("index", (Object)index);
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }

    private void clearAndShowRatioRulePage() {
        String showPageId = this.getPageCache().get("showPageId");
        IDataModel entryOperate = this.getView().getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.deleteEntryData("ratioruleentry");
        IFormView childView = this.getView().getView(showPageId);
        childView.close();
        this.getView().sendFormAction(childView);
        this.prepareShowRatioRulePage();
    }

    private void refreshCustomControlAp() {
        String showPageId = this.getPageCache().get("showPageId");
        IFormView childView = this.getView().getView(showPageId);
        IFormView view = this.getView();
        CustomControl formulaeditor = (CustomControl)childView.getControl("customcontrolap");
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(16);
        boolean checkPermission = this.checkPermission(this.getView().getFormShowParameter().getStatus());
        String status = this.getModel().getDataEntity().getString("status");
        boolean isEdit = HRStringUtils.equals((String)"A", (String)status) && checkPermission;
        data.put("readOnly", Boolean.valueOf(!isEdit));
        ArrayList<Map<String, Object>> lineRatioRules = new ArrayList<Map<String, Object>>(10);
        data.put("lineRatioRules", lineRatioRules);
        data.put("time", Long.valueOf(System.currentTimeMillis()));
        formulaeditor.setData(data);
        this.buildLineRatioRules(lineRatioRules, 0, view);
        childView.updateView("customcontrolap");
        view.sendFormAction(childView);
    }

    private boolean checkPermission(OperationStatus status) {
        boolean permitemNew = OpmcPermissionUtils.checkPermission((String)"24BC1SMQXGOE", (String)"pbs_nordisrule", (String)"47156aff000000ac");
        boolean permitemNew_EPA = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"pbs_nordisrule", (String)"47156aff000000ac");
        if (OperationStatus.ADDNEW == status && (permitemNew || permitemNew_EPA)) {
            return true;
        }
        boolean permitemModify = OpmcPermissionUtils.checkPermission((String)"24BC1SMQXGOE", (String)"pbs_nordisrule", (String)"4715a0df000000ac");
        boolean permitemModify_EPA = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"pbs_nordisrule", (String)"4715a0df000000ac");
        return OperationStatus.EDIT == status && (permitemModify || permitemModify_EPA);
    }

    private void buildLineRatioRules(List<Map<String, Object>> lineRatioRules, int index, IFormView parentView) {
        IDataModel entryOperate = parentView.getModel();
        entryOperate.setEntryCurrentRowIndex("orgperfentry", index);
        DynamicObjectCollection ratioRuleEntry = entryOperate.getEntryEntity("ratioruleentry");
        DynamicObject ratioRule = null;
        String scoreLevels = null;
        for (int i = 0; i < ratioRuleEntry.size(); ++i) {
            ratioRule = (DynamicObject)ratioRuleEntry.get(i);
            HashMap<String, Object> ratioRuleMap = new HashMap<String, Object>(16);
            ratioRuleMap.put("expType", ratioRule.getString("exptype"));
            ratioRuleMap.put("numOne", ratioRule.getInt("numone") == 0 ? "" : Integer.valueOf(ratioRule.getInt("numone")));
            ratioRuleMap.put("opeOne", ratioRule.getString("opeone"));
            ratioRuleMap.put("opeTwo", ratioRule.getString("opetwo"));
            ratioRuleMap.put("numTwo", ratioRule.getInt("numtwo") == 0 ? "" : Integer.valueOf(ratioRule.getInt("numtwo")));
            scoreLevels = ratioRule.getString("scorelevels");
            if (HRStringUtils.isNotEmpty((String)scoreLevels)) {
                ratioRuleMap.put("scoreLevels", JSON.parseArray((String)scoreLevels));
            } else {
                ratioRuleMap.put("scoreLevels", new String[0]);
            }
            ratioRuleMap.put("unit", "%");
            lineRatioRules.add(ratioRuleMap);
        }
    }

    private void prepareShowRatioRulePage() {
        IDataModel entryOperate = this.getView().getModel();
        DynamicObjectCollection orgPerfEntry = entryOperate.getEntryEntity("orgperfentry");
        if (orgPerfEntry.size() == 0) {
            entryOperate.createNewEntryRow("orgperfentry");
        }
        this.showRatioRulePage(0);
    }

    private void indPerfLevelChange() {
        FieldEdit isEnOrgRelIndLevel = (FieldEdit)this.getView().getControl("isendeflevelrule");
        isEnOrgRelIndLevel.setMustInput(true);
        this.initLevelConvertEntry();
        this.initDefaultLevelStyle();
        this.clearAndShowRatioRulePage();
    }

    private void defaultLevelStyleChange(PropertyChangedArgs changedArgs) {
        IPageCache iPageCache = this.getPageCache();
        if (HRStringUtils.isNotEmpty((String)iPageCache.get(SYS_SET_DEFAULTLEVELSTYLE))) {
            iPageCache.remove(SYS_SET_DEFAULTLEVELSTYLE);
            return;
        }
        ChangeData changeData = changedArgs.getChangeSet()[0];
        String oldValue = (String)changeData.getOldValue();
        iPageCache.put("defaultlevelstyle", oldValue);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u9ed8\u8ba4\u8f6c\u7b49\u7ea7\u65b9\u5f0f\uff0c\u5df2\u914d\u7f6e\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u5207\u6362\uff1f", (String)"NordisRuleEdit_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DEFAULTLEVELSTYLE_MAPPING_CHANGE, (IFormPlugin)this));
    }

    private void maxRankChange(PropertyChangedArgs args) {
        IDataModel model = this.getModel();
        ChangeData changeData = args.getChangeSet()[0];
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        DynamicObjectCollection entryEntities = ((DynamicObject)dynamicObjectCollection.get(changeData.getParentRowIndex())).getDynamicObjectCollection("levelconvertentry");
        int size = entryEntities.size();
        Integer inputRank = (Integer)changeData.getNewValue();
        if (HRObjectUtils.isEmpty((Object)inputRank)) {
            return;
        }
        if (inputRank.compareTo(0) < 0 || inputRank.compareTo(100) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6392\u540d\u5360\u6bd4\u201d\u503c\u5e94\u5927\u4e8e0\u5c0f\u4e8e100\uff0c\u4e14\u4e3a\u6574\u6570\u3002", (String)"NordisRuleEdit_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            model.setValue("maxrank", null, changeData.getRowIndex());
            if (size != changeData.getRowIndex() + 1) {
                this.getModel().setValue("minrank", null, changeData.getRowIndex() + 1);
            }
            return;
        }
        if (size != changeData.getRowIndex() + 1) {
            if (inputRank.compareTo(0) == 0 || inputRank.compareTo(100) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6392\u540d\u5360\u6bd4\u201d\u503c\u5e94\u5927\u4e8e0\u5c0f\u4e8e100\uff0c\u4e14\u4e3a\u6574\u6570\u3002", (String)"NordisRuleEdit_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                model.setValue("maxrank", null, changeData.getRowIndex());
                this.getModel().setValue("minrank", null, changeData.getRowIndex() + 1);
                return;
            }
            model.setValue("minrank", changeData.getNewValue(), changeData.getRowIndex() + 1);
        }
        if (changeData.getRowIndex() > 0) {
            for (int index = changeData.getRowIndex() - 1; index >= 0; --index) {
                Integer maxRank = (Integer)this.getModel().getValue("maxrank", index);
                if (HRObjectUtils.isEmpty((Object)inputRank) || HRObjectUtils.isEmpty((Object)maxRank) || inputRank.compareTo(maxRank) > 0) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6392\u540d\u5360\u6bd4\u4ece\u4e0a\u5f80\u4e0b\u5347\u5e8f\uff0c\u4e14\u4e3a\u6b63\u6574\u6570\u3002", (String)"NordisRuleEdit_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                model.setValue("maxrank", null, changeData.getRowIndex());
                if (size == changeData.getRowIndex() + 1) break;
                this.getModel().setValue("minrank", null, changeData.getRowIndex() + 1);
                break;
            }
        }
    }

    private void minScoreChange(PropertyChangedArgs args) {
        IDataModel model = this.getModel();
        ChangeData changeData = args.getChangeSet()[0];
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        DynamicObjectCollection entryEntities = ((DynamicObject)dynamicObjectCollection.get(changeData.getParentRowIndex())).getDynamicObjectCollection("levelconvertentry");
        int size = entryEntities.size();
        BigDecimal inputScore = (BigDecimal)changeData.getNewValue();
        if (HRObjectUtils.isEmpty((Object)inputScore)) {
            return;
        }
        DynamicObject dynamicObject = dataEntity.getDynamicObject("scoresystem");
        if (!HRObjectUtils.isEmpty((Object)dynamicObject) && inputScore.compareTo(dynamicObject.getBigDecimal("maxscore")) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u5206\u503c\u8303\u56f4\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u201c\u5206\u5236\u57fa\u51c6\u6700\u9ad8\u5206\u201d\u3002", (String)"NordisRuleEdit_3", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("minscore", null, changeData.getRowIndex());
            if (size != changeData.getRowIndex() + 1) {
                model.setValue("maxscore", null, changeData.getRowIndex() + 1);
            }
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)dynamicObject) && inputScore.compareTo(dynamicObject.getBigDecimal("minscore")) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u5206\u503c\u8303\u56f4\u201d\u9700\u5927\u4e8e\u7b49\u4e8e\u201c\u5206\u5236\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"NordisRuleEdit_4", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("minscore", null, changeData.getRowIndex());
            if (size != changeData.getRowIndex() + 1) {
                model.setValue("maxscore", null, changeData.getRowIndex() + 1);
            }
            return;
        }
        if (size != changeData.getRowIndex() + 1) {
            model.setValue("maxscore", changeData.getNewValue(), changeData.getRowIndex() + 1);
        }
        if (changeData.getRowIndex() > 0) {
            for (int index = changeData.getRowIndex() - 1; index >= 0; --index) {
                BigDecimal minScore = (BigDecimal)this.getModel().getValue("minscore", index);
                if (HRObjectUtils.isEmpty((Object)inputScore) || HRObjectUtils.isEmpty((Object)minScore) || inputScore.compareTo(minScore) < 0) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u4f4e\u5206\u4ece\u4e0a\u5f80\u4e0b\u964d\u5e8f\u3002", (String)"NordisRuleEdit_5", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                model.setValue("minscore", null, changeData.getRowIndex());
                if (size == changeData.getRowIndex() + 1) break;
                model.setValue("maxscore", null, changeData.getRowIndex() + 1);
                break;
            }
        }
    }

    private boolean checkLevelConvertEntry() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        if (dataEntity.getBoolean("isendeflevelrule")) {
            for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
                IDataModel entryOperate = this.getModel();
                entryOperate.setEntryCurrentRowIndex("orgperfentry", index);
                DynamicObjectCollection entryEntities = ((DynamicObject)dynamicObjectCollection.get(index)).getDynamicObjectCollection("levelconvertentry");
                if (HRStringUtils.equals((String)dataEntity.getString("defaultlevelstyle"), (String)DefaultLevelStyleEnum.SCORE_SEGMENT.getStyle()) && this.checkLevelScoreMap(entryEntities)) {
                    return true;
                }
                if (!HRStringUtils.equals((String)dataEntity.getString("defaultlevelstyle"), (String)DefaultLevelStyleEnum.RANKING.getStyle()) || !this.checkRankingMap(entryEntities)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkRankingMap(DynamicObjectCollection entryEntities) {
        for (int index = 0; index < entryEntities.size(); ++index) {
            int firstMaxRank;
            if (ObjectUtils.isEmpty((Object)((DynamicObject)entryEntities.get(index)).get("maxrank"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6700\u9ad8\u6392\u540d\u3002", (String)"NordisRuleEdit_6", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
            int maxRank = ((DynamicObject)entryEntities.get(index)).getInt("maxrank");
            if (index != entryEntities.size() - 1 && HRObjectUtils.isEmpty((Object)((DynamicObject)entryEntities.get(index)).get("scoremaxoperation"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8fd0\u7b97\u7b26\u201d\u3002", (String)"NordisRuleEdit_7", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (index != entryEntities.size() - 1 && (maxRank >= 100 || maxRank <= 0)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6392\u540d\u5360\u6bd4\u201d\u503c\u5e94\u5927\u4e8e0\u5c0f\u4e8e100\uff0c\u4e14\u4e3a\u6574\u6570\u3002", (String)"NordisRuleEdit_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("maxrank", null, index);
                this.getModel().setValue("minrank", null, index + 1);
                return true;
            }
            if (index <= 0 || index == entryEntities.size() - 1 || maxRank > (firstMaxRank = ((DynamicObject)entryEntities.get(index - 1)).getInt("maxrank"))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6392\u540d\u5360\u6bd4\u4ece\u4e0a\u5f80\u4e0b\u5347\u5e8f\uff0c\u4e14\u4e3a\u6b63\u6574\u6570\u3002", (String)"NordisRuleEdit_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("maxrank", null, index);
            this.getModel().setValue("minrank", null, index + 1);
            return true;
        }
        return false;
    }

    private boolean checkLevelScoreMap(DynamicObjectCollection entryEntities) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject dynamicObject = dataEntity.getDynamicObject("scoresystem");
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8bc4\u5206\u5206\u5236\u201d\u3002", (String)"NordisRuleEdit_8", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        for (int index = 0; index < entryEntities.size(); ++index) {
            if (index != entryEntities.size() - 1 && HRObjectUtils.isEmpty((Object)((DynamicObject)entryEntities.get(index)).get("scoreminoperation"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8fd0\u7b97\u7b26\u201d\u3002", (String)"NordisRuleEdit_7", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
            BigDecimal lastMinScore = ((DynamicObject)entryEntities.get(index)).getBigDecimal("minscore");
            if (index != entryEntities.size() - 1) {
                if (HRObjectUtils.isEmpty((Object)lastMinScore)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6700\u4f4e\u5206\u201d\u3002", (String)"NordisRuleEdit_9", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    return true;
                }
                if (!HRObjectUtils.isEmpty((Object)dynamicObject) && lastMinScore.compareTo(dynamicObject.getBigDecimal("maxscore")) > 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u5206\u503c\u8303\u56f4\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u201c\u5206\u5236\u57fa\u51c6\u6700\u9ad8\u5206\u201d\u3002", (String)"NordisRuleEdit_3", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("minscore", null, index);
                    this.getModel().setValue("maxscore", null, index + 1);
                    return true;
                }
                if (!HRObjectUtils.isEmpty((Object)dynamicObject) && lastMinScore.compareTo(dynamicObject.getBigDecimal("minscore")) < 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u5206\u503c\u8303\u56f4\u201d\u9700\u5927\u4e8e\u7b49\u4e8e\u201c\u5206\u5236\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"NordisRuleEdit_4", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("minscore", null, index);
                    this.getModel().setValue("maxscore", null, index + 1);
                    return true;
                }
            }
            if (index <= 0 || index == entryEntities.size() - 1) continue;
            BigDecimal firstMinScore = ((DynamicObject)entryEntities.get(index - 1)).getBigDecimal("minscore");
            if (HRObjectUtils.isEmpty((Object)firstMinScore)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6700\u4f4e\u5206\u201d\u3002", (String)"NordisRuleEdit_9", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (lastMinScore.compareTo(firstMinScore) < 0) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u4f4e\u5206\u4ece\u4e0a\u5f80\u4e0b\u964d\u5e8f\u3002", (String)"NordisRuleEdit_5", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("minscore", null, index);
            this.getModel().setValue("maxscore", null, index + 1);
            return true;
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (CHANGE_DATE_OPERATION.contains(operate.getOperateKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (dataEntity.getBoolean("isendeflevelrule") && this.checkLevelConvertEntry()) {
                args.setCancel(true);
                return;
            }
            if (!dataEntity.getBoolean("isendeflevelrule")) {
                this.deleteCloseLevelRule();
            }
            if (this.checkRatioRuleEntry(args, dataEntity, operate.getOperateKey())) {
                return;
            }
        }
    }

    private boolean checkRatioRuleEntry(BeforeDoOperationEventArgs args, DynamicObject dataEntity, String operateKey) {
        DynamicObjectCollection orgPerfEntry = dataEntity.getDynamicObjectCollection("orgperfentry");
        for (DynamicObject orgPerf : orgPerfEntry) {
            String stillSubmit;
            DynamicObjectCollection ratioRuleEntry = orgPerf.getDynamicObjectCollection("ratioruleentry");
            if (this.simpleCheck(args, ratioRuleEntry)) {
                return true;
            }
            ArrayList<Pair<Integer, Integer>> pairNums = new ArrayList<Pair<Integer, Integer>>(10);
            HashSet comLevelSet = new HashSet(16);
            for (DynamicObject ratioRule : ratioRuleEntry) {
                if (ratioRule.getString("scorelevels").split("\\,").length <= 1) continue;
                JSONArray objects = JSON.parseArray((String)ratioRule.getString("scorelevels"));
                comLevelSet.addAll(objects);
            }
            boolean flag = false;
            for (int i = 0; i < ratioRuleEntry.size(); ++i) {
                DynamicObject ratioRule = (DynamicObject)ratioRuleEntry.get(i);
                if (ratioRule.getString("scorelevels").split("\\,").length == 1 && comLevelSet.contains(JSON.parseArray((String)ratioRule.getString("scorelevels")).get(0))) continue;
                String opeTwo = ratioRule.getString("opetwo");
                pairNums.add(this.buildPairNum(ratioRule));
                if (OpeTypeEnum.EQUAL.getValue().equals(opeTwo)) continue;
                flag = true;
            }
            if (flag) {
                int sumMin = pairNums.stream().mapToInt(pairNum -> (Integer)pairNum.getKey()).sum();
                int sumMax = pairNums.stream().mapToInt(pairNum -> (Integer)pairNum.getValue()).sum();
                if (sumMin >= 100 || sumMax <= 100) {
                    args.setCancel(true);
                    this.showNordisRuleTip();
                    return true;
                }
            } else {
                int sumNum = pairNums.stream().mapToInt(pairNum -> (Integer)pairNum.getValue()).sum();
                if (sumNum != 100) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u6bd4\u4f8b\u516c\u5f0f\u8bbe\u7f6e\u4e3a\u201c\u9ed8\u8ba4\u201d\u4e14\u503c\u4e3a\u201c=\u201d\u65f6\uff0c\u6bd4\u4f8b\u4e4b\u548c\u9700\u7b49\u4e8e100%\u3002", (String)"NordisRuleEdit_10", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    return true;
                }
            }
            if (!HRStringUtils.isEmpty((String)(stillSubmit = this.getPageCache().get(IS_STILL_SUBMIT))) || !HRStringUtils.equals((String)operateKey, (String)"submit")) continue;
            HashSet levelNameSet = new HashSet(16);
            for (DynamicObject ratioRule : ratioRuleEntry) {
                JSONArray objects = JSON.parseArray((String)ratioRule.getString("scorelevels"));
                levelNameSet.addAll(objects);
            }
            DynamicObject indPerfLevel = dataEntity.getDynamicObject("indperflevel");
            DynamicObjectCollection entryEntity = indPerfLevel.getDynamicObjectCollection("entryentity");
            Set allLevelSet = entryEntity.stream().map(perfLevel -> perfLevel.getString("levelname")).collect(Collectors.toSet());
            List notSetList = allLevelSet.stream().filter(levelName -> !levelNameSet.contains(levelName)).collect(Collectors.toList());
            String notSetStr = notSetList.toString().replaceAll("\\[", "\\\u3010").replaceAll("\\]", "\\\u3011");
            if (levelNameSet.containsAll(allLevelSet)) continue;
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4e2a\u4eba\u7ee9\u6548\u7b49\u7ea7\u4e2d\u7684\u7b49\u7ea7\u4e2d{0}\u8fd8\u672a\u5b8c\u5168\u8bbe\u7f6e\u5b8c\u6bd5\uff0c\u4ecd\u7136\u8981\u63d0\u4ea4\u5417\uff1f", (String)"NordisRuleEdit_23", (String)"opmc-pbs-formplugin", (Object[])new Object[]{notSetStr}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(LEVEL_NOT_CONTAIN_ALL, (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private boolean simpleCheck(BeforeDoOperationEventArgs args, DynamicObjectCollection ratioRuleEntry) {
        if (ObjectUtils.isEmpty((Object)ratioRuleEntry)) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6bd4\u4f8b\u89c4\u5219\u8bbe\u7f6e\u201d\u3002", (String)"NordisRuleEdit_12", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        long count = ratioRuleEntry.stream().filter(ratioRule -> ratioRule.getString("exptype").equals(ExpTypeEnum.BETWEEN.getValue())).count();
        if (count == (long)ratioRuleEntry.size()) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5404\u7b49\u7ea7\u6bd4\u4f8b\u89c4\u5219\u4e0d\u652f\u6301\u5168\u90e8\u8bbe\u7f6e\u4e3a\u201c\u533a\u95f4\u201d\u3002", (String)"NordisRuleEdit_13", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        long notLimitCount = ratioRuleEntry.stream().filter(ratioRule -> ratioRule.getString("exptype").equals(ExpTypeEnum.NOT_LIMIT.getValue())).count();
        if (notLimitCount == (long)ratioRuleEntry.size()) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5404\u7b49\u7ea7\u6bd4\u4f8b\u89c4\u5219\u4e0d\u652f\u6301\u5168\u90e8\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u9650\u5236\u201d\u3002", (String)"NordisRuleEdit_14", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        for (int i = 0; i < ratioRuleEntry.size(); ++i) {
            int row = i + 1;
            if (!this.checkRationRuleMustInput((DynamicObject)ratioRuleEntry.get(i))) continue;
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6bd4\u4f8b\u89c4\u5219\u8bbe\u7f6e\u201d\u7b2c{0}\u884c\u5fc5\u586b\u9879\u3002", (String)"NordisRuleEdit_24", (String)"opmc-pbs-formplugin", (Object[])new Object[]{row}));
            return true;
        }
        return false;
    }

    private Pair<Integer, Integer> buildPairNum(DynamicObject ratioRule) {
        Pair result = new Pair((Object)0, (Object)0);
        String opeTwo = ratioRule.getString("opetwo");
        int numOne = ratioRule.getInt("numone");
        int numTwo = ratioRule.getInt("numtwo");
        ExpTypeEnum expType = ExpTypeEnum.valueToEnum((String)ratioRule.getString("exptype"));
        switch (expType) {
            case NOT_LIMIT: {
                result = new Pair((Object)0, (Object)100);
                break;
            }
            case BETWEEN: {
                result = new Pair((Object)numOne, (Object)numTwo);
                break;
            }
            case DEFAULT: {
                if (OpeTypeEnum.LESSTHAN.getValue().equals(opeTwo) || OpeTypeEnum.LESSTHANOREQUAL.getValue().equals(opeTwo)) {
                    result = new Pair((Object)0, (Object)numTwo);
                    break;
                }
                if (OpeTypeEnum.EQUAL.getValue().equals(opeTwo)) {
                    result = new Pair((Object)numTwo, (Object)numTwo);
                    break;
                }
                if (!OpeTypeEnum.GREATERTHAN.getValue().equals(opeTwo) && !OpeTypeEnum.GREATERTHANOREQUAL.getValue().equals(opeTwo)) break;
                result = new Pair((Object)numTwo, (Object)100);
                break;
            }
        }
        return result;
    }

    private boolean checkRationRuleMustInput(DynamicObject ratioRule) {
        if (HRStringUtils.isEmpty((String)ratioRule.getString("scorelevels"))) {
            return true;
        }
        int numOne = ratioRule.getInt("numone");
        int numTwo = ratioRule.getInt("numtwo");
        String opeOne = ratioRule.getString("opeone");
        String opeTwo = ratioRule.getString("opetwo");
        String expType = ratioRule.getString("exptype");
        return expType.equals(ExpTypeEnum.DEFAULT.getValue()) ? HRStringUtils.isEmpty((String)opeTwo) || numTwo <= 0 : expType.equals(ExpTypeEnum.BETWEEN.getValue()) && (HRStringUtils.isEmpty((String)opeOne) || numOne <= 0 || HRStringUtils.isEmpty((String)opeTwo) || numTwo <= 0);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if (CHANGE_DATE_OPERATION.contains(operateKey) && !HRObjectUtils.isEmpty((Object)afterDoOperationEventArgs.getOperationResult()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (dataEntity.getBoolean("isendeflevelrule")) {
                this.initDefaultLevelStyle();
            }
            this.refreshCustomControlAp();
            this.getModel().setDataChanged(false);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
            this.getPageCache().put(IS_STILL_SUBMIT, "");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    private void deleteCloseLevelRule() {
        this.getModel().setValue("scoresystem", null);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex("orgperfentry", index);
            entryOperate.deleteEntryData("levelconvertentry");
        }
    }

    private void updateMaxOperation(PropertyChangedArgs args) {
        ChangeData changeData = args.getChangeSet()[0];
        String inputOperation = (String)changeData.getNewValue();
        String oldValue = (String)changeData.getOldValue();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        DynamicObjectCollection levelConvertEntry = ((DynamicObject)dynamicObjectCollection.get(changeData.getParentRowIndex())).getDynamicObjectCollection("levelconvertentry");
        int size = levelConvertEntry.size();
        IDataModel model = this.getModel();
        if (size != changeData.getRowIndex() + 1) {
            if (HRStringUtils.equals((String)inputOperation, (String)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate())) {
                model.setValue("scoremaxoperation", (Object)ConvertOperateEnum.LESS_THAN.getOperate(), changeData.getRowIndex() + 1);
            } else if (HRStringUtils.equals((String)inputOperation, (String)ConvertOperateEnum.LESS_THAN.getOperate())) {
                model.setValue("scoremaxoperation", (Object)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate(), changeData.getRowIndex() + 1);
            } else if (HRStringUtils.isEmpty((String)inputOperation) && HRStringUtils.isNotEmpty((String)oldValue)) {
                if (HRStringUtils.equals((String)oldValue, (String)ConvertOperateEnum.LESS_THAN.getOperate())) {
                    model.setValue("scoreminoperation", (Object)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate());
                } else {
                    model.setValue("scoreminoperation", (Object)ConvertOperateEnum.LESS_THAN.getOperate());
                }
            }
        }
    }

    private void updateMinOperation(PropertyChangedArgs args) {
        ChangeData changeData = args.getChangeSet()[0];
        String oldValue = (String)changeData.getOldValue();
        String inputOperation = (String)changeData.getNewValue();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        DynamicObjectCollection levelConvertEntry = ((DynamicObject)dynamicObjectCollection.get(changeData.getParentRowIndex())).getDynamicObjectCollection("levelconvertentry");
        int size = levelConvertEntry.size();
        IDataModel model = this.getModel();
        if (size != changeData.getRowIndex() + 1) {
            if (HRStringUtils.equals((String)inputOperation, (String)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate())) {
                model.setValue("scoreminoperation", (Object)ConvertOperateEnum.LESS_THAN.getOperate(), changeData.getRowIndex() + 1);
            } else if (HRStringUtils.equals((String)inputOperation, (String)ConvertOperateEnum.LESS_THAN.getOperate())) {
                model.setValue("scoreminoperation", (Object)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate(), changeData.getRowIndex() + 1);
            } else if (HRStringUtils.isEmpty((String)inputOperation) && HRStringUtils.isNotEmpty((String)oldValue)) {
                if (HRStringUtils.equals((String)oldValue, (String)ConvertOperateEnum.LESS_THAN.getOperate())) {
                    model.setValue("scoremaxoperation", (Object)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate());
                } else {
                    model.setValue("scoremaxoperation", (Object)ConvertOperateEnum.LESS_THAN.getOperate());
                }
            }
        }
    }

    private void initLevelConvertEntry() {
        this.getModel().setValue("scoresystem", null);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject dynamicObject = dataEntity.getDynamicObject("indperflevel");
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        IDataModel entryOperate = this.getModel();
        IDataModel model = this.getModel();
        for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
            entryOperate.setEntryCurrentRowIndex("orgperfentry", index);
            model.deleteEntryData("levelconvertentry");
            for (DynamicObject object : entryEntity) {
                int row = entryOperate.createNewEntryRow("levelconvertentry");
                model.setValue("scorelevel", (Object)object.getString("levelname"), row);
            }
            this.reSetLevelConvertEntry(index);
        }
    }

    private void reSetLevelConvertEntry(int index) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        IDataModel model = this.getModel();
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        DynamicObjectCollection levelConvertEntry = ((DynamicObject)dynamicObjectCollection.get(index)).getDynamicObjectCollection("levelconvertentry");
        int size = levelConvertEntry.size();
        switch (DefaultLevelStyleEnum.getDefaultLevelStyleEnum((String)dataEntity.getString("defaultlevelstyle"))) {
            case SCORE_SEGMENT: {
                for (int row = 0; row < size; ++row) {
                    model.setValue("scoremaxoperation", (Object)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate(), row);
                    model.setValue("scoreminoperation", (Object)ConvertOperateEnum.LESS_THAN.getOperate(), row);
                    this.getView().setEnable(Boolean.FALSE, row, new String[]{"scoremaxoperation"});
                }
                model.setValue("minscore", null, size - 1);
                model.setValue("scoreminoperation", null, size - 1);
                this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"scoreminoperation", "minscore"});
                model.setValue("maxscore", null, 0);
                model.setValue("scoremaxoperation", null, 0);
                this.getView().setEnable(Boolean.FALSE, new String[]{"maxscore"});
                break;
            }
            case RANKING: {
                for (int row = 0; row < size; ++row) {
                    model.setValue("scoremaxoperation", (Object)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate(), row);
                    model.setValue("scoreminoperation", (Object)ConvertOperateEnum.LESS_THAN.getOperate(), row);
                    this.getView().setEnable(Boolean.FALSE, row, new String[]{"scoreminoperation", "minrank"});
                    this.getView().setEnable(Boolean.TRUE, row, new String[]{"scoremaxoperation"});
                }
                model.setValue("scoreminoperation", (Object)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate(), 0);
                model.setValue("scoremaxoperation", (Object)ConvertOperateEnum.LESS_THAN_OR_EQUAL.getOperate(), size - 1);
                model.setValue("minrank", (Object)0, 0);
                model.setValue("maxrank", (Object)100, size - 1);
                this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"scoremaxoperation", "maxrank"});
                break;
            }
        }
    }

    private void initEntryText() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
        IDataModel model = this.getModel();
        for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
            model.setEntryCurrentRowIndex("orgperfentry", index);
            DynamicObjectCollection collection = ((DynamicObject)dynamicObjectCollection.get(index)).getDynamicObjectCollection("levelconvertentry");
            int size = collection.size();
            block5: for (int row = 0; row < size; ++row) {
                switch (DefaultLevelStyleEnum.getDefaultLevelStyleEnum((String)dataEntity.getString("defaultlevelstyle"))) {
                    case SCORE_SEGMENT: {
                        model.setValue("minscore", null, size - 1);
                        model.setValue("scoreminoperation", null, size - 1);
                        model.setValue("maxscore", null, 0);
                        model.setValue("scoremaxoperation", null, 0);
                        this.getView().setEnable(Boolean.FALSE, row, new String[]{"scoremaxoperation"});
                        this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"scoreminoperation", "minscore"});
                        this.getView().setEnable(Boolean.FALSE, new String[]{"maxscore"});
                        model.setValue("scoretext", (Object)ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5f97\u5206", (String)"NordisRuleEdit_16", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), (String)"NordisRuleEdit_16", (String)"opmc-pbs-formplugin"), row);
                        continue block5;
                    }
                    case RANKING: {
                        this.getView().setEnable(Boolean.FALSE, row, new String[]{"scoreminoperation", "minrank"});
                        this.getView().setEnable(Boolean.TRUE, row, new String[]{"scoremaxoperation"});
                        this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"scoremaxoperation", "maxrank"});
                        model.setValue("ranktext", (Object)ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u6392\u540d\u5360\u6bd4", (String)"NordisRuleEdit_17", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), (String)"NordisRuleEdit_17", (String)"opmc-pbs-formplugin"), row);
                        continue block5;
                    }
                }
            }
            this.getView().updateView("levelconvertentry");
            this.getView().sendFormAction(this.getView());
        }
    }

    private void initDefaultLevelStyle() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IFormView view = this.getView();
        HisModelBasedataEdit hisModelBasedataEdit = (HisModelBasedataEdit)view.getControl("scoresystem");
        EntryGrid grid = (EntryGrid)this.getControl("levelconvertentry");
        HashMap<String, LocaleString> text = new HashMap<String, LocaleString>(16);
        switch (DefaultLevelStyleEnum.getDefaultLevelStyleEnum((String)dataEntity.getString("defaultlevelstyle"))) {
            case RANKING: {
                text.put("text", ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u6839\u636e\u6392\u540d\u8f6c\u7b49\u7ea7\u8bbe\u7f6e", (String)"NordisRuleEdit_18", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), (String)"NordisRuleEdit_18", (String)"opmc-pbs-formplugin"));
                grid.setColumnProperty("entryfieldgroupap", "header", (Object)ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u6392\u540d\u533a\u95f4", (String)"NordisRuleEdit_19", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), (String)"NordisRuleEdit_19", (String)"opmc-pbs-formplugin"));
                view.setVisible(Boolean.FALSE, new String[]{"scoresystem", "minscore", "scoretext", "maxscore", "scoredescription"});
                view.setVisible(Boolean.TRUE, new String[]{"maxrank", "minrank", "ranktext"});
                hisModelBasedataEdit.setMustInput(false);
                break;
            }
            case SCORE_SEGMENT: {
                text.put("text", ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u6839\u636e\u5206\u6570\u6bb5\u8f6c\u7b49\u7ea7\u8bbe\u7f6e", (String)"NordisRuleEdit_20", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), (String)"NordisRuleEdit_20", (String)"opmc-pbs-formplugin"));
                grid.setColumnProperty("entryfieldgroupap", "header", (Object)ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5f97\u5206\u533a\u95f4", (String)"NordisRuleEdit_21", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), (String)"NordisRuleEdit_21", (String)"opmc-pbs-formplugin"));
                view.setVisible(Boolean.TRUE, new String[]{"scoresystem", "minscore", "scoretext", "maxscore", "scoredescription"});
                view.setVisible(Boolean.FALSE, new String[]{"maxrank", "minrank", "ranktext"});
                hisModelBasedataEdit.setMustInput(true);
                break;
            }
        }
        this.getView().updateControlMetadata("segmentgradeap", text);
        this.initEntryText();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = ((Control)beforeF7SelectEvent.getSource()).getKey();
        if (HRStringUtils.equals((String)"indperflevel", (String)fieldKey)) {
            IPageCache iPageCache = this.getPageCache();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (!HRObjectUtils.isEmpty((Object)dataEntity.get("indperflevel")) && HRStringUtils.isEmpty((String)iPageCache.get(PERF_LEVEL_CHANGE_CONFIRM))) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e2a\u4eba\u7ee9\u6548\u7b49\u7ea7\uff0c\u5df2\u914d\u7f6e\u5185\u5bb9\u5c06\u88ab\u6e05\u7a7a\uff0c\u786e\u8ba4\u5207\u6362\uff1f", (String)"NordisRuleEdit_22", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(PERF_LEVEL_MAPPING_CHANGE, (IFormPlugin)this));
                beforeF7SelectEvent.setCancel(true);
            } else if (HRStringUtils.isNotEmpty((String)iPageCache.get(PERF_LEVEL_CHANGE_CONFIRM))) {
                iPageCache.remove(PERF_LEVEL_CHANGE_CONFIRM);
            }
        }
    }

    public void registerListener(EventObject eventObjecte) {
        super.registerListener(eventObjecte);
        BasedataEdit indPerfLevel = (BasedataEdit)this.getControl("indperflevel");
        indPerfLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void showNordisRuleTip() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pbs_checksumtip");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setHasRight(true);
        this.getView().showForm(parameter);
    }
}

