/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.paramconfig;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BooleanProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.utils.LocalCacheUtils;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterWriter;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.permission.model.AdminType;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.pbs.business.application.service.PerfParamConfigApplicationService;

public class PbsAppParamConfigPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(PbsAppParamConfigPlugin.class);
    private static final PerfParamConfigApplicationService PERF_PARAM_CONFIG_APPLICATION_SERVICE = PerfParamConfigApplicationService.getInstance();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showAppParamView();
    }

    private void showAppParamView() {
        ParameterShowParameter showParameter = new ParameterShowParameter();
        showParameter.setFormId("pbs_appconfig");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("paramconfigflex");
        long orgId = 100000L;
        AppParam appParam = PERF_PARAM_CONFIG_APPLICATION_SERVICE.assembleAppInfo(orgId);
        showParameter.setCustomParam("orgid", (Object)orgId);
        showParameter.setCustomParam("paramcloudid", (Object)"");
        showParameter.setCustomParam("paramappid", (Object)appParam.getAppId());
        showParameter.setCustomParam("viewtype", (Object)"15");
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator)) {
            showParameter.setHasRight(true);
        }
        this.getView().showForm((FormShowParameter)showParameter);
        this.getModel().setValue("orgfield", (Object)orgId);
        this.getPageCache().put("paramviewid", showParameter.getPageId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        long orgId = 100000L;
        if ("donothing_save".equals(operateKey)) {
            String pageId = this.getPageCache().get("paramviewid");
            IFormView parameterView = this.getView().getView(pageId);
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            String msg = "";
            if (parameterView != null) {
                try {
                    IDataModel parameterModel = (IDataModel)parameterView.getService(IDataModel.class);
                    DynamicObject dataEntity = parameterModel.getDataEntity();
                    DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
                    binder.setOnlyDbProperty(false);
                    DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                    jser.setSerializeComplexProperty(false);
                    String jsonString = jser.serializeToString((Object)dataEntity, null);
                    Map jsonStringMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
                    DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
                    for (IDataEntityProperty p : properties) {
                        if (!(p instanceof BooleanProp) || ((BooleanProp)p).getDefValue() == null || jsonStringMap.get(p.getName()) != null) continue;
                        if (((Boolean)((BooleanProp)p).getDefValue()).booleanValue()) {
                            jsonStringMap.put(p.getName(), Boolean.TRUE);
                            continue;
                        }
                        jsonStringMap.put(p.getName(), Boolean.FALSE);
                    }
                    jsonString = SerializationUtils.toJsonString((Object)jsonStringMap);
                    IParameterModel model = (IParameterModel)parameterModel;
                    DynamicObject orgfield = (DynamicObject)this.getModel().getValue("orgfield");
                    this.getModel().setValue("orgfield", (Object)orgId);
                    AppParam apm = PERF_PARAM_CONFIG_APPLICATION_SERVICE.assembleAppInfo(orgId);
                    ParameterWriter.saveSystemParameter((AppParam)apm, (String)jsonString);
                    if (null != model.getOrgId() && model.getOrgId().equals(orgId)) {
                        LocalCacheUtils.remove((String)(RequestContext.get().getAccountId() + "_commonparameters"));
                    }
                    msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PbsAppParamConfigPlugin_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(msg);
                    AppLogInfo logInfo = this.buildLogInfo(msg, orgfield.getLong("id"));
                    logService.addLog(logInfo);
                }
                catch (Exception e) {
                    LOG.error("it is failed to save paramConfig cause e:", (Throwable)e);
                }
            }
        }
    }

    private AppLogInfo buildLogInfo(String msg, Long orgId) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        String bizApppnumber = this.getView().getFormShowParameter().getAppId();
        String bizAppid = BizAppServiceHelp.getAppIdByAppNumber((String)bizApppnumber);
        logInfo.setBizAppID(bizAppid);
        logInfo.setBizObjID(this.getView().getEntityId());
        logInfo.setOrgID(orgId);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"PbsAppParamConfigPlugin_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
        logInfo.setOpDescription(msg);
        return logInfo;
    }
}

