/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.pot;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.pbs.business.domain.pot.entity.PotSubView;
import kd.opmc.pbs.business.domain.pot.enums.PotFlexPanelEnum;

public class MemberInfoBillEdit
extends HRDynamicFormBasePlugin
implements RowClickEventListener {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getControl("cardentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Vector delPotVector = (Vector)this.getControl("deletepotvector");
        delPotVector.addClickListener((ClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = (String)args.getVarMap().get("source.operateKey");
        if (HRStringUtils.equals((String)operateKey, (String)"savenew") || HRStringUtils.equals((String)operateKey, (String)"saveandnew")) {
            this.saveOperation(operateKey);
        } else if (HRStringUtils.equals((String)operateKey, (String)"exit")) {
            this.exitOperation();
        }
    }

    private void exitOperation() {
        String potMap = this.getPageCache().get("tapPagePotMap");
        if (HRStringUtils.isEmpty((String)potMap)) {
            this.getView().invokeOperation("close");
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\u672a\u4fdd\u5b58\uff0c\u786e\u8ba4\u76f4\u63a5\u9000\u51fa\uff1f", (String)"MemberInfoBillEdit_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("exit", (IFormPlugin)this));
    }

    private void saveOperation(String operateKey) {
        String potMap = this.getPageCache().get("tapPagePotMap");
        if (HRStringUtils.isEmpty((String)potMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ee9\u6548\u56e2\u961f\u7ec4\u7ec7", (String)"MemberInfoBillEdit_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<Long, Integer> tabMemberSizeMap = this.getTabMemberSizeMap(potMap);
        boolean allEmpty = tabMemberSizeMap.entrySet().stream().allMatch(item -> (Integer)item.getValue() == 0);
        if (allEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u6ca1\u6709\u6dfb\u52a0\u4efb\u4f55\u4e00\u540d\u6210\u5458", (String)"MemberInfoBillEdit_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
        } else {
            List<Long> potIds = tabMemberSizeMap.entrySet().stream().filter(item -> (Integer)item.getValue() == 0).map(Map.Entry::getKey).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(potIds)) {
                this.showMemberSuccess(operateKey);
            } else {
                this.showMemberConfirm(potIds, operateKey);
            }
        }
    }

    private void showMemberConfirm(List<Long> potIds, String operateKey) {
        StringBuffer nameBuffer = new StringBuffer();
        for (Long potId : potIds) {
            this.appendPotName(nameBuffer, potId);
        }
        String nameString = nameBuffer.toString().substring(0, nameBuffer.toString().lastIndexOf(12289));
        this.getView().showConfirm(ResManager.loadKDString((String)"{0}\u4e0b\u8fd8\u6ca1\u6709\u6dfb\u52a0\u6210\u5458\uff0c\u786e\u5b9a\u8981\u4fdd\u5b58\u5417\uff1f", (String)"MemberInfoBillEdit_3", (String)"opmc-pbs-formplugin", (Object[])new Object[]{nameString}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operateKey, (IFormPlugin)this));
    }

    private void appendPotName(StringBuffer nameBuffer, Long potId) {
        DynamicObjectCollection potList = (DynamicObjectCollection)this.getModel().getDataEntity().get("pot");
        String name = potList.stream().filter(item -> item.get("fbasedataid_id").equals(potId)).map(item -> {
            DynamicObject dy = (DynamicObject)item.get("fbasedataid");
            return dy.get("name").toString();
        }).findAny().orElse("");
        nameBuffer.append('[');
        nameBuffer.append(name);
        nameBuffer.append(']');
        nameBuffer.append('\u3001');
    }

    private void showMemberSuccess(String operateKey) {
        String potMap = this.getPageCache().get("tapPagePotMap");
        if (HRStringUtils.isEmpty((String)potMap)) {
            return;
        }
        Map tapPagePotMap = (Map)JSONObject.parseObject((String)potMap, (TypeReference)new TypeReference<Map<String, PotSubView>>(){}, (Feature[])new Feature[0]);
        StringBuffer message = new StringBuffer();
        for (Map.Entry tabPotRef : tapPagePotMap.entrySet()) {
            IFormView orgTeamView;
            PotSubView potSubView = (PotSubView)tabPotRef.getValue();
            if (HRStringUtils.isEmpty((String)potSubView.getPotId()) || ObjectUtils.isEmpty((Object)(orgTeamView = this.getView().getView(potSubView.getPageId())))) continue;
            orgTeamView.invokeOperation("save");
            String validaRes = orgTeamView.getPageCache().get("pot_member_validate");
            if (!HRStringUtils.isNotEmpty((String)validaRes) || !HRStringUtils.equals((String)"false", (String)validaRes)) continue;
            Long potId = Long.valueOf(potSubView.getPotId());
            this.appendPotName(message, potId);
        }
        if (HRStringUtils.isNotEmpty((String)message.toString())) {
            String nameString = message.toString().substring(0, message.toString().lastIndexOf(12289));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c{0}\u201d\u4e0b\u7684\u5fc5\u586b\u9879\u3002", (String)"MemberInfoBillEdit_4", (String)"opmc-pbs-formplugin", (Object[])new Object[]{nameString}));
            return;
        }
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"MemberInfoBillEdit_5", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
        if (HRStringUtils.equals((String)operateKey, (String)"saveandnew")) {
            this.getView().getParentView().invokeOperation("tbladdmember");
        }
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    private Map<Long, Integer> getTabMemberSizeMap(String potMap) {
        HashMap<Long, Integer> potMemberSizeMap = new HashMap<Long, Integer>(16);
        Map tapPagePotMap = (Map)JSONObject.parseObject((String)potMap, (TypeReference)new TypeReference<Map<String, PotSubView>>(){}, (Feature[])new Feature[0]);
        for (Map.Entry tabPotRef : tapPagePotMap.entrySet()) {
            IFormView subPageView;
            IFormView orgTeamView;
            PotSubView potSubView = (PotSubView)tabPotRef.getValue();
            if (HRStringUtils.isEmpty((String)potSubView.getPotId()) || ObjectUtils.isEmpty((Object)(orgTeamView = this.getView().getView(potSubView.getPageId()))) || ObjectUtils.isEmpty((Object)(subPageView = orgTeamView.getView(orgTeamView.getPageCache().get("memberSubPageId"))))) continue;
            int size = subPageView.getModel().getEntryEntity("entryentity").size();
            potMemberSizeMap.put(Long.parseLong(potSubView.getPotId()), size);
        }
        return potMemberSizeMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Vector vector = (Vector)evt.getSource();
        if (!vector.getKey().equals("deletepotvector")) {
            return;
        }
        CardEntry entry = (CardEntry)this.getView().getControl("cardentity");
        DynamicObjectCollection oldValues = (DynamicObjectCollection)this.getModel().getValue("pot");
        DynamicObjectCollection newValues = new DynamicObjectCollection(oldValues.getDynamicObjectType(), oldValues.getParent());
        newValues.addAll((Collection)oldValues);
        newValues.remove(newValues.get(entry.getSelectRows()[0]));
        this.getModel().setValue("pot", (Object)newValues);
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry entry = (CardEntry)evt.getSource();
        if (!entry.getEntryKey().equals("cardentity")) {
            return;
        }
        DynamicObjectCollection cardEntityList = this.getModel().getEntryEntity("cardentity");
        String currentPotId = ((DynamicObject)cardEntityList.get(evt.getRow())).getString("tabname_id");
        String potMap = this.getPageCache().get("tapPagePotMap");
        Map tapPagePotMap = (Map)JSONObject.parseObject((String)potMap, (TypeReference)new TypeReference<Map<String, PotSubView>>(){}, (Feature[])new Feature[0]);
        Tab tab = (Tab)this.getView().getControl("pot_tab");
        for (Map.Entry tabPotRef : tapPagePotMap.entrySet()) {
            PotSubView potSubView = (PotSubView)tabPotRef.getValue();
            if (!HRStringUtils.equals((String)potSubView.getPotId(), (String)currentPotId)) continue;
            tab.activeTab((String)tabPotRef.getKey());
            break;
        }
        for (int i = 0; i < cardEntityList.size(); ++i) {
            this.getModel().setValue("underlineval", (Object)"", i);
        }
        this.getModel().setValue("underlineval", (Object)currentPotId);
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey = changedArgs.getProperty().getName();
        if (!HRStringUtils.equals((String)"pot", (String)fieldKey)) {
            return;
        }
        ChangeData[] changeSet = changedArgs.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        DynamicObjectCollection oldValues = (DynamicObjectCollection)changeSet[0].getOldValue();
        DynamicObjectCollection newValues = (DynamicObjectCollection)changeSet[0].getNewValue();
        Map<String, PotSubView> tabPotMap = this.getTapPagePotMap();
        if (this.isShowTip(newValues, oldValues)) {
            return;
        }
        this.maintainRelationship(newValues, tabPotMap);
        this.createCardEntity(newValues);
        this.defaultSetting(tabPotMap);
    }

    private void defaultSetting(Map<String, PotSubView> tabPageMap) {
        Tab potTab = (Tab)this.getView().getControl("pot_tab");
        for (Map.Entry<String, PotSubView> tabPotRef : tabPageMap.entrySet()) {
            PotSubView potSubView = tabPotRef.getValue();
            String potId = potSubView.getPotId();
            if (!HRStringUtils.isNotEmpty((String)potId)) continue;
            this.getView().getControl("cardentity").getModel().setValue("underlineval", (Object)potId);
            potTab.activeTab(tabPotRef.getKey());
            break;
        }
        this.showMemberSubPage(tabPageMap);
        this.getPageCache().put("tapPagePotMap", JSONObject.toJSONString(tabPageMap));
    }

    private void showMemberSubPage(Map<String, PotSubView> tabPageMap) {
        for (Map.Entry<String, PotSubView> tabPotRef : tabPageMap.entrySet()) {
            PotSubView potSubView = tabPotRef.getValue();
            String potId = potSubView.getPotId();
            String pageId = potSubView.getPageId();
            if (HRStringUtils.isEmpty((String)potId) || HRStringUtils.isNotEmpty((String)pageId)) continue;
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setPkId((Object)Long.parseLong(potId));
            showParameter.setFormId("pbs_projectorgteam_mlist");
            showParameter.getOpenStyle().setTargetKey(PotFlexPanelEnum.getPanelByTabName((String)tabPotRef.getKey()));
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.setCustomParam("isMemberBatchView", (Object)Boolean.TRUE);
            String subPageId = showParameter.getPageId();
            potSubView.setPageId(subPageId);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void maintainRelationship(DynamicObjectCollection newValues, Map<String, PotSubView> tabPageMap) {
        List newIds = newValues.stream().map(newValue -> newValue.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
        for (Map.Entry<String, PotSubView> tabPotRef : tabPageMap.entrySet()) {
            String potId;
            PotSubView potSubView = tabPotRef.getValue();
            if (ObjectUtils.isEmpty((Object)potSubView) || !HRStringUtils.isNotEmpty((String)(potId = potSubView.getPotId())) || newIds.contains(potId)) continue;
            tabPageMap.put(tabPotRef.getKey(), new PotSubView("", ""));
        }
        block1: for (Map.Entry<String, PotSubView> tabPotRef : tabPageMap.entrySet()) {
            for (String newPotId : newIds) {
                PotSubView potSubView = tabPotRef.getValue();
                List potIds = tabPageMap.values().stream().map(PotSubView::getPotId).collect(Collectors.toList());
                if (potIds.contains(newPotId) || !HRStringUtils.isEmpty((String)potSubView.getPotId())) continue;
                potSubView.setPotId(newPotId);
                tabPageMap.put(tabPotRef.getKey(), potSubView);
                continue block1;
            }
        }
    }

    private Map<String, PotSubView> getTapPagePotMap() {
        if (HRStringUtils.isEmpty((String)this.getPageCache().get("tapPagePotMap"))) {
            HashMap<String, PotSubView> tapPagePotMap = new HashMap<String, PotSubView>(16);
            tapPagePotMap.put("pot_tab_one", new PotSubView("", ""));
            tapPagePotMap.put("pot_tab_two", new PotSubView("", ""));
            tapPagePotMap.put("pot_tab_three", new PotSubView("", ""));
            tapPagePotMap.put("pot_tab_four", new PotSubView("", ""));
            tapPagePotMap.put("pot_tab_five", new PotSubView("", ""));
            return tapPagePotMap;
        }
        return (Map)JSONObject.parseObject((String)this.getPageCache().get("tapPagePotMap"), (TypeReference)new TypeReference<Map<String, PotSubView>>(){}, (Feature[])new Feature[0]);
    }

    private void createCardEntity(DynamicObjectCollection potCollection) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("tabname", new Object[0]);
        for (DynamicObject pot : potCollection) {
            setter.addRow(new Object[]{pot.getDynamicObject("fbasedataid").getLong("id")});
        }
        model.deleteEntryData("cardentity");
        model.batchCreateNewEntryRow("cardentity", setter);
        model.endInit();
        this.getView().updateView("cardentity");
    }

    private boolean isShowTip(DynamicObjectCollection newValues, DynamicObjectCollection oldValues) {
        if (newValues.size() > 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u6700\u591a\u54115\u4e2a\u56e2\u961f\u4e2d\u6dfb\u52a0\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u56e2\u961f", (String)"MemberInfoBillEdit_6", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            this.getView().getFormShowParameter().setCustomParam("isFillBackOldVal", (Object)Boolean.TRUE);
            this.getModel().setValue("pot", (Object)(oldValues.isEmpty() ? null : oldValues));
            return true;
        }
        Boolean isFillBackOldVal = (Boolean)this.getView().getFormShowParameter().getCustomParam("isFillBackOldVal");
        if (!ObjectUtils.isEmpty((Object)isFillBackOldVal) && isFillBackOldVal.booleanValue()) {
            return false;
        }
        List oldIds = oldValues.stream().map(oldValue -> oldValue.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
        List newIds = newValues.stream().map(newValue -> newValue.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
        Boolean isFirst = (Boolean)this.getView().getFormShowParameter().getCustomParam("isFirst");
        if (this.isDelOrUpdate(newIds.containsAll(oldIds), ObjectUtils.isEmpty((Object)isFirst) || isFirst != false)) {
            this.getView().getPageCache().put("newValues", SerializationUtils.serializeToBase64((Object)newValues));
            this.getView().getPageCache().put("oldValues", SerializationUtils.serializeToBase64((Object)oldValues));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u9009\u7684\u56e2\u961f\u88ab\u6e05\u9664\u540e\uff0c\u672c\u6b21\u65b0\u589e\u56e2\u961f\u7684\u6210\u5458\u4fe1\u606f\u5c06\u4e0d\u4f1a\u88ab\u4fdd\u5b58\uff0c\u786e\u5b9a\u8981\u6e05\u9664\u5417\uff1f", (String)"MemberInfoBillEdit_7", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del_pot_call_back_id", (IFormPlugin)this));
            return true;
        }
        return false;
    }

    private boolean isDelOrUpdate(boolean isContainsAll, boolean isFirst) {
        return !isContainsAll && isFirst;
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        String callBackId = closedEvent.getCallBackId();
        if (HRStringUtils.equals((String)"del_pot_call_back_id", (String)callBackId)) {
            this.delPotConfirm(closedEvent);
        } else if (HRStringUtils.equals((String)"saveandnew", (String)callBackId) || HRStringUtils.equals((String)"savenew", (String)callBackId)) {
            if (closedEvent.getResult() == MessageBoxResult.Yes && this.hasNewPermission().booleanValue()) {
                this.showMemberSuccess(callBackId);
            }
        } else if (HRStringUtils.equals((String)"exit", (String)callBackId) && closedEvent.getResult() == MessageBoxResult.Yes) {
            this.exitConfirm();
        }
    }

    private Boolean hasNewPermission() {
        long userId = UserServiceHelper.getCurrentUserId();
        String appId = "24BC1SMQXGOE";
        try {
            if (!PermissionServiceHelper.hasNewPermission((long)userId, (String)appId, (String)"pbs_projectorgteam")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7ee9\u6548\u7ec4\u7ec7\u56e2\u961f\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MemberInfoBillEdit_8", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            if (!PermissionServiceHelper.hasNewPermission((long)userId, (String)appId, (String)"pbs_addmembers")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6dfb\u52a0\u56e2\u961f\u6210\u5458\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MemberInfoBillEdit_9", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception exception) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"MemberInfoBillEdit_10", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
    }

    private void exitConfirm() {
        String potMap = this.getPageCache().get("tapPagePotMap");
        if (HRStringUtils.isEmpty((String)potMap)) {
            return;
        }
        Map tapPagePotMap = (Map)JSONObject.parseObject((String)potMap, (TypeReference)new TypeReference<Map<String, PotSubView>>(){}, (Feature[])new Feature[0]);
        for (Map.Entry tabPotRef : tapPagePotMap.entrySet()) {
            PotSubView potSubView = (PotSubView)tabPotRef.getValue();
            IFormView orgTeamView = this.getView().getView(potSubView.getPageId());
            if (ObjectUtils.isEmpty((Object)orgTeamView)) continue;
            orgTeamView.invokeOperation("close");
        }
        this.getView().invokeOperation("close");
    }

    private void delPotConfirm(MessageBoxClosedEvent closedEvent) {
        this.getView().getFormShowParameter().setCustomParam("isFirst", (Object)Boolean.FALSE);
        DynamicObjectCollection oldValues = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("oldValues"));
        DynamicObjectCollection newValues = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("newValues"));
        if (newValues.size() <= 0 && closedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("tapPagePotMap", "");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("cardentity");
            Tab tab = (Tab)this.getView().getControl("pot_tab");
            tab.activeTab("nodatatab");
        }
        this.getModel().setValue("pot", (Object)(closedEvent.getResult() == MessageBoxResult.Yes ? newValues : oldValues));
    }
}

