/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.pot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.pbs.business.application.service.pot.PotLabelApplicationService;

public class PotLabelSubPageEdit
extends HRDataBaseEdit {
    private static final PotLabelApplicationService POT_LABEL_SERVICE = PotLabelApplicationService.getInstance();
    public static final String DELETE_LABEL_CONFIRM = "delete_label_confirm";
    public static final String CONFIRM_DELETE = "confirm_delete";

    public void propertyChanged(PropertyChangedArgs args) {
        if (HRStringUtils.equals((String)args.getProperty().getName(), (String)"label")) {
            return;
        }
        ChangeData[] changeSet = args.getChangeSet();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("pbs_potlabel");
        long potId = this.getPotId();
        for (ChangeData changeData : changeSet) {
            DynamicObject dynamicObject;
            int rowIndex = changeData.getRowIndex();
            DynamicObject rowData = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (ObjectUtils.isEmpty((Object)rowData.getDynamicObject("label"))) {
                dynamicObject = helper.generateEmptyDynamicObject();
                dynamicObject.set("status", (Object)"C");
                dynamicObject.set("enable", (Object)"1");
                dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("pot", (Object)potId);
                dynamicObject.set("isedit", (Object)"1");
            } else {
                dynamicObject = helper.queryOne((Object)rowData.getLong("label.id"));
            }
            DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
            Set ignoreKeys = properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
            List targetKeys = rowData.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
            ignoreKeys.removeAll(targetKeys);
            ignoreKeys.add("id");
            ignoreKeys.add("seq");
            HRDynamicObjectUtils.copy((DynamicObject)rowData, (DynamicObject)dynamicObject, ignoreKeys);
            OperateOption option = OperateOption.create();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pbs_potlabel", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)option);
            List ids = operationResult.getSuccessPkIds();
            if (ObjectUtils.isEmpty((Object)ids)) continue;
            this.getModel().setValue("label", ids.get(0), rowIndex);
        }
        this.loadCurrentLabelCache();
    }

    private long getPotId() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return 0L;
        }
        return (Long)parentView.getModel().getValue("id");
    }

    public void afterCreateNewData(EventObject event) {
        long potId;
        IFormView parentView;
        if (OperationStatus.VIEW == this.getView().getFormShowParameter().getStatus()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
        }
        if ((parentView = this.getView().getParentView()) == null) {
            return;
        }
        parentView.getPageCache().put("labelSubPageId", this.getView().getPageId());
        Object potId0 = this.getView().getFormShowParameter().getCustomParam("potId");
        long l = potId = potId0 == null ? 0L : Long.parseLong(potId0.toString());
        if (0L == potId) {
            return;
        }
        Object[] labelDys = POT_LABEL_SERVICE.queryLabels(potId);
        if (ObjectUtils.isEmpty((Object[])labelDys)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("name", new Object[0]);
        vs.addField("description", new Object[0]);
        vs.addField("index", new Object[0]);
        vs.addField("label", new Object[0]);
        for (Object labelDy : labelDys) {
            vs.addRow(new Object[]{labelDy.get("name"), labelDy.get("description"), labelDy.get("index"), labelDy.getLong("id")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        this.loadCurrentLabelCache();
    }

    private void loadCurrentLabelCache() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List currentMemberIds = entryEntity.stream().filter(dy -> dy.getDynamicObject("label") != null && HRStringUtils.equals((String)dy.getDynamicObject("label").getString("enable"), (String)"1")).map(dy -> dy.getDynamicObject("label").getLong("id")).collect(Collectors.toList());
        parentView.getPageCache().put("current_pot_label", SerializationUtils.toJsonString(currentMemberIds));
    }

    public void pageRelease(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String labelIdStr = parentView.getPageCache().get("current_pot_label");
        List labelIds = StringUtils.isEmpty((CharSequence)labelIdStr) ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)labelIdStr, List.class);
        POT_LABEL_SERVICE.deleteEditLabelById(labelIds);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)source.getOperateKey())) {
            this.doDeleteLabel(args);
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)source.getOperateKey())) {
            args.setCancel(true);
            Long potId = (Long)this.getView().getParentView().getModel().getValue("id");
            DynamicObjectCollection entryEntity2 = this.getModel().getEntryEntity("entryentity");
            POT_LABEL_SERVICE.saveLabels(entryEntity2, potId);
        } else if (HRStringUtils.equals((String)"disablelabel", (String)source.getOperateKey())) {
            List<DynamicObject> selectDys = this.getSelectedEntry();
            if (this.emptyValidate(args, selectDys)) {
                return;
            }
            List<DynamicObject> usedLabels = this.getUsedLabels(selectDys);
            if (ObjectUtils.isEmpty(usedLabels)) {
                boolean disableSuccess = POT_LABEL_SERVICE.disable(selectDys);
                args.setCancel(!disableSuccess);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u82e5\u8981\u7981\u7528\u6807\u7b7e\uff0c\u8bf7\u5148\u5c06\u6807\u7b7e\u4ece\u6210\u5458\u8eab\u4e0a\u79fb\u9664\u3002", (String)"PotLabelSubPageEdit_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            }
        } else if (HRStringUtils.equals((String)"enablelabel", (String)source.getOperateKey())) {
            List<DynamicObject> selectDys = this.getSelectedEntry();
            if (this.emptyValidate(args, selectDys)) {
                return;
            }
            boolean enableSuccess = POT_LABEL_SERVICE.enable(selectDys);
            args.setCancel(!enableSuccess);
        } else if (HRStringUtils.equals((String)"newentry", (String)source.getOperateKey()) && (entryEntity = this.getModel().getEntryEntity("entryentity")).size() >= 100) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6807\u7b7e\u6570\u91cf\u5e94\u5c0f\u4e8e100\u3002", (String)"PotLabelSubPageEdit_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
        }
    }

    private void doDeleteLabel(BeforeDoOperationEventArgs args) {
        Boolean confirmDelete = (Boolean)this.getView().getFormShowParameter().getCustomParam(CONFIRM_DELETE);
        if (null != confirmDelete && confirmDelete.booleanValue()) {
            this.getView().getFormShowParameter().setCustomParam(CONFIRM_DELETE, (Object)Boolean.FALSE);
            return;
        }
        args.setCancel(true);
        List<DynamicObject> selectDys = this.getSelectedEntry();
        List<DynamicObject> usedLabels = this.getUsedLabels(selectDys);
        String msg = ObjectUtils.isEmpty(usedLabels) ? ResManager.loadKDString((String)"\u5220\u9664\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u5220\u9664\uff1f", (String)"PotLabelSubPageEdit_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u7ecf\u6253\u4e0a\u6807\u7b7e\u7684\u6210\u5458\u4e5f\u5c06\u540c\u6b65\u5220\u9664\u6807\u7b7e\u4fe1\u606f\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"PotLabelSubPageEdit_3", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DELETE_LABEL_CONFIRM, (IFormPlugin)this));
    }

    private boolean emptyValidate(BeforeDoOperationEventArgs args, List<DynamicObject> selectDys) {
        if (ObjectUtils.isEmpty(selectDys)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PotLabelSubPageEdit_4", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private List<DynamicObject> getSelectedEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<DynamicObject> selectDys = new ArrayList<DynamicObject>(64);
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                selectDys.add((DynamicObject)entryEntity.get(selectRow));
            }
        }
        return selectDys;
    }

    public void afterAddRow(AfterAddRowEventArgs args) {
        super.afterAddRow(args);
        if (HRStringUtils.equals((String)args.getEntryProp().getName(), (String)"entryentity")) {
            RowDataEntity[] rowData = args.getRowDataEntities();
            int rowIndex = rowData[0].getRowIndex();
            if (rowIndex < 1) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            DynamicObject maxIndexDy = entryEntity.stream().max(Comparator.comparingInt(dy -> dy.getInt("index"))).orElse(null);
            int indexValue = maxIndexDy == null ? 0 : maxIndexDy.getInt("index") + 1;
            indexValue = Math.min(indexValue, 99);
            this.getModel().setValue("index", (Object)indexValue, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("deleteentry".equals(args.getOperateKey()) || HRStringUtils.equals((String)"enablelabel", (String)args.getOperateKey())) {
            this.loadCurrentLabelCache();
        }
    }

    private List<DynamicObject> getUsedLabels(List<DynamicObject> selectDys) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return new ArrayList<DynamicObject>(10);
        }
        String memberSubPageId = parentView.getPageCache().get("memberSubPageId");
        IFormView memberSubView = this.getView().getView(memberSubPageId);
        if (ObjectUtils.isEmpty((Object)memberSubView)) {
            return new ArrayList<DynamicObject>(10);
        }
        Set selectIdSet = selectDys.stream().filter(select -> !ObjectUtils.isEmpty((Object)select.getDynamicObject("label"))).map(select -> select.getDynamicObject("label").getLong("id")).collect(Collectors.toSet());
        HashSet usedLabelSet = new HashSet(16);
        DynamicObjectCollection memberData = memberSubView.getModel().getEntryEntity("entryentity");
        for (DynamicObject member : memberData) {
            DynamicObjectCollection labels = member.getDynamicObjectCollection("grouplabel");
            Set usedLabelId = labels.stream().map(label -> {
                DynamicObject basedata = label.getDynamicObject("fbasedataid");
                return basedata == null ? 0L : basedata.getLong("id");
            }).filter(selectIdSet::contains).collect(Collectors.toSet());
            usedLabelSet.addAll(usedLabelId);
        }
        return selectDys.stream().filter(select -> !ObjectUtils.isEmpty((Object)select.getDynamicObject("label"))).filter(select -> usedLabelSet.contains(select.getDynamicObject("label").getLong("id"))).collect(Collectors.toList());
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (HRStringUtils.equals((String)event.getCallBackId(), (String)DELETE_LABEL_CONFIRM) && MessageBoxResult.Yes == event.getResult()) {
            List<DynamicObject> selectDys = this.getSelectedEntry();
            List deleteIds = selectDys.stream().filter(select -> !ObjectUtils.isEmpty((Object)select.getDynamicObject("label"))).filter(selectDy -> selectDy.getDynamicObject("label").getBoolean("isedit")).map(dy -> dy.getDynamicObject("label").getLong("id")).collect(Collectors.toList());
            POT_LABEL_SERVICE.deleteLabelById(deleteIds);
            this.getView().getFormShowParameter().setCustomParam(CONFIRM_DELETE, (Object)Boolean.TRUE);
            this.getView().invokeOperation("deleteentry");
        }
    }
}

