/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.pot;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.pbs.business.application.service.pot.PotMemberApplicationService;
import kd.opmc.pbs.business.domain.pot.enums.TeamRoleEnum;

public class PotMemberPageEdit
extends HRDataBaseEdit
implements BasedataEditListener,
BeforeF7SelectListener {
    private static final PotMemberApplicationService POT_MEMBER_SERVICE = PotMemberApplicationService.getInstance();
    public static final String[] F7ARR = new String[]{"parent", "grouplabel", "teamrole"};

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter parameter = args.getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        if (HRStringUtils.equals((String)status.name(), (String)"EDIT")) {
            String caption = ResManager.loadKDString((String)"\u53d8\u66f4\u56e2\u961f\u6210\u5458\u4fe1\u606f", (String)"PotMemberPageEdit_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
            parameter.setCaption(caption);
        }
    }

    public void afterBindingData(AfterBindingDataEvent event) {
        DynamicObject bindObject = (DynamicObject)event.getDataEntity();
        String personName = bindObject.getString("person.name");
        event.setDisplayProp(personName);
        event.setEditSearchProp(bindObject.getString("person.number"));
    }

    public void initialize() {
        super.initialize();
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        if (!HRObjectUtils.isEmpty((Object)parent)) {
            parent.addBasedataEditListener((BasedataEditListener)this);
        }
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        for (String f7 : F7ARR) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(f7);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7 = ((Control)beforeF7SelectEvent.getSource()).getKey();
        QFilter qFilter = null;
        if (StringUtils.equals((CharSequence)"parentf7", (CharSequence)f7) || StringUtils.equals((CharSequence)"parent", (CharSequence)f7)) {
            long potId = this.getModel().getDataEntity().getLong("pot_id");
            DynamicObject[] memberDys = POT_MEMBER_SERVICE.queryMembers(potId);
            List currentMemberIds = Arrays.stream(memberDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            qFilter = new QFilter("id", "in", currentMemberIds);
        } else if (StringUtils.equals((CharSequence)"teamrole", (CharSequence)f7)) {
            qFilter = new QFilter("id", "not in", (Object)new Long[]{TeamRoleEnum.TEAM_ADMIN.getRoleId(), TeamRoleEnum.TEAM_LEADER.getRoleId()});
        } else if (StringUtils.equals((CharSequence)"grouplabel", (CharSequence)f7)) {
            long potId = this.getModel().getDataEntity().getLong("pot_id");
            DynamicObject[] labels = POT_MEMBER_SERVICE.queryLabelByPotId(potId);
            List labelIds = Arrays.stream(labels).map(label -> label.getLong("id")).collect(Collectors.toList());
            qFilter = new QFilter("id", "in", labelIds);
        }
        beforeF7SelectEvent.getCustomQFilters().add(qFilter);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "parent": {
                ChangeData[] changeSet = args.getChangeSet();
                DynamicObject parent = (DynamicObject)changeSet[0].getNewValue();
                DynamicObject pMember = POT_MEMBER_SERVICE.queryOne("parent,teamrole", Long.valueOf(parent.getLong("id")));
                if (pMember.getLong("teamrole_id") == TeamRoleEnum.TEAM_MEMBER.getRoleId().longValue()) {
                    this.getView().getPageCache().put("groupLeader", SerializationUtils.serializeToBase64((Object)pMember));
                }
                BillList billList = (BillList)this.getView().getParentView().getControl("billlistap");
                ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
                Long pkId = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject member = POT_MEMBER_SERVICE.queryOne("parent,longnumber", pkId);
                member.set("parent", (Object)parent.getLong("id"));
                member.set("longnumber", (Object)(parent.getString("longnumber") + "." + member.getString("number")));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String groupLeader;
        super.afterDoOperation(args);
        if ("save".equals(args.getOperateKey()) && HRStringUtils.isNotEmpty((String)(groupLeader = this.getView().getPageCache().get("groupLeader")))) {
            DynamicObject pMember = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)groupLeader);
            pMember.set("teamrole", (Object)TeamRoleEnum.GROUP_LEADER.getRoleId());
            POT_MEMBER_SERVICE.updateOne(pMember);
        }
    }
}

