/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.pot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.pbs.business.application.service.pot.PotMemberApplicationService;
import kd.opmc.pbs.business.domain.pot.enums.TeamRoleEnum;

public class PotMemberSubPageEdit
extends HRDataBaseEdit
implements BasedataEditListener,
BeforeF7SelectListener {
    private static final PotMemberApplicationService POT_MEMBER_SERVICE = PotMemberApplicationService.getInstance();
    private static final String DEPEMP_F7 = "depempf7";
    private static final String TEAMROLE_F7 = "teamrolef7";
    private static final String PARENT_F7 = "parentf7";
    private static final String GROUPLABEL_F7 = "grouplabelf7";
    private static final String SETPARENT = "setparent";
    private static final String SETTEAMROLE = "setteamrole";
    private static final String ADDMEMBER = "addmember";
    private static final String SETLABEL = "setlabel";
    private static final Map<String, String> OP_MAP = new HashMap<String, String>(new HashMap<String, String>(){
        private static final long serialVersionUID = 6480982132388547216L;
        {
            this.put(PotMemberSubPageEdit.ADDMEMBER, PotMemberSubPageEdit.DEPEMP_F7);
            this.put(PotMemberSubPageEdit.SETTEAMROLE, PotMemberSubPageEdit.TEAMROLE_F7);
            this.put(PotMemberSubPageEdit.SETPARENT, PotMemberSubPageEdit.PARENT_F7);
            this.put(PotMemberSubPageEdit.SETLABEL, PotMemberSubPageEdit.GROUPLABEL_F7);
        }
    });
    public static final String CURRENT_POT_MEMBER = "current_pot_member";
    public static final String CURRENT_POT_PERSON = "current_pot_person";
    public static final String CURRENT_POT_LEADER = "current_pot_leader";
    public static final String[] F7ARR = new String[]{"depempf7", "parentf7", "grouplabelf7", "teamrolef7", "parent", "grouplabel", "teamrole"};
    public static final String NEW_TEAM_LEADER_NUM = "newTeamLeaderNum";
    public static final String OLD_TEAM_LEADER_NUM = "oldTeamLeaderNum";
    public static final String LEADER_LONG_NUM_RECODE = "leaderLongNumRecode";

    public void afterCreateNewData(EventObject event) {
        DynamicObject[] memberDys;
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        parentView.getPageCache().put("memberSubPageId", this.getView().getPageId());
        long potId = this.getCustomOfId("potId");
        long adminOrgId = this.getCustomOfId("adminOrgId");
        if (0L != potId) {
            if (this.isMemberBatchView()) {
                List memberIds = (List)parentView.getFormShowParameter().getCustomParam("potMemberList");
                memberDys = POT_MEMBER_SERVICE.loadDynamicObjectArray(memberIds);
            } else {
                memberDys = POT_MEMBER_SERVICE.queryMembers(potId);
            }
        } else {
            if (adminOrgId != 0L) {
                this.dispatch(adminOrgId, this.getTeamLeaderId(), this.getEffectDate());
                return;
            }
            return;
        }
        this.loadEntryData(memberDys);
        if (OperationStatus.VIEW == this.getView().getFormShowParameter().getStatus()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
        }
    }

    private void dispatch(long adminOrgId, long teamLeaderId, Date effectDate) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("pbs");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.opmc.pbs.business.task.PotMemberInsTask");
        HashMap<String, Comparable<Long>> params = new HashMap<String, Comparable<Long>>(16);
        params.put("adminOrgId", Long.valueOf(adminOrgId));
        params.put("teamLeaderId", Long.valueOf(teamLeaderId));
        params.put("effectDate", effectDate);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u5458\u540d\u5355", (String)"PotMemberSubPageEdit_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(false);
        jobFormInfo.setCanStop(false);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private long getTeamLeaderId() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return 0L;
        }
        DynamicObject teamLeader = (DynamicObject)parentView.getModel().getValue("teamleader");
        return ObjectUtils.isEmpty((Object)teamLeader) ? 0L : teamLeader.getLong("id");
    }

    private Date getEffectDate() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return new Date();
        }
        return (Date)parentView.getModel().getValue("effectdate");
    }

    private void loadEntryData(DynamicObject[] memberDys) {
        memberDys = (DynamicObject[])Arrays.stream(memberDys).sorted((o1, o2) -> {
            Long teamRoleId1 = this.getTeamRoleId((DynamicObject)o1);
            Long teamRoleId2 = this.getTeamRoleId((DynamicObject)o2);
            return teamRoleId1.compareTo(teamRoleId2);
        }).toArray(DynamicObject[]::new);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("depemp", new Object[0]);
        vs.addField("person", new Object[0]);
        vs.addField("teamrole", new Object[0]);
        vs.addField("parent", new Object[0]);
        vs.addField("effectdate", new Object[0]);
        vs.addField("grouplabel", new Object[0]);
        vs.addField("empposrel", new Object[0]);
        vs.addField("cmember", new Object[0]);
        vs.addField("longnumber", new Object[0]);
        for (DynamicObject memberDy : memberDys) {
            Long teamRoleId = this.getTeamRoleId(memberDy);
            Long parentId = memberDy.getLong("parent.id");
            if (!TeamRoleEnum.TEAM_LEADER.getRoleId().equals(teamRoleId) && parentId.equals(0L)) {
                parentId = this.getPotTeamLeaderId();
            }
            vs.addRow(new Object[]{memberDy.get("depemp.id"), memberDy.get("person.id"), teamRoleId, parentId, memberDy.get("effectdate"), memberDy.get("grouplabel"), memberDy.get("empposrel.id"), memberDy.getLong("id"), memberDy.getString("longnumber")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        this.loadCurrentMemberCache();
    }

    private long getTeamRoleId(DynamicObject memberDy) {
        return memberDy.getLong("teamrole.id") == 0L ? memberDy.getLong("teamrole") : memberDy.getLong("teamrole.id");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)source.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<DynamicObject> selectDys = new ArrayList<DynamicObject>(64);
            if (selectRows != null && selectRows.length > 0) {
                for (int selectRow : selectRows) {
                    DynamicObject selectDy2 = (DynamicObject)entryEntity.get(selectRow);
                    selectDys.add(selectDy2);
                    if (!this.isTeamLeader(selectDy2)) continue;
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u56e2\u961f\u8d1f\u8d23\u4eba\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PotMemberSubPageEdit_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.refreshParent(entryEntity, selectRows);
            }
            List deleteMemberIds = selectDys.stream().filter(selectDy -> selectDy.getDynamicObject("cmember").getBoolean("isedit")).map(dy -> dy.getDynamicObject("cmember").getLong("id")).collect(Collectors.toList());
            POT_MEMBER_SERVICE.deleteMemberById(deleteMemberIds);
            List disableMemberIds = selectDys.stream().filter(selectDy -> !selectDy.getDynamicObject("cmember").getBoolean("isedit")).map(dy -> dy.getDynamicObject("cmember").getLong("id")).collect(Collectors.toList());
            this.getView().getPageCache().put("disableMemberIds", SerializationUtils.toJsonString(disableMemberIds));
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)source.getOperateKey())) {
            Long potId = (Long)this.getView().getParentView().getModel().getValue("id");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            List<Long> potMemberIds = this.getIdListOfCache(CURRENT_POT_MEMBER);
            POT_MEMBER_SERVICE.saveMembers(entryEntity, potId, potMemberIds);
            POT_MEMBER_SERVICE.disableMemberById(this.getIdListOfCache("disableMemberIds"));
        } else if (StringUtils.equals((CharSequence)"close", (CharSequence)source.getOperateKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            List editMemberIds = entryEntity.stream().filter(selectDy -> selectDy.getDynamicObject("cmember").getBoolean("isedit")).map(dy -> dy.getDynamicObject("cmember").getLong("id")).collect(Collectors.toList());
            POT_MEMBER_SERVICE.deleteMemberById(editMemberIds);
        }
    }

    private void refreshParent(DynamicObjectCollection entryEntity, int[] selectRows) {
        for (int selectRow : selectRows) {
            DynamicObject selectDy = (DynamicObject)entryEntity.get(selectRow);
            long cMemberId = selectDy.getDynamicObject("cmember").getLong("id");
            DynamicObject teamLeader = this.getTeamLeader(entryEntity);
            if (teamLeader == null) continue;
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject member = (DynamicObject)entryEntity.get(i);
                if (cMemberId != member.getLong("parent_id")) continue;
                String teamLeaderNum = teamLeader.getString("number");
                String cNum = member.getDynamicObject("cmember").getString("number");
                this.getModel().setValue("longnumber", (Object)(teamLeaderNum + "." + cNum), i);
                this.getModel().setValue("parent", (Object)teamLeader.getLong("id"), i);
            }
        }
    }

    private DynamicObject getTeamLeader(DynamicObjectCollection entryEntity) {
        DynamicObject teamLeaderRow = entryEntity.stream().filter(dy -> {
            DynamicObject memberDy = dy.getDynamicObject("cmember");
            Long teamRoleId = this.getTeamRoleId(memberDy);
            return TeamRoleEnum.TEAM_LEADER.getRoleId().equals(teamRoleId);
        }).findFirst().orElse(null);
        return teamLeaderRow == null ? null : teamLeaderRow.getDynamicObject("cmember");
    }

    private boolean isTeamLeader(DynamicObject selectDy) {
        long teamRoleId = this.getTeamRoleId(selectDy.getDynamicObject("cmember"));
        return TeamRoleEnum.TEAM_LEADER.getRoleId().equals(teamRoleId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        String f7Key = OP_MAP.get(operateKey);
        if (!ObjectUtils.isEmpty((Object)f7Key)) {
            if (!(StringUtils.equals((CharSequence)ADDMEMBER, (CharSequence)operateKey) || this.isMustSelectRows() && !this.isTeamLeaderOp(operateKey))) {
                return;
            }
            this.clickF7(f7Key);
        }
        if ("deleteentry".equals(operateKey)) {
            this.loadCurrentMemberCache();
        } else if ("updateteamleader".equals(operateKey)) {
            this.doChangeTeamLeader();
        } else if ("save".equals(operateKey) && this.isMemberBatchView()) {
            long potId = this.getCustomOfId("potId");
            DynamicObject[] memberList = POT_MEMBER_SERVICE.queryMembers(potId);
            Set parentIds = Arrays.stream(memberList).map(member -> {
                DynamicObject dy = member.getDynamicObject("parent");
                if (ObjectUtils.isEmpty((Object)dy)) {
                    return 0L;
                }
                return dy.getLong("id");
            }).collect(Collectors.toSet());
            for (DynamicObject member2 : memberList) {
                long currentId = member2.getLong("id");
                if (!parentIds.contains(currentId) || member2.getLong("teamrole_id") != TeamRoleEnum.TEAM_MEMBER.getRoleId().longValue()) continue;
                member2.set("teamrole", (Object)TeamRoleEnum.GROUP_LEADER.getRoleId());
            }
            POT_MEMBER_SERVICE.updateDatas(memberList);
        }
    }

    private void doChangeTeamLeader() {
        DynamicObject newTeamLeader;
        long teamLeaderId = this.getTeamLeaderId();
        DynamicObjectCollection memberList = this.getModel().getEntryEntity("entryentity");
        List memberIdList = memberList.stream().map(member -> member.getLong("depemp.id")).collect(Collectors.toList());
        if (!memberIdList.contains(teamLeaderId)) {
            DynamicObject[] memberDys = POT_MEMBER_SERVICE.initPotMemberByDemEmp(Collections.singletonList(teamLeaderId), teamLeaderId, this.getEffectDate(), false);
            this.loadEntryData(memberDys);
        }
        if (ObjectUtils.isEmpty((Object)(newTeamLeader = (DynamicObject)memberList.stream().filter(member -> member.getLong("depemp.id") == teamLeaderId).findFirst().orElse(null)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u56e2\u961f\u4e0d\u5b58\u5728\u56e2\u961f\u8d1f\u8d23\u4eba\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7ef4\u62a4", (String)"PotMemberSubPageEdit_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject newCMember = newTeamLeader.getDynamicObject("cmember");
        long newTeamLeaderMid = newCMember.getLong("id");
        HashMap<String, String> leaderLongNumRecode = new HashMap<String, String>(16);
        String newTeamLeaderNum = newCMember.getString("number");
        leaderLongNumRecode.put(NEW_TEAM_LEADER_NUM, newTeamLeaderNum);
        String oldTeamLeaderNum = "";
        long oldTeamLeaderMid = 0L;
        for (int i = 0; i < memberList.size(); ++i) {
            boolean isNewTeamLeader;
            DynamicObject member2 = (DynamicObject)memberList.get(i);
            DynamicObject cMember = member2.getDynamicObject("cmember");
            boolean bl = isNewTeamLeader = member2.getLong("depemp.id") == teamLeaderId;
            if (TeamRoleEnum.TEAM_LEADER.getRoleId().equals(this.getTeamRoleId(cMember)) && !isNewTeamLeader) {
                this.getModel().setValue("teamrole", (Object)TeamRoleEnum.TEAM_MEMBER.getRoleId(), i);
                oldTeamLeaderNum = cMember.getString("number");
                leaderLongNumRecode.put(OLD_TEAM_LEADER_NUM, oldTeamLeaderNum);
                this.getPageCache().put(LEADER_LONG_NUM_RECODE, SerializationUtils.serializeToBase64(leaderLongNumRecode));
                this.getModel().setValue("parent", (Object)newTeamLeaderMid, i);
                oldTeamLeaderMid = cMember.getLong("id");
                continue;
            }
            if (isNewTeamLeader) {
                this.getModel().setValue("teamrole", (Object)TeamRoleEnum.TEAM_LEADER.getRoleId(), i);
                this.getModel().setValue("longnumber", (Object)newTeamLeaderNum, i);
                this.getModel().setValue("parent", null, i);
                continue;
            }
            if (oldTeamLeaderMid == member2.getLong("parent_id")) {
                this.getModel().setValue("parent", (Object)newTeamLeaderMid, i);
                continue;
            }
            String longNum = cMember.getString("longnumber");
            if (longNum.startsWith(oldTeamLeaderNum)) {
                longNum = longNum.replaceAll(oldTeamLeaderNum, newTeamLeaderNum);
            }
            this.getModel().setValue("longnumber", (Object)longNum, i);
        }
        this.loadCurrentMemberCache();
        this.getView().getParentView().sendFormAction(this.getView());
    }

    private boolean isTeamLeaderOp(String operateKey) {
        if (StringUtils.equals((CharSequence)SETTEAMROLE, (CharSequence)operateKey) || StringUtils.equals((CharSequence)SETPARENT, (CharSequence)operateKey)) {
            int[] selectRows;
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int selectRow : selectRows = entry.getSelectRows()) {
                if (!this.isTeamLeader((DynamicObject)entryEntity.get(selectRow))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u56e2\u961f\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4fee\u6539\u3002", (String)"PotMemberSubPageEdit_3", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void loadCurrentMemberCache() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List currentMemberIds = entryEntity.stream().map(dy -> dy != null && dy.getDynamicObject("cmember") != null ? dy.getDynamicObject("cmember").getLong("id") : 0L).collect(Collectors.toList());
        List currentPersonIds = entryEntity.stream().map(dy -> dy != null && dy.getDynamicObject("cmember") != null ? dy.getDynamicObject("cmember").getLong("person.id") : 0L).collect(Collectors.toList());
        DynamicObject teamLeader = this.getTeamLeader(entryEntity);
        if (this.isMemberBatchView()) {
            long potId = this.getCustomOfId("potId");
            DynamicObject[] members = POT_MEMBER_SERVICE.queryMembers(potId);
            List memberIds = Arrays.stream(members).map(member -> member.getLong("id")).collect(Collectors.toList());
            currentMemberIds.addAll(memberIds);
            List personIds = Arrays.stream(members).map(member -> member.getLong("person.id")).collect(Collectors.toList());
            currentPersonIds.addAll(personIds);
            if (teamLeader == null) {
                teamLeader = Arrays.stream(members).filter(member -> {
                    Long teamRoleId = this.getTeamRoleId((DynamicObject)member);
                    return TeamRoleEnum.TEAM_LEADER.getRoleId().equals(teamRoleId);
                }).findFirst().orElse(null);
            }
        }
        this.getPageCache().put(CURRENT_POT_LEADER, String.valueOf(teamLeader == null ? 0L : teamLeader.getLong("id")));
        this.getPageCache().put(CURRENT_POT_MEMBER, SerializationUtils.toJsonString(currentMemberIds));
        this.getPageCache().put(CURRENT_POT_PERSON, SerializationUtils.toJsonString(currentPersonIds));
    }

    private boolean isMemberBatchView() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return false;
        }
        Boolean isMemberBatchView = (Boolean)parentView.getFormShowParameter().getCustomParam("isMemberBatchView");
        return isMemberBatchView != null && isMemberBatchView != false;
    }

    private long getCustomOfId(String potId2) {
        Object potId0 = this.getView().getFormShowParameter().getCustomParam(potId2);
        return potId0 == null ? 0L : Long.parseLong(potId0.toString());
    }

    private boolean isMustSelectRows() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entry.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u5458", (String)"PotMemberSubPageEdit_4", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void clickF7(String f7) {
        BasedataEdit baseData = (BasedataEdit)this.getControl(f7);
        baseData.click();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        if (StringUtils.equals((CharSequence)"cmember", (CharSequence)args.getProperty().getName())) {
            return;
        }
        switch (propertyName = args.getProperty().getName()) {
            case "depempf7": {
                DynamicObjectCollection depEmps = (DynamicObjectCollection)this.getModel().getValue(DEPEMP_F7);
                if (ObjectUtils.isEmpty((Object)depEmps)) {
                    return;
                }
                List depEmpIds = depEmps.stream().map(depEmp -> depEmp.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                DynamicObject[] memberDys = POT_MEMBER_SERVICE.initPotMemberByDemEmp(depEmpIds, this.getTeamLeaderId(), this.getEffectDate(), false);
                this.loadEntryData(memberDys);
                depEmps.clear();
                this.getModel().setValue(DEPEMP_F7, (Object)depEmps);
                break;
            }
            case "teamrolef7": {
                this.setF7Value2Entry(TEAMROLE_F7, "teamrole");
                break;
            }
            case "parentf7": {
                this.setF7Value2Entry(PARENT_F7, "parent");
                break;
            }
            case "parent": {
                ChangeData[] changeSet = args.getChangeSet();
                DynamicObject parent = (DynamicObject)changeSet[0].getNewValue();
                DynamicObjectCollection memberList = this.getModel().getEntryEntity("entryentity");
                if (ObjectUtils.isEmpty((Object)parent)) break;
                this.setGroupLeader(parent.getLong("id"), memberList);
                this.updateLongNumber(parent, memberList, changeSet[0].getRowIndex());
                break;
            }
            case "grouplabelf7": {
                this.setF7Value2Entry(GROUPLABEL_F7, "grouplabel");
                break;
            }
        }
    }

    private void setGroupLeader(long pMemberId, DynamicObjectCollection memberList) {
        for (int i = 0; i < memberList.size(); ++i) {
            long cMemberId = ((DynamicObject)memberList.get(i)).getDynamicObject("cmember").getLong("id");
            if (cMemberId != pMemberId) continue;
            long teamRoleId = ((DynamicObject)memberList.get(i)).getDynamicObject("teamrole").getLong("id");
            if (TeamRoleEnum.TEAM_LEADER.getRoleId().equals(teamRoleId) || TeamRoleEnum.GROUP_LEADER.getRoleId().equals(teamRoleId)) continue;
            this.getModel().setValue("teamrole", (Object)TeamRoleEnum.GROUP_LEADER.getRoleId(), i);
        }
    }

    private void updateLongNumber(DynamicObject parent, DynamicObjectCollection memberList, int rowIndex) {
        String pLongNumber = parent.getString("longnumber");
        DynamicObject cMember = ((DynamicObject)memberList.get(rowIndex)).getDynamicObject("cmember");
        String cNumber = cMember.getString("number");
        String leaderLongNumRecode = this.getPageCache().get(LEADER_LONG_NUM_RECODE);
        if (HRStringUtils.isNotEmpty((String)leaderLongNumRecode)) {
            Map LongNumRecodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)leaderLongNumRecode);
            String oldTeamLeaderNum = (String)LongNumRecodeMap.get(OLD_TEAM_LEADER_NUM);
            String newTeamLeaderNum = (String)LongNumRecodeMap.get(NEW_TEAM_LEADER_NUM);
            if (HRStringUtils.isNotEmpty((String)oldTeamLeaderNum) && HRStringUtils.isNotEmpty((String)newTeamLeaderNum)) {
                if (cNumber.equals(oldTeamLeaderNum)) {
                    pLongNumber = pLongNumber.replaceAll(pLongNumber, newTeamLeaderNum);
                } else if (pLongNumber.startsWith(oldTeamLeaderNum + ".")) {
                    if (pLongNumber.contains(newTeamLeaderNum)) {
                        pLongNumber = pLongNumber.replaceAll("." + newTeamLeaderNum, "");
                    }
                    pLongNumber = pLongNumber.replaceAll(oldTeamLeaderNum, newTeamLeaderNum);
                }
            }
        }
        this.getModel().setValue("longnumber", (Object)(pLongNumber + "." + cNumber), rowIndex);
    }

    private long getPotTeamLeaderId() {
        String idStr = this.getPageCache().get(CURRENT_POT_LEADER) == null ? "0" : this.getPageCache().get(CURRENT_POT_LEADER);
        return Long.parseLong(idStr);
    }

    private void setF7Value2Entry(String f7Name, String entryField) {
        int[] selectRows;
        Object f7Value = this.getModel().getValue(f7Name);
        if (ObjectUtils.isEmpty((Object)f7Value)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        for (int selectRow : selectRows = entryGrid.getSelectRows()) {
            this.getModel().setValue(entryField, f7Value, selectRow);
        }
        this.getModel().setValue(f7Name, null);
    }

    public void initialize() {
        super.initialize();
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        if (!HRObjectUtils.isEmpty((Object)parent)) {
            parent.addBasedataEditListener((BasedataEditListener)this);
        }
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        for (String f7 : F7ARR) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(f7);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindingData(AfterBindingDataEvent event) {
        DynamicObject bindObject = (DynamicObject)event.getDataEntity();
        String personName = bindObject.getString("person.name");
        event.setDisplayProp(personName);
        event.setEditSearchProp(bindObject.getString("person.number"));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String f7 = ((Control)beforeF7SelectEvent.getSource()).getKey();
        QFilter customQFilter = null;
        if (StringUtils.equals((CharSequence)DEPEMP_F7, (CharSequence)f7)) {
            List<Long> potPerson = this.getIdListOfCache(CURRENT_POT_PERSON);
            customQFilter = new QFilter("hrpi_empentrel.laborreltype.id", "in", (Object)1010L);
            customQFilter.and(new QFilter("hrpi_empentrel.laborrelstatus.id", "in", (Object)new Long[]{1010L, 1020L}));
            if (!ObjectUtils.isEmpty(potPerson)) {
                customQFilter.and(new QFilter("person", "not in", potPerson));
            }
        } else if (StringUtils.equals((CharSequence)PARENT_F7, (CharSequence)f7) || StringUtils.equals((CharSequence)"parent", (CharSequence)f7)) {
            List<Long> potMemberIds = this.getIdListOfCache(CURRENT_POT_MEMBER);
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection memberList = this.getModel().getEntryEntity("entryentity");
            for (int row : selectRows) {
                String longNum = ((DynamicObject)memberList.get(row)).getDynamicObject("cmember").getString("longnumber");
                List idList = memberList.stream().filter(member -> member.getString("longnumber").startsWith(longNum)).map(member -> member.getDynamicObject("cmember")).map(member -> member.getLong("id")).collect(Collectors.toList());
                potMemberIds.removeAll(idList);
            }
            customQFilter = this.getFilter(customQFilter, potMemberIds);
        } else if (StringUtils.equals((CharSequence)GROUPLABEL_F7, (CharSequence)f7) || StringUtils.equals((CharSequence)"grouplabel", (CharSequence)f7)) {
            String labelIdStr = this.getView().getParentView().getPageCache().get("current_pot_label");
            List labelIds = StringUtils.isEmpty((CharSequence)labelIdStr) ? new ArrayList(10) : (List)SerializationUtils.fromJsonString((String)labelIdStr, List.class);
            customQFilter = this.getFilter(customQFilter, labelIds);
            customQFilter = customQFilter == null ? new QFilter("pot", "=", (Object)this.getCustomOfId("potId")) : customQFilter;
        } else if ((StringUtils.equals((CharSequence)TEAMROLE_F7, (CharSequence)f7) || StringUtils.equals((CharSequence)"teamrole", (CharSequence)f7)) && this.isCanChangeRole(beforeF7SelectEvent)) {
            ArrayList<Long> roleIds = new ArrayList<Long>(8);
            roleIds.add(TeamRoleEnum.GROUP_LEADER.getRoleId());
            roleIds.add(TeamRoleEnum.TEAM_MEMBER.getRoleId());
            customQFilter = new QFilter("id", "in", roleIds);
        }
        if (customQFilter != null) {
            beforeF7SelectEvent.getCustomQFilters().add(customQFilter);
        }
    }

    private boolean isCanChangeRole(BeforeF7SelectEvent beforeF7SelectEvent) {
        Set parentIds;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length <= 0) {
            return false;
        }
        int selectRow = selectRows[0];
        DynamicObjectCollection memberList = this.getModel().getEntryEntity("entryentity");
        DynamicObject member = (DynamicObject)memberList.get(selectRow);
        DynamicObject teamRole = member.getDynamicObject("teamrole");
        if (ObjectUtils.isEmpty((Object)teamRole)) {
            return true;
        }
        long selectRoleId = teamRole.getLong("id");
        long memberId = member.getDynamicObject("cmember").getLong("id");
        if (selectRoleId == TeamRoleEnum.GROUP_LEADER.getRoleId() && (parentIds = memberList.stream().map(row -> {
            DynamicObject dy = row.getDynamicObject("parent");
            if (ObjectUtils.isEmpty((Object)dy)) {
                return 0L;
            }
            return dy.getLong("id");
        }).collect(Collectors.toSet())).contains(memberId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u5458\u5728\u56e2\u961f\u4e2d\u8fd8\u6709\u4e0b\u5c5e\uff0c\u4e0d\u80fd\u53d8\u66f4\u56e2\u961f\u89d2\u8272", (String)"PotMemberSubPageEdit_5", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return false;
        }
        return true;
    }

    private List<Long> getIdListOfCache(String cacheKey) {
        String potMemberStr = this.getPageCache().get(cacheKey);
        if (HRStringUtils.isEmpty((String)potMemberStr)) {
            return new ArrayList<Long>(10);
        }
        return (List)SerializationUtils.fromJsonString((String)potMemberStr, List.class);
    }

    private QFilter getFilter(QFilter customQFilter, List<Long> currentDepEmpIds) {
        if (!ObjectUtils.isEmpty(currentDepEmpIds)) {
            customQFilter = new QFilter("id", "in", currentDepEmpIds);
        }
        return customQFilter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            if (!result.containsKey("taskinfo")) {
                return;
            }
            String taskInfoStr = (String)result.get("taskinfo");
            if (StringUtils.isBlank((CharSequence)taskInfoStr)) {
                return;
            }
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (!taskInfo.isTaskEnd()) {
                return;
            }
            String data = taskInfo.getData();
            if (HRStringUtils.isEmpty((String)data)) {
                return;
            }
            Map memberDyMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            if (ObjectUtils.isEmpty((Object)memberDyMap)) {
                return;
            }
            Object memberDys = memberDyMap.get("memberDys");
            if (ObjectUtils.isEmpty(memberDys)) {
                return;
            }
            DynamicObject[] memberArr = (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)memberDys.toString());
            if (memberArr == null) {
                return;
            }
            this.loadEntryData(memberArr);
            if (OperationStatus.VIEW == this.getView().getFormShowParameter().getStatus()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
            }
        }
    }
}

