/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.pot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.application.service.pot.PotMemberApplicationService;

public class PotMemberTreeListPlugin
extends StandardTreeListPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener {
    private static final PotMemberApplicationService POT_MEMBER_SERVICE = PotMemberApplicationService.getInstance();

    public void setTreeListView(ITreeListView treeListView) {
        super.setTreeListView(treeListView);
        this.getView().setVisible(Boolean.TRUE, new String[]{"iscontainlower"});
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView tv1 = (TreeView)this.getView().getControl("treeview");
        tv1.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tv1.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"tbladdmember"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        TreeNode rootNode = this.getTreeModel().getRoot();
        rootNode.setChildren(this.buildTreeNode(rootNode.getId()));
        this.getTreeModel().setRoot(rootNode);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs eventArgs) {
        super.beforeDoOperation(eventArgs);
        FormOperate formOperate = (FormOperate)eventArgs.getSource();
        if (ObjectUtils.isEmpty((Object)formOperate)) {
            return;
        }
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.isEmpty((String)operateKey)) {
            return;
        }
        switch (operateKey) {
            case "tbladdmember": {
                this.clickAddMember();
                break;
            }
            case "modify": {
                this.clickModify(eventArgs);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        FormOperate formOperate = (FormOperate)eventArgs.getSource();
        if (ObjectUtils.isEmpty((Object)formOperate)) {
            return;
        }
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.isEmpty((String)operateKey)) {
            return;
        }
        switch (operateKey) {
            case "forbidden": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
                break;
            }
        }
    }

    private void clickModify(BeforeDoOperationEventArgs eventArgs) {
        ListSelectedRowCollection selectedRows = eventArgs.getListSelectedData();
        if (selectedRows.size() == 1) {
            Long pkId = Long.valueOf(selectedRows.get(0).getPrimaryKeyValue().toString());
            DynamicObject member = POT_MEMBER_SERVICE.queryOne(pkId);
            this.showEnableTip(eventArgs, member);
            return;
        }
        eventArgs.setCancel(true);
        List<Long> memberIds = selectedRows.stream().map(row -> Long.valueOf(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        DynamicObject[] memberList = POT_MEMBER_SERVICE.loadDynamicObjectArray(memberIds);
        Long potId = null;
        if (memberList != null && memberList.length > 0) {
            for (DynamicObject member : memberList) {
                DynamicObject pot = (DynamicObject)member.get("pot");
                if (ObjectUtils.isEmpty(potId)) {
                    potId = pot.getLong("id");
                    continue;
                }
                if (potId.longValue() != pot.getLong("id")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u540c\u4e00\u4e2a\u56e2\u961f\u4e0b\u7684\u6210\u5458\u6267\u884c\u6279\u91cf\u6210\u5458\u4fe1\u606f\u53d8\u66f4\uff0c\u8bf7\u68c0\u67e5\u9009\u4e2d\u7684\u6210\u5458\u4fe1\u606f", (String)"PotMemberTreeListPlugin_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.showEnableTip(eventArgs, member).booleanValue()) continue;
                return;
            }
        }
        this.openBatchUpdateMember(memberIds, potId);
    }

    private Boolean showEnableTip(BeforeDoOperationEventArgs eventArgs, DynamicObject member) {
        if (!member.get("enable").equals("1")) {
            eventArgs.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u53d8\u66f4\u5df2\u5931\u6548\u7684\u6210\u5458\u4fe1\u606f", (String)"PotMemberTreeListPlugin_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void openBatchUpdateMember(List<Long> idList, Long potId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("pbs_memberupdate_modify");
        showParameter.setPkId((Object)potId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("potMemberList", idList);
        showParameter.setCustomParam("isMemberBatchView", (Object)Boolean.TRUE);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void clickAddMember() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbs_addmembers");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (HRStringUtils.equals((String)"tblrefresh", (String)evt.getItemKey())) {
            this.refreshTreeView(this.getTreeModel().getRoot().getId());
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        super.treeNodeClick(treeNodeEvent);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public void setFilter(SetFilterEvent filterEvent) {
        DynamicObjectCollection potCollection;
        boolean isIdFilter;
        super.setFilter(filterEvent);
        List qFilters = filterEvent.getQFilters();
        if (CollectionUtils.isEmpty((Collection)qFilters)) {
            return;
        }
        for (QFilter qFilter2 : qFilters) {
            if (!qFilter2.getProperty().equals("parent")) continue;
            qFilters.remove(qFilter2);
            break;
        }
        if (!(isIdFilter = qFilters.stream().anyMatch(qFilter -> HRStringUtils.equals((String)qFilter.getProperty(), (String)"id")))) {
            qFilters.add(new QFilter("isedit", "=", (Object)"0"));
        }
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
            return;
        }
        ArrayList<Long> potIds = new ArrayList<Long>(10);
        potIds.add(Long.valueOf(currentNodeId));
        Boolean isContainLower = (Boolean)this.getModel().getValue("iscontainlower");
        if (isContainLower.booleanValue() && (potCollection = POT_MEMBER_SERVICE.queryPotByParentId(Long.valueOf(currentNodeId))).size() > 0) {
            potCollection.forEach(pot -> potIds.add((Long)pot.get("Id")));
        }
        qFilters.add(new QFilter("pot", "in", potIds));
    }

    public void search(SearchEnterEvent evt) {
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        String currentNodeId = (String)treeNodeEvent.getNodeId();
        this.refreshTreeView(currentNodeId);
    }

    private void refreshTreeView(String currentNodeId) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        ArrayList childNodes = this.buildTreeNode(currentNodeId);
        TreeNode currentNode = rootNode.getTreeNode(currentNodeId);
        currentNode.setChildren((List)(childNodes.size() > 0 ? childNodes : new ArrayList(10)));
        this.getTreeListView().getTreeView().updateNode(currentNode);
    }

    private List<TreeNode> buildTreeNode(String nodeId) {
        Long parentId = this.getTreeModel().getRoot().getId().equals(nodeId) ? Long.valueOf(0L) : Long.valueOf(nodeId);
        DynamicObjectCollection potCollection = POT_MEMBER_SERVICE.queryPotByParentId(parentId);
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(10);
        if (potCollection.size() > 0) {
            for (DynamicObject pot : potCollection) {
                String id = pot.getString("Id");
                String name = pot.getString("name");
                String enable = pot.getString("enable");
                if (!HRStringUtils.equals((String)"1", (String)enable)) continue;
                TreeNode node = new TreeNode(nodeId, id, name);
                childNodes.add(node);
                node.setChildren(this.buildTreeNode(id));
            }
        }
        return childNodes;
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        Boolean oldValue;
        String fieldKey = changedArgs.getProperty().getName();
        if (!HRStringUtils.equals((String)"iscontainlower", (String)fieldKey)) {
            return;
        }
        Boolean newValue = (Boolean)changedArgs.getChangeSet()[0].getNewValue();
        if (!newValue.equals(oldValue = (Boolean)changedArgs.getChangeSet()[0].getOldValue())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }
}

