/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.pot;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.BillViewPluginProxy;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.ParentBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.pbs.business.application.service.pot.ProjectOrgTeamApplicationService;
import kd.opmc.pbs.business.domain.pot.enums.POTStatusEnum;
import kd.opmc.pbs.business.domain.pot.enums.TeamRoleEnum;

public class ProjectOrgTeamEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
TabSelectListener {
    private static final ProjectOrgTeamApplicationService POT_SERVICE = ProjectOrgTeamApplicationService.getInstance();
    public static final String ADMIN_ORG_CONFIRM = "adminOrgConfirm";
    public static final String IS_CONFIRM_OP = "isConfirmOp";
    public static final String OLD_ADMIN_ORG = "oldAdminOrg";
    public static final String IS_ADMIN_ORG_CHANGE = "isAdminOrgChange";
    public static final String TRUE = "true";
    public static final String IS_TEAM_LEADER_CHANGE = "isTeamLeaderChange";
    public static final String ORIGIN_TEAM_LEADER_ID = "originTeamLeaderId";

    public void initialize() {
        super.initialize();
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit teamLeader = (BasedataEdit)this.getControl("teamleader");
        teamLeader.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit teamManager = (BasedataEdit)this.getControl("teammanager");
        teamManager.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (!ObjectUtils.isEmpty((Object)tab)) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (!HRStringUtils.equals((String)tabKey, (String)"tabpageap1")) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String isTeamLeaderChange = this.getView().getPageCache().get(IS_TEAM_LEADER_CHANGE);
        if (status.equals((Object)OperationStatus.EDIT) && HRStringUtils.isNotEmpty((String)isTeamLeaderChange) && isTeamLeaderChange.equals(TRUE)) {
            String msg = ResManager.loadKDString((String)"\u53d8\u66f4\u56e2\u961f\u8d1f\u8d23\u4eba\u5c06\u91cd\u6784\u56e2\u961f\u6c47\u62a5\u5173\u7cfb\uff0c\u662f\u5426\u4fdd\u5b58\u6b64\u53d8\u66f4\uff1f", (String)"ProjectOrgTeamEdit_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_TEAM_LEADER_CHANGE, (IFormPlugin)this));
            Tab tab = (Tab)evt.getSource();
            tab.activeTab("tabpageap");
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (args.getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            args.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u65b0\u8bbe\u56e2\u961f", (String)"ProjectOrgTeamEdit_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        Boolean isConfirmOp = (Boolean)this.getView().getFormShowParameter().getCustomParam(IS_CONFIRM_OP);
        if (!ObjectUtils.isEmpty((Object)isConfirmOp) && isConfirmOp.booleanValue()) {
            return;
        }
        switch (name = args.getProperty().getName()) {
            case "reforg": {
                Object refOrg = this.getModel().getValue("reforg");
                this.getModel().setValue("adminorg", refOrg);
                this.doAdminOrgChange(args);
                break;
            }
            case "isrootnode": {
                this.initRootNodeChange();
                break;
            }
            case "teamleader": {
                String isAdminOrgChange = this.getPageCache().get(IS_ADMIN_ORG_CHANGE);
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (!StringUtils.equals((CharSequence)isAdminOrgChange, (CharSequence)TRUE) && status.equals((Object)OperationStatus.ADDNEW)) {
                    this.showMemberSubPage();
                } else {
                    this.isChangeTeamLeader(args);
                }
                this.getPageCache().remove(IS_ADMIN_ORG_CHANGE);
                break;
            }
            case "effectdate": {
                String enable = (String)this.getModel().getValue("enable");
                Date effectDate = (Date)this.getModel().getValue("effectdate");
                POTStatusEnum statusEnum = POTStatusEnum.calculateTeamStatus((String)enable, (Date)effectDate);
                this.getModel().setValue("teamstatus", (Object)statusEnum.getValue());
                break;
            }
        }
    }

    private void isChangeTeamLeader(PropertyChangedArgs args) {
        DynamicObject oldValue = (DynamicObject)args.getChangeSet()[0].getOldValue();
        DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
        if (ObjectUtils.isEmpty((Object)oldValue) || ObjectUtils.isEmpty((Object)newValue)) {
            return;
        }
        String originTeamLeaderId = this.getView().getPageCache().get(ORIGIN_TEAM_LEADER_ID);
        if (HRStringUtils.isEmpty((String)originTeamLeaderId)) {
            String teamLeaderId = String.valueOf(oldValue.getLong("id"));
            this.getView().getPageCache().put(ORIGIN_TEAM_LEADER_ID, teamLeaderId);
            originTeamLeaderId = teamLeaderId;
        }
        this.getView().getPageCache().put(IS_TEAM_LEADER_CHANGE, Long.parseLong(originTeamLeaderId) != newValue.getLong("id") ? TRUE : "false");
    }

    private void updateTeamLeader() {
        String memberSubPageId = this.getView().getPageCache().get("memberSubPageId");
        IFormView view = this.getView().getView(memberSubPageId);
        if (null != view) {
            view.invokeOperation("updateteamleader");
        }
    }

    private void initRootNodeChange() {
        Boolean isRootNode = (Boolean)this.getModel().getValue("isrootnode");
        this.getView().setEnable(Boolean.valueOf(isRootNode == false), new String[]{"parent"});
        ParentBasedataEdit parent = (ParentBasedataEdit)this.getControl("parent");
        parent.setMustInput(isRootNode == false);
        if (isRootNode.booleanValue()) {
            this.getModel().setValue("parent", null);
        }
    }

    private void doAdminOrgChange(PropertyChangedArgs args) {
        DynamicObject oldAdminOrg = (DynamicObject)args.getChangeSet()[0].getOldValue();
        if (ObjectUtils.isEmpty((Object)oldAdminOrg)) {
            this.initMemberInfo();
            this.initOrgChangeInfo();
        } else {
            this.getPageCache().put(OLD_ADMIN_ORG, String.valueOf(oldAdminOrg.getLong("id")));
            String msg = ResManager.loadKDString((String)"\u53c2\u7167\u7ec4\u7ec7\u56e2\u961f\u53d8\u5316\u4f1a\u6e05\u7a7a\u5f53\u524d\u6210\u5458\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProjectOrgTeamEdit_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ADMIN_ORG_CONFIRM, (IFormPlugin)this));
        }
    }

    private void initMemberInfo() {
        Long adminOrgId = this.getAdminOrgId();
        List mainChargeInfo = POT_SERVICE.getMainChargeInfoByOrg(adminOrgId);
        if (!ObjectUtils.isEmpty((Object)mainChargeInfo)) {
            this.getPageCache().put(IS_ADMIN_ORG_CHANGE, TRUE);
            Object depEmp = ((Map)mainChargeInfo.get(0)).get("depemp");
            this.getModel().setValue("teamleader", (Object)(null == depEmp ? 0L : Long.parseLong(depEmp.toString())));
        }
    }

    private Long getAdminOrgId() {
        DynamicObject adminOrg = (DynamicObject)this.getModel().getValue("adminorg");
        return ObjectUtils.isEmpty((Object)adminOrg) ? 0L : adminOrg.getLong("id");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)ADMIN_ORG_CONFIRM)) {
            this.getView().getFormShowParameter().setCustomParam(IS_CONFIRM_OP, (Object)Boolean.TRUE);
            if (MessageBoxResult.Yes == event.getResult()) {
                this.initMemberInfo();
                this.initOrgChangeInfo();
            } else {
                Long oldAdminOrgId = Long.valueOf(this.getPageCache().get(OLD_ADMIN_ORG));
                this.getModel().setValue("adminorg", (Object)oldAdminOrgId);
                this.getModel().setValue("reforg", (Object)oldAdminOrgId);
            }
        } else if (StringUtils.equals((CharSequence)callBackId, (CharSequence)IS_TEAM_LEADER_CHANGE) && MessageBoxResult.Yes == event.getResult()) {
            this.updateTeamLeader();
            this.getView().invokeOperation("save");
            this.getView().getPageCache().remove(ORIGIN_TEAM_LEADER_ID);
            this.getView().getPageCache().remove(IS_TEAM_LEADER_CHANGE);
            Tab tab = (Tab)this.getView().getControl("tabap");
            if (!ObjectUtils.isEmpty((Object)tab)) {
                tab.activeTab("tabpageap1");
            }
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.initOrgChangeInfo();
        this.initRootNodeChange();
        this.showLabelManageSubPage();
    }

    private void initOrgChangeInfo() {
        this.setEffectRange();
        this.showMemberSubPage();
    }

    private void showLabelManageSubPage() {
        this.resetLabelInfo();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        Long adminOrgId = this.getAdminOrgId();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("pbs_potlabelsubpage");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("potlabelap");
        showParameter.setCustomParam("potId", (Object)pkValue);
        showParameter.setCustomParam("adminOrgId", (Object)adminOrgId);
        showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void resetLabelInfo() {
        String labelSubPageId = this.getView().getPageCache().get("labelSubPageId");
        IFormView view = this.getView().getView(labelSubPageId);
        if (null != view) {
            view.invokeOperation("close");
        }
    }

    private void showMemberSubPage() {
        this.resetMemberInfo();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        Long adminOrgId = this.getAdminOrgId();
        if (adminOrgId == 0L || ObjectUtils.isEmpty((Object)this.getModel().getValue("teamleader"))) {
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("pbs_potmembersubpage");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("potmemberap");
        showParameter.setCustomParam("potId", (Object)pkValue);
        showParameter.setCustomParam("adminOrgId", (Object)adminOrgId);
        showParameter.setSendToClient(true);
        showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void resetMemberInfo() {
        String memberSubPageId = this.getView().getPageCache().get("memberSubPageId");
        IFormView view = this.getView().getView(memberSubPageId);
        if (null != view) {
            view.invokeOperation("close");
        }
    }

    private void setEffectRange() {
        DynamicObject refOrg = (DynamicObject)this.getModel().getValue("reforg");
        if (refOrg != null && refOrg.getDate("bsed") != null) {
            DateEdit effectDate = (DateEdit)this.getControl("effectdate");
            effectDate.setMinDate(refOrg.getDate("bsed"));
            this.getModel().setValue("reforgdisabledate", (Object)HRDateTimeUtils.truncateDate((Date)refOrg.getDate("disabledate")));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String longNumber;
        String f7Name = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)f7Name, (CharSequence)"parent") && HRStringUtils.isNotEmpty((String)(longNumber = (String)this.getModel().getValue("longnumber")))) {
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("longnumber", "not like", (Object)(longNumber + "%")));
        }
        if (StringUtils.equals((CharSequence)f7Name, (CharSequence)"teammanager") || StringUtils.equals((CharSequence)f7Name, (CharSequence)"teamleader")) {
            QFilter customQFilter = new QFilter("hrpi_empentrel.laborreltype.id", "in", (Object)1010L);
            customQFilter.and(new QFilter("hrpi_empentrel.laborrelstatus.id", "in", (Object)new Long[]{1010L, 1020L}));
            event.getCustomQFilters().add(customQFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args == null || args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String formOp = args.getOperateKey();
        if (StringUtils.equals((CharSequence)formOp, (CharSequence)"close")) {
            this.resetMemberInfo();
            String memberSubPageId = this.getView().getPageCache().get("labelSubPageId");
            IFormView view = this.getView().getView(memberSubPageId);
            if (null != view) {
                view.invokeOperation("close");
            }
        } else if (StringUtils.equals((CharSequence)formOp, (CharSequence)"save")) {
            String memberSubPageId = this.getView().getPageCache().get("memberSubPageId");
            IFormView memberSubView = this.getView().getView(memberSubPageId);
            if (null != memberSubView) {
                memberSubView.invokeOperation("save");
            }
            String labelSubpageId = this.getView().getPageCache().get("labelSubPageId");
            IFormView labelSubView = this.getView().getView(labelSubpageId);
            if (null != labelSubView) {
                labelSubView.invokeOperation("save");
            }
            if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getFormId(), (String)"pbs_projectorgteam")) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ProjectOrgTeamEdit_3", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            } else {
                this.reload();
            }
        } else if (StringUtils.equals((CharSequence)formOp, (CharSequence)"modify")) {
            this.showMemberSubPage();
            this.showLabelManageSubPage();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String formOp = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)formOp, (CharSequence)"save")) {
            this.subPageValidate(args, "memberSubPageId", "membervalidate");
            this.subPageValidate(args, "labelSubPageId", "labelvalidate");
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            String isTeamLeaderChange = this.getView().getPageCache().get(IS_TEAM_LEADER_CHANGE);
            if (status.equals((Object)OperationStatus.EDIT) && HRStringUtils.isNotEmpty((String)isTeamLeaderChange) && isTeamLeaderChange.equals(TRUE)) {
                this.updateTeamLeader();
                this.getView().getPageCache().remove(ORIGIN_TEAM_LEADER_ID);
                this.getView().getPageCache().remove(IS_TEAM_LEADER_CHANGE);
            }
        } else if (StringUtils.equals((CharSequence)formOp, (CharSequence)"modify") && !POT_SERVICE.canUpdate((Long)this.getModel().getDataEntity().getPkValue())) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u56e2\u961f\u5df2\u5c01\u5b58\u3002", (String)"ProjectOrgTeamEdit_4", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        }
    }

    private void subPageValidate(BeforeDoOperationEventArgs args, String subPageKey, String validateOp) {
        String subPageId = this.getView().getPageCache().get(subPageKey);
        IFormView subView = this.getView().getView(subPageId);
        if (subView == null) {
            return;
        }
        this.getView().getPageCache().put("pot_member_validate", TRUE);
        OperationResult validateRes = subView.invokeOperation(validateOp);
        List memberValidateErrors = validateRes.getValidateResult().getValidateErrors();
        if (ObjectUtils.isEmpty((Object)memberValidateErrors)) {
            return;
        }
        ValidateResult validateResult = (ValidateResult)memberValidateErrors.get(0);
        List allErrorInfo = validateResult.getAllErrorInfo();
        for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
            if (HRStringUtils.equals((String)validateOp, (String)"membervalidate")) {
                int rowIndex = operateErrorInfo.getRowIndex();
                DynamicObjectCollection memberEntry = subView.getModel().getEntryEntity("entryentity");
                DynamicObject teamRole = ((DynamicObject)memberEntry.get(rowIndex)).getDynamicObject("teamrole");
                if (!ObjectUtils.isEmpty((Object)teamRole) && teamRole.getLong("id") == TeamRoleEnum.TEAM_LEADER.getRoleId().longValue()) continue;
            }
            String message = operateErrorInfo.getMessage();
            this.getView().showTipNotification(message);
            args.setCancel(true);
            this.getView().getPageCache().put("pot_member_validate", "false");
        }
    }

    private void reload() {
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (HRStringUtils.equals((String)"updatepot", (String)((String)parameter.getCustomParam("openOp")))) {
            MutexHelper.release((String)"pbs_projectorgteam", (String)"updatepot", (String)parameter.getPkId().toString());
        }
        IBillModel billModel = (IBillModel)this.getView().getModel();
        billModel.beginInit();
        billModel.setPKValue(this.getModel().getDataEntity().getPkValue());
        billModel.load(this.getModel().getDataEntity().getPkValue());
        ((BillViewPluginProxy)this.getView().getService(FormViewPluginProxy.class)).fireAfterLoadData(new EventObject(this.getView()));
        billModel.endInit();
        this.getView().setStatus(OperationStatus.VIEW);
        this.getView().updateView();
    }

    public void pageRelease(EventObject eventObject) {
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (OperationStatus.EDIT.equals((Object)parameter.getStatus()) && HRStringUtils.equals((String)"updatepot", (String)((String)parameter.getCustomParam("openOp")))) {
            MutexHelper.release((String)"pbs_projectorgteam", (String)"updatepot", (String)parameter.getPkId().toString());
        }
    }
}

