/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.pot;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.application.service.pot.ProjectOrgTeamApplicationService;

public class ProjectOrgTeamList
extends StandardTreeListPlugin {
    private static final ProjectOrgTeamApplicationService POT_SERVICE = ProjectOrgTeamApplicationService.getInstance();

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"name") && StringUtils.equals((CharSequence)this.getView().getEntityId(), (CharSequence)"bos_templatetreelist")) {
            Long pkId = (Long)this.getFocusRowPkId();
            this.showPotDetailPage(pkId, OperationStatus.VIEW);
        }
    }

    private void showPotDetailPage(Long pkId, OperationStatus status) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pbs_projectorgteam_edit");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(status);
        showParameter.setCustomParam("openOp", (Object)"updatepot");
        ListSelectedRow focusRow = this.getSelectedRows().stream().filter(select -> pkId.equals(select.getPrimaryKeyValue())).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)focusRow)) {
            showParameter.setCaption(focusRow.getName());
        }
        showParameter.setPkId((Object)pkId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String formOp = ((FormOperate)args.getSource()).getOperateKey();
        if (!StringUtils.equals((CharSequence)formOp, (CharSequence)"updatepot")) {
            return;
        }
        args.setCancel(true);
        ListSelectedRowCollection selectedData = args.getListSelectedData();
        if (selectedData.size() > 1) {
            String msg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u53d8\u66f4\u3002", (String)"ProjectOrgTeamList_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
        } else {
            Long primaryKeyValue = (Long)selectedData.get(0).getPrimaryKeyValue();
            if (!POT_SERVICE.canUpdate(primaryKeyValue)) {
                String msg = ResManager.loadKDString((String)"\u56e2\u961f\u5df2\u5c01\u5b58\u3002", (String)"ProjectOrgTeamList_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return;
            }
            MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(primaryKeyValue), null, null, "pbs_projectorgteam", formOp, true, "default");
            StringBuilder msg = new StringBuilder();
            boolean require = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)msg);
            if (require) {
                this.showPotDetailPage(primaryKeyValue, OperationStatus.EDIT);
            } else {
                this.getView().showTipNotification(msg.toString());
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (HRStringUtils.equals((String)"tblrefresh", (String)evt.getItemKey())) {
            this.refreshTreeView(this.getTreeModel().getRoot().getId());
        }
    }

    private void refreshTreeView(String currentNodeId) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        ArrayList childNodes = this.buildTreeNode(currentNodeId);
        TreeNode currentNode = rootNode.getTreeNode(currentNodeId);
        currentNode.setChildren((List)(childNodes.size() > 0 ? childNodes : new ArrayList(10)));
        this.getTreeListView().getTreeView().updateNode(currentNode);
    }

    private List<TreeNode> buildTreeNode(String nodeId) {
        Long parentId = this.getTreeModel().getRoot().getId().equals(nodeId) ? Long.valueOf(0L) : Long.valueOf(nodeId);
        DynamicObjectCollection potCollection = POT_SERVICE.queryPotByParentId(parentId);
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(10);
        if (potCollection.size() > 0) {
            for (DynamicObject pot : potCollection) {
                String id = pot.getString("Id");
                String name = pot.getString("name");
                String enable = pot.getString("enable");
                if (!HRStringUtils.equals((String)"1", (String)enable)) continue;
                TreeNode node = new TreeNode(nodeId, id, name);
                childNodes.add(node);
                node.setChildren(this.buildTreeNode(id));
            }
        }
        return childNodes;
    }
}

