/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.workflow;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportList;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuNodeEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;

public class FlowRuMonitorReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(FlowRuMonitorReportPlugin.class);
    private static final String CELL_ROW_PRE_VALUE = "CELL_ROW_PRE_VALUE";
    private static final String CHANGE_HANDLER = "changehandler";
    private static final String PROCESSOR = "processor";
    private static final String REPORT_LIST_AP = "reportlistap";
    private static final String NODE_NAME = "nodename";
    private static final String OPERATION = "operation";
    private static final String ISCROSSNODE = "iscrossnode";
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APP_SERVICE = FlowRuProcApplicationService.getInstance();

    public void initialize() {
        super.initialize();
        ReportList entryGrid = (ReportList)this.getView().getControl(REPORT_LIST_AP);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CHANGE_HANDLER});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().invokeOperation("refresh");
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        super.setCellStyleRules(cellStyleRules);
        for (FlowRuNodeStatusEnum flowRuNodeStatusEnum : FlowRuNodeStatusEnum.values()) {
            cellStyleRules.add(this.getCellStyleForeColor("nodestatus", flowRuNodeStatusEnum.getColour(), "nodestatus = '" + flowRuNodeStatusEnum.getCode() + "'"));
        }
        for (FlowRuNodeStatusEnum flowRuNodeStatusEnum : FlowRuRoleStatusEnum.values()) {
            cellStyleRules.add(this.getCellStyleForeColor("rolestatus", flowRuNodeStatusEnum.getColour(), "rolestatus = '" + flowRuNodeStatusEnum.getCode() + "'"));
        }
        for (FlowRuNodeStatusEnum flowRuNodeStatusEnum : FlowRuTaskStatusEnum.values()) {
            cellStyleRules.add(this.getCellStyleForeColor("taskstatus", flowRuNodeStatusEnum.getColour(), "taskstatus = '" + flowRuNodeStatusEnum.getCode() + "'"));
        }
        for (FlowRuNodeStatusEnum flowRuNodeStatusEnum : FlowRuTaskStatusEnum.values()) {
            cellStyleRules.add(this.getCellStyleForeColor("cotaskstatus", flowRuNodeStatusEnum.getColour(), "cotaskstatus = '" + flowRuNodeStatusEnum.getCode() + "'"));
        }
    }

    private CellStyleRule getCellStyleForeColor(String filedKey, String foreColor, String condition) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey(filedKey);
        cellStyleRule.setForeColor(foreColor);
        cellStyleRule.setCondition(condition);
        return cellStyleRule;
    }

    public void setMergeColums(List<String> columns) {
        super.setMergeColums(columns);
        columns.add(NODE_NAME);
        columns.add("nodestatus");
        columns.add("roletype");
        columns.add("rolestatus");
        columns.add("taskhandler");
        columns.add("taskstatus");
        columns.add("updatestatustime");
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject rowData = packageDataEvent.getRowData();
        ReportColumn reportColumn = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = reportColumn.getFieldKey();
        if ("updatestatustime".equals(fieldKey)) {
            HashMap<String, Object> preRowValue = new HashMap<String, Object>(16);
            preRowValue.put("runodebasedata.id", rowData.getLong("runodebasedata.id"));
            preRowValue.put("nodestatus", rowData.getString("nodestatus"));
            preRowValue.put("rurolebasedata.id", rowData.getLong("rurolebasedata.id"));
            preRowValue.put("rolestatus", rowData.getString("rolestatus"));
            this.getPageCache().put(CELL_ROW_PRE_VALUE, JSONObject.toJSONString(preRowValue));
            packageDataEvent.getNoMergeKey().add(reportColumn.getFieldKey());
        } else if ("nodestatus".equals(fieldKey) || "roletype".equals(fieldKey) || "rolestatus".equals(fieldKey)) {
            this.addNoMergeKey(packageDataEvent);
        } else if ("taskhandler".equals(fieldKey) || "taskstatus".equals(fieldKey)) {
            packageDataEvent.getNoMergeKey().add(reportColumn.getFieldKey());
        }
    }

    private void addNoMergeKey(PackageDataEvent packageDataEvent) {
        DynamicObject rowData = packageDataEvent.getRowData();
        ReportColumn reportColumn = (ReportColumn)packageDataEvent.getSource();
        String cellPreValueStr = this.getPageCache().get(CELL_ROW_PRE_VALUE);
        if (HRStringUtils.isNotEmpty((String)cellPreValueStr)) {
            Map cellPreValueMap = (Map)JSONObject.parseObject((String)cellPreValueStr, Map.class);
            if ("nodestatus".equals(reportColumn.getFieldKey()) && cellPreValueMap.get("nodestatus").equals(rowData.getString("nodestatus")) && !cellPreValueMap.get("runodebasedata.id").equals(rowData.getLong("runodebasedata.id"))) {
                packageDataEvent.getNoMergeKey().add(reportColumn.getFieldKey());
            } else if ("roletype".equals(reportColumn.getFieldKey()) && !cellPreValueMap.get("rurolebasedata.id").equals(rowData.getLong("rurolebasedata.id"))) {
                packageDataEvent.getNoMergeKey().add(reportColumn.getFieldKey());
            } else if ("rolestatus".equals(reportColumn.getFieldKey()) && !cellPreValueMap.get("rurolebasedata.id").equals(rowData.getLong("rurolebasedata.id"))) {
                packageDataEvent.getNoMergeKey().add(reportColumn.getFieldKey());
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Long procRuId = (Long)this.getView().getFormShowParameter().getCustomParams().get("PROC_RU_ID");
        Map customParam = queryParam.getCustomParam();
        customParam.put("PROC_RU_ID", procRuId);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Long procRuId = (Long)this.getView().getFormShowParameter().getCustomParams().get("PROC_RU_ID");
        DynamicObject ruProc = FlowRuProcEntityService.getInstance().queryRuProcByPk(procRuId);
        String workflowType = ruProc.getString("workflowtype");
        if (CollectionUtils.isNotEmpty((Collection)rowData)) {
            boolean index = false;
            HashMap<Long, ArrayList<DynamicObject>> coopTaskMap = new HashMap<Long, ArrayList<DynamicObject>>(16);
            ArrayList<Long> mainTaskIdList = new ArrayList<Long>(10);
            for (DynamicObject row : rowData) {
                DynamicObject task = row.getDynamicObject("rutaskbasedata");
                if (null == task) continue;
                mainTaskIdList.add(task.getLong("id"));
            }
            DynamicObject[] coopTaskDyns = FlowRuTaskEntityService.getInstance().loadCoopTasksByMainTaskIds(mainTaskIdList);
            if (null != coopTaskDyns && coopTaskDyns.length > 0) {
                for (DynamicObject coopTask : coopTaskDyns) {
                    ArrayList<DynamicObject> coopTaskList = (ArrayList<DynamicObject>)coopTaskMap.get(coopTask.getLong("hosttask.id"));
                    if (CollectionUtils.isEmpty((Collection)coopTaskList)) {
                        coopTaskList = new ArrayList<DynamicObject>(10);
                    }
                    coopTaskList.add(coopTask);
                    coopTaskMap.put(coopTask.getLong("hosttask.id"), coopTaskList);
                }
            }
            for (DynamicObject row : rowData) {
                String roleName;
                DynamicObject task = row.getDynamicObject("rutaskbasedata");
                DynamicObject nodeRu = row.getDynamicObject("runodebasedata");
                nodeRu = FlowRuNodeEntityService.getInstance().queryRuNodeByPk(Long.valueOf(nodeRu.getLong("id")));
                DynamicObject roleRu = row.getDynamicObject("rurolebasedata");
                if (!HRObjectUtils.isEmpty((Object)roleRu) && !HRStringUtils.isEmpty((String)(roleName = roleRu.getString("name")))) {
                    if (workflowType.equals("2")) {
                        row.set(NODE_NAME, row.get(NODE_NAME));
                        row.set("roletype", (Object)roleName);
                    } else if (workflowType.equals("1")) {
                        row.set(NODE_NAME, row.get(NODE_NAME));
                        row.set("roletype", (Object)roleName);
                    }
                }
                if (!HRObjectUtils.isEmpty((Object)task) && !task.getBoolean("iscotask")) {
                    List coopTaskList;
                    DynamicObject handler = task.getDynamicObject("handler");
                    if (null != handler) {
                        String number = handler.getString("number");
                        row.set("taskhandler", (Object)(handler.get("name") + " " + (HRStringUtils.isEmpty((String)number) ? "" : "  (" + number + ")")));
                    } else {
                        row.set("taskhandler", (Object)"");
                    }
                    if (nodeRu.getBoolean(ISCROSSNODE)) {
                        row.set(OPERATION, (Object)ResManager.loadKDString((String)"\u67e5\u770b\u4ea4\u53c9\u8282\u70b9", (String)"FlowRuMonitorReportPlugin_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    }
                    if (!CollectionUtils.isEmpty((Collection)(coopTaskList = (List)coopTaskMap.get(task.getLong("id"))))) {
                        StringBuilder coopHandlerSb = new StringBuilder();
                        for (DynamicObject coopTask : coopTaskList) {
                            DynamicObject coopHandler = coopTask.getDynamicObject("handler");
                            if (null == coopHandler || coopTask.getString("taskstatus").equals(FlowRuTaskStatusEnum.EXPIRED.getCode())) continue;
                            String number = coopHandler.getString("number");
                            coopHandlerSb.append(",");
                            coopHandlerSb.append(coopHandler.get("name")).append(" ");
                            coopHandlerSb.append(HRStringUtils.isEmpty((String)number) ? "" : "  (" + number + "-");
                            coopHandlerSb.append(FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)coopTask.getString("taskstatus")).getText()).append(")");
                        }
                        row.set("taskcohandler", (Object)coopHandlerSb.toString().replaceFirst(",", ""));
                        continue;
                    }
                    row.set("taskcohandler", (Object)"");
                    continue;
                }
                row.set("taskhandler", (Object)"-");
                row.set("taskstatus", (Object)"-");
            }
            Collections.sort(rowData, new SortByIndex());
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (CHANGE_HANDLER.equals(key)) {
            ReportList reportList = (ReportList)this.getControl(REPORT_LIST_AP);
            int[] rows = reportList.getEntryState().getSelectedRows();
            if (rows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d8\u66f4\u7684\u5904\u7406\u4eba\u3002", (String)"FlowRuMonitorReportPlugin_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (rows.length > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u8c03\u6574\u5904\u7406\u4eba\u3002", (String)"FlowRuMonitorReportPlugin_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long ruProcId = (Long)this.getView().getFormShowParameter().getCustomParams().get("PROC_RU_ID");
            String procStatus = FLOW_RU_PROC_APP_SERVICE.queryProcStatus(ruProcId);
            if (FlowRuProcStatusEnum.PENDING.getCode().equals(procStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5904\u7406\u6d41\u7a0b\u6302\u8d77\u5f02\u5e38\uff0c\u518d\u8fdb\u884c\u201c\u8c03\u6574\u5904\u7406\u4eba\u201d\u64cd\u4f5c\u3002", (String)"FlowRuMonitorReportPlugin_3", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject rowData = reportList.getReportModel().getRowData(rows[0]);
            DynamicObject task = rowData.getDynamicObject("rutaskbasedata");
            if (task == null || !FLOW_RU_PROC_APP_SERVICE.isAllowedChangeHandler((Long)task.getPkValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u201c\u5f85\u5904\u7406\u201d\u548c\u201c\u5904\u7406\u4e2d\u201d\u7684\u4efb\u52a1\uff0c\u8fdb\u884c\u201c\u8c03\u6574\u5904\u7406\u4eba\u201d\u64cd\u4f5c\u3002", (String)"FlowRuMonitorReportPlugin_4", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (CHANGE_HANDLER.equals(operateKey)) {
            Long ruProcId = (Long)this.getView().getFormShowParameter().getCustomParams().get("PROC_RU_ID");
            FLOW_RU_PROC_APP_SERVICE.pauseProcessForChangeHandler(ruProcId);
            BasedataEdit processor = (BasedataEdit)this.getView().getControl(PROCESSOR);
            processor.click();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        if (PROCESSOR.equals(fieldKey)) {
            DynamicObject bosUser = (DynamicObject)newValue;
            ReportList reportList = (ReportList)this.getControl(REPORT_LIST_AP);
            int[] rows = reportList.getEntryState().getSelectedRows();
            DynamicObject rowData = reportList.getReportModel().getRowData(rows[0]);
            DynamicObject task = rowData.getDynamicObject("rutaskbasedata");
            FLOW_RU_PROC_APP_SERVICE.changeHandler((Long)task.getPkValue(), (Long)bosUser.getPkValue());
            IFormView parentView = this.getView().getParentView();
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (HRStringUtils.equals((String)hyperLinkClickEvent.getFieldName(), (String)OPERATION)) {
            ReportList entryGrid = (ReportList)this.getView().getControl(REPORT_LIST_AP);
            DynamicObject row = entryGrid.getReportModel().getRowData(hyperLinkClickEvent.getRowIndex());
            DynamicObject node = row.getDynamicObject("runodebasedata");
            node = FlowRuNodeEntityService.getInstance().queryRuNodeByPk(Long.valueOf(node.getLong("id")));
            if (node.getBoolean(ISCROSSNODE)) {
                this.showFlowRuCrossNodeDetailReport(node.getLong("id"));
            }
        }
    }

    private void showFlowRuCrossNodeDetailReport(Long nodeId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("NODE_RU_ID", (Object)nodeId);
        showParameter.setFormId("pbs_flowrunodemonitor");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private static class SortByIndex
    implements Comparator<DynamicObject> {
        private SortByIndex() {
        }

        @Override
        public int compare(DynamicObject o1, DynamicObject o2) {
            try {
                Integer a = o1.getDynamicObject("runodebasedata").getInt("index");
                Integer b = o2.getDynamicObject("runodebasedata").getInt("index");
                return a.compareTo(b);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return 0;
            }
        }
    }
}

