/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.workflow;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskIndEntryService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;

public class FlowRuNodeMonitorReportPlugin
extends AbstractReportFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().invokeOperation("refresh");
    }

    public void setMergeColums(List<String> columns) {
        super.setMergeColums(columns);
        columns.add("roletype");
        columns.add("roleweight");
        columns.add("rolestatus");
        columns.add("turnoversort");
        columns.add("taskhandler");
        columns.add("taskstatus");
        columns.add("updatestatustime");
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        super.setCellStyleRules(cellStyleRules);
        for (FlowRuRoleStatusEnum flowRuRoleStatusEnum : FlowRuRoleStatusEnum.values()) {
            cellStyleRules.add(this.getCellStyleForeColor("rolestatus", flowRuRoleStatusEnum.getColour(), "rolestatus = '" + flowRuRoleStatusEnum.getCode() + "'"));
        }
        for (FlowRuRoleStatusEnum flowRuRoleStatusEnum : FlowRuTaskStatusEnum.values()) {
            cellStyleRules.add(this.getCellStyleForeColor("taskstatus", flowRuRoleStatusEnum.getColour(), "taskstatus = '" + flowRuRoleStatusEnum.getCode() + "'"));
        }
    }

    private CellStyleRule getCellStyleForeColor(String filedKey, String foreColor, String condition) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey(filedKey);
        cellStyleRule.setForeColor(foreColor);
        cellStyleRule.setCondition(condition);
        return cellStyleRule;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        if (CollectionUtils.isNotEmpty((Collection)rowData)) {
            for (DynamicObject row : rowData) {
                DynamicObject task;
                DynamicObject roleRu = row.getDynamicObject("rurolebasedata");
                if (!HRObjectUtils.isEmpty((Object)roleRu)) {
                    String roleName = roleRu.getString("name");
                    if (!HRStringUtils.isEmpty((String)roleName)) {
                        row.set("deproletype", (Object)(roleName + "  (" + roleRu.getInt("roleweight") + "%)"));
                    }
                    row.set("deprolestatus", (Object)FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode((String)roleRu.getString("rolestatus")).getText());
                    row.set("depturnoversort", (Object)roleRu.getInt("turnoversort"));
                }
                if (!HRObjectUtils.isEmpty((Object)(task = row.getDynamicObject("rutaskbasedata")))) {
                    DynamicObject handler = task.getDynamicObject("handler");
                    DynamicObject[] taskInds = FlowRuTaskIndEntryService.getInstance().queryRuTaskIndEntrysByTaskIds(Collections.singletonList(task.getLong("id")));
                    if (null != handler) {
                        String number = handler.getString("number");
                        row.set("deptaskhandler", (Object)(handler.get("name") + " " + (HRStringUtils.isEmpty((String)number) ? "" : "  (" + number + ")")));
                    }
                    row.set("deptaskstatus", (Object)FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)task.getString("taskstatus")).getText());
                    if (taskInds.length != 0) {
                        StringBuilder indicatorInfo = new StringBuilder();
                        List taskIndList = Arrays.stream(taskInds).collect(Collectors.toList());
                        List indicators = taskIndList.stream().map(e -> e.getLong("indicator")).collect(Collectors.toList());
                        Map indicatorMap = IEPAActevalobjService.getInstance().queryObjIndicatorAreaEntry(indicators, indicators);
                        int index = 0;
                        for (Map.Entry entry : indicatorMap.entrySet()) {
                            if (index > 0) {
                                indicatorInfo.append("\n");
                            }
                            indicatorInfo.append(++index).append("\u3001").append(((DynamicObject)entry.getValue()).getString("indctrname"));
                        }
                        row.set("indicatorinfo", (Object)indicatorInfo.toString());
                        continue;
                    }
                    row.set("indicatorinfo", (Object)"-");
                    continue;
                }
                row.set("deptaskhandler", (Object)"-");
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Long nodeRuId = (Long)this.getView().getFormShowParameter().getCustomParams().get("NODE_RU_ID");
        Map customParam = queryParam.getCustomParam();
        customParam.put("NODE_RU_ID", nodeRuId);
    }
}

