/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.workflow;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.report.ReportShowParameter;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.constants.FlowRuntimeConstants;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;

public class FlowRuntimeMonitorEdit
extends HRDataBaseEdit {
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APP_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();
    private static final String HEAD_SCULPTURE = "headsculpture";
    private static final String OBJ_NAME = "objname";
    private static final String OBJ_NUMBER = "objnumber";
    private static final String COMPANY = "companylabel";
    private static final String CENTER = "adminorglabel";
    private static final String POSITION = "positionlabel";
    private static final String MOFLOWTYPE = "moflowtype";
    private static final String STR_IS_MATRIX = "20";
    private static final String CUR_NODE_NAME = "curnodename";
    private static final String PX_SOLID = "1px_solid_";

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        Object id = args.getFormShowParameter().getCustomParams().get("id");
        if (!HRObjectUtils.isEmpty(id)) {
            ((BillShowParameter)args.getSource()).setPkId(id);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.initDetailHead();
        this.initNodeCarEntryEntity();
        this.showFlowRuMonitorReport();
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject proc = this.getView().getModel().getDataEntity();
        Map actevalObjPerffileInfo = EPA_ACTEVAOBJ_SERVICE.queryActEvalObjPerffilePersonInfo(Collections.singletonList(proc.getLong("actevalobj")));
        DynamicObject[] workflows = WorkFlowEntityService.getInstance().getWorkFlowsByDefProcId(new HashSet<Long>(Collections.singleton(proc.getLong("defproc.id"))));
        this.getModel().setValue("name", (Object)((String)((Map)actevalObjPerffileInfo.get(proc.getLong("actevalobj"))).get("name") + (workflows.length != 0 ? workflows[0].getString("name") : proc.getString("defproc.name"))));
        this.setLabelText(OBJ_NAME, (String)((Map)actevalObjPerffileInfo.get(proc.getLong("actevalobj"))).get("name"), OBJ_NAME);
        this.setLabelText(OBJ_NUMBER, (String)((Map)actevalObjPerffileInfo.get(proc.getLong("actevalobj"))).get("billno"), OBJ_NUMBER);
    }

    private void showFlowRuMonitorReport() {
        ReportShowParameter showParameter = new ReportShowParameter();
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        showParameter.setCustomParam("PROC_RU_ID", pkValue);
        showParameter.setFormId("pbs_flowrumonitorreport");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("monitorreport");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void initDetailHead() {
        IFormView view = this.getView();
        DynamicObject dynamicObject = this.getView().getModel().getDataEntity();
        Image image = (Image)view.getControl(HEAD_SCULPTURE);
        String headSculpture = dynamicObject.getString("person.headsculpture");
        if (!HRStringUtils.isEmpty((String)headSculpture)) {
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)headSculpture));
        }
        this.setLabelText(COMPANY, dynamicObject.getString("empposrel.company.name"), "companyicon", COMPANY);
        this.setLabelText(CENTER, dynamicObject.getString("empposrel.adminorg.name"), "adminorgicon", CENTER);
        this.setLabelText(POSITION, dynamicObject.getString("empposrel.position.name"), "positionicon", POSITION);
        if (HRStringUtils.equals((String)"1", (String)dynamicObject.getString("workflowtype"))) {
            String text = ResManager.loadKDString((String)"\u6307\u6807\u5236\u5b9a", (String)"FlowRuntimeMonitorEdit_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]);
            this.setLabelText(MOFLOWTYPE, text, MOFLOWTYPE);
        }
        this.setLabelText("moobjtype", STR_IS_MATRIX.equals(dynamicObject.getString("refobjtype")) ? FlowRuntimeConstants.getMetricEnumValue() : FlowRuntimeConstants.getNotMetricEnumValue(), "refobjtype", "moobjtype");
        boolean isMatrixProc = dynamicObject.getBoolean("ismatrixproc");
        if (isMatrixProc) {
            this.setLabelText("moobjname", FlowRuntimeConstants.getMetricEnumValue(), "moobjname");
        } else {
            this.setLabelText("moobjname", "", "moobjname");
        }
        Long activityId = this.getModel().getDataEntity().getLong("activity");
        Map activityNameMap = FLOW_RU_PROC_APP_SERVICE.queryActivityNameByIds(Collections.singletonList(activityId));
        String activityName = (String)activityNameMap.get(activityId);
        this.setLabelText("activityname", HRStringUtils.isBlank((CharSequence)activityName) ? "-" : activityName, "activityname");
        DynamicObject curNode = dynamicObject.getDynamicObject("currentnode");
        if (!HRObjectUtils.isEmpty((Object)curNode)) {
            this.setLabelText(CUR_NODE_NAME, dynamicObject.getDynamicObject("currentnode").getString("name"), CUR_NODE_NAME);
        } else {
            this.setLabelText(CUR_NODE_NAME, "-", CUR_NODE_NAME);
        }
        String procStatus = dynamicObject.getString("procstatus");
        FlowRuProcStatusEnum flowRuProcStatusByCode = FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)procStatus);
        if (!HRObjectUtils.isEmpty((Object)flowRuProcStatusByCode)) {
            this.setProcStatusColour(flowRuProcStatusByCode.getColour(), flowRuProcStatusByCode.getBackColour());
        }
    }

    private void setProcStatusColour(String colour, String backColour) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
        HashMap style = new HashMap(16);
        HashMap<String, String> border = new HashMap<String, String>(16);
        fieldMap.put("fc", colour);
        fieldMap.put("bc", backColour);
        border.put("r", PX_SOLID + colour);
        border.put("l", PX_SOLID + colour);
        border.put("t", PX_SOLID + colour);
        border.put("b", PX_SOLID + colour);
        style.put("b", border);
        fieldMap.put("s", style);
        this.getView().updateControlMetadata("procstatus", fieldMap);
    }

    private void initNodeCarEntryEntity() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        DynamicObject[] ruNodes = FLOW_RU_PROC_APP_SERVICE.queryAllNodeByProcId(pkValue);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("step", new Object[0]);
        vs.addField("flowrunode", new Object[0]);
        vs.addField("nodeweight", new Object[0]);
        vs.addField("nodestatus", new Object[0]);
        vs.addField("texttail", new Object[0]);
        for (int i = 0; i < ruNodes.length; ++i) {
            if (i >= ruNodes.length - 1) {
                vs.addRow(new Object[]{i + 1, ruNodes[i].getLong("id"), ruNodes[i].getInt("nodeweight"), ruNodes[i].getString("nodestatus")});
                continue;
            }
            vs.addRow(new Object[]{i + 1, ruNodes[i].getLong("id"), ruNodes[i].getInt("nodeweight"), ruNodes[i].getString("nodestatus"), "- - - - - -"});
        }
        model.batchCreateNewEntryRow("nodestateentryentity", vs);
        model.endInit();
    }

    private void setLabelText(String key, String text, String ... icon) {
        IFormView view = this.getView();
        Label label = (Label)view.getControl(key);
        if (ObjectUtils.isEmpty((Object)label)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)text)) {
            label.setText("");
            if (icon != null && icon.length > 0 && icon[0] != null) {
                this.getView().setVisible(Boolean.FALSE, icon);
            }
        } else {
            label.setText(text);
        }
    }
}

