/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.workflow;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.entityservice.WorkFlowEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.business.external.epa.IEPAActevalobjService;
import kd.opmc.pbs.common.constants.WorkFlowRuConstants;

public class FlowRuntimeMonitorList
extends HRDataBaseList
implements WorkFlowRuConstants {
    private static final String PAUSE = "pause";
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final IEPAActevalobjService EPA_ACTEVAOBJ_SERVICE = IEPAActevalobjService.getInstance();

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List<String> fixedColumnList = Arrays.asList("fseq", "number");
        fixedColumnList.forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                List procIds = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
                DynamicObject[] flowRuProcs = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcByProcIds(procIds);
                Set flowDefProcId = Arrays.stream(flowRuProcs).map(proc -> proc.getLong("defproc.id")).collect(Collectors.toSet());
                DynamicObject[] workflows = WorkFlowEntityService.getInstance().getWorkFlowsByDefProcId(flowDefProcId);
                List actIds = Arrays.stream(flowRuProcs).map(flow -> flow.getLong("activity")).distinct().collect(Collectors.toList());
                Map activityNameMap = FLOW_RU_PROC_APPLICATION_SERVICE.queryActivityNameByIds(actIds);
                Map<Long, DynamicObject> procMap = Arrays.stream(flowRuProcs).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
                Map actevalObjPerffileInfo = EPA_ACTEVAOBJ_SERVICE.queryActEvalObjPerffilePersonInfo(Arrays.stream(flowRuProcs).map(proc -> proc.getLong("actevalobj")).distinct().collect(Collectors.toList()));
                HashMap<Long, Boolean> flowRuMatrixMap = new HashMap<Long, Boolean>(16);
                for (DynamicObject flowRuProc : flowRuProcs) {
                    flowRuMatrixMap.put(flowRuProc.getLong("id"), flowRuProc.getBoolean("ismatrixproc"));
                }
                HashMap flowActNameMap = new HashMap(16);
                for (DynamicObject flowRuProc : flowRuProcs) {
                    flowActNameMap.put(flowRuProc.getLong("id"), activityNameMap.get(flowRuProc.getLong("activity")));
                }
                DynamicObjectCollection delDynCollection = new DynamicObjectCollection();
                for (DynamicObject row2 : rows) {
                    if (procMap.get(row2.getLong("id")) == null || actevalObjPerffileInfo.get(procMap.get(row2.getLong("id")).getLong("actevalobj")) == null) {
                        delDynCollection.add((Object)row2);
                        continue;
                    }
                    FlowRuntimeMonitorList.this.setPropertyValue(row2, "acteavobjname", ((Map)actevalObjPerffileInfo.get(procMap.get(row2.getLong("id")).getLong("actevalobj"))).get("name"));
                    FlowRuntimeMonitorList.this.setPropertyValue(row2, "acteavobjbillno", ((Map)actevalObjPerffileInfo.get(procMap.get(row2.getLong("id")).getLong("actevalobj"))).get("billno"));
                    FlowRuntimeMonitorList.this.setPropertyValue(row2, "activityname", flowActNameMap.get(row2.getLong("id")));
                    FlowRuntimeMonitorList.this.setPropertyValue(row2, "procname", (String)((Map)actevalObjPerffileInfo.get(procMap.get(row2.getLong("id")).getLong("actevalobj"))).get("name") + (workflows.length != 0 ? workflows[0].getString("name") : procMap.get(row2.getLong("id")).getString("defproc.name")));
                    Boolean isMatrix = (Boolean)flowRuMatrixMap.get(row2.getLong("id"));
                    if (!isMatrix.booleanValue()) {
                        FlowRuntimeMonitorList.this.setPropertyValue(row2, "moobjname", "-");
                        continue;
                    }
                    FlowRuntimeMonitorList.this.setPropertyValue(row2, "moobjname", "");
                }
                rows.removeAll((Collection)delDynCollection);
                return rows;
            }
        });
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        String key = ((AbstractColumnDesc)evt.getSource()).getKey();
        DynamicObject rowData = evt.getRowData();
        switch (key) {
            case "activityname": {
                evt.setFormatValue(rowData.get("activityname"));
                break;
            }
            case "moobjname": {
                evt.setFormatValue(rowData.get("moobjname"));
                break;
            }
            case "currentnode.name": {
                if (evt.getFormatValue() != null) break;
                evt.setFormatValue((Object)"-");
                break;
            }
            case "acteavobjname": {
                evt.setFormatValue(rowData.get("acteavobjname"));
                break;
            }
            case "acteavobjbillno": {
                evt.setFormatValue(rowData.get("acteavobjbillno"));
                break;
            }
            case "procname": {
                evt.setFormatValue(rowData.get("procname"));
                break;
            }
        }
    }

    private void setPropertyValue(DynamicObject row, String propertyName, Object value) {
        if (!row.getDataEntityType().getProperties().containsKey((Object)propertyName)) {
            DynamicProperty property = new DynamicProperty();
            property.setName(propertyName);
            row.getDataEntityType().getProperties().add((Object)property);
        }
        row.set(propertyName, value);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String opKey = evt.getOperationKey();
        if (PAUSE.equals(opKey)) {
            ListSelectedRowCollection rows = this.getSelectedRows();
            if (rows.size() == 1) {
                Long ruProcId = (Long)rows.get(0).getPrimaryKeyValue();
                String procStatus = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcStatus(ruProcId);
                if (!FlowRuProcStatusEnum.RUNNING.getCode().equals(procStatus)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u201c\u6267\u884c\u4e2d\u201d\u7684\u6d41\u7a0b\u652f\u6301\u201c\u6682\u505c\u201d\u64cd\u4f5c\u3002", (String)"FlowRuntimeMonitorList_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
            this.showPause();
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("restart".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showPause() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbs_pauseflow");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pbs_pauseflow"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if ("pbs_pauseflow".equals(closedCallBackEvent.getActionId()) && !HRObjectUtils.isEmpty((Object)returnData)) {
            Map returnDataMap = (Map)returnData;
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("pausetype", (String)returnDataMap.get("pausetype"));
            operateOption.setVariableValue("describe", (String)returnDataMap.get("describe"));
            this.getView().invokeOperation(PAUSE, operateOption);
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.addCustomQFilter(new QFilter("procstatus", "!=", (Object)FlowRuProcStatusEnum.NOTACTIVE.getCode()));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("targetformulate".equals(formShowParameter.getCustomParam("flowType"))) {
            setFilterEvent.addCustomQFilter(new QFilter("workflowtype", "=", (Object)"1"));
            Long activity = (Long)formShowParameter.getCustomParam("activityid");
            setFilterEvent.addCustomQFilter(new QFilter("activity", "=", (Object)activity));
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        if ("procstatus".equals(args.getListFieldKey())) {
            args.getComboItems().remove(0);
        }
        super.listColumnCompareTypesSet(args);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (ObjectUtils.isEmpty((Object)this.getParentViewPageCache())) {
            args.setCancel(true);
            return;
        }
    }

    protected IPageCache getParentViewPageCache() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u518d\u91cd\u65b0\u6253\u5f00\u3002", (String)"FlowRuntimeMonitorList_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return null;
        }
        return parentView.getPageCache();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView")) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                this.getView().close();
            }
            return;
        }
    }
}

