/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.formplugin.web.workflow;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskEntityService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskProcLogEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;

public class FlowrutaskProcLogListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(FlowrutaskProcLogListPlugin.class);
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final FlowRuTaskProcLogEntityService FLOW_RUTASK_PROCLOG_SERVICE = FlowRuTaskProcLogEntityService.getInstance();
    private static final FlowRuTaskEntityService FLOW_RU_TASK_ENTITY_SERVICE = FlowRuTaskEntityService.getInstance();
    String OP_RETRY = "retry";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (this.OP_RETRY.equals(opKey)) {
            Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
            DynamicObject[] ruTaskProcLogDyns = FLOW_RUTASK_PROCLOG_SERVICE.loadDynamicObjectArray(ids);
            List taskIdList = Arrays.stream(ruTaskProcLogDyns).map(rt -> rt.getLong("flowrutask")).collect(Collectors.toList());
            DynamicObject[] tasks = FLOW_RU_TASK_ENTITY_SERVICE.queryTaskByPks(taskIdList);
            List retryTaskIdList = Arrays.stream(tasks).filter(ts -> ts.getString("taskstatus").equals(FlowRuTaskStatusEnum.WAITING.getCode()) || ts.getString("taskstatus").equals(FlowRuTaskStatusEnum.PROCESSING.getCode())).map(rt -> rt.getLong("id")).collect(Collectors.toList());
            Map resultMap = FLOW_RU_PROC_DOMAIN_SERVICE.dealSubmitTask(retryTaskIdList, Boolean.FALSE);
            for (DynamicObject ruTaskProLog : ruTaskProcLogDyns) {
                boolean dealStatus = null != resultMap.get(ruTaskProLog.getLong("flowrutask")) ? ((Boolean)resultMap.get(ruTaskProLog.getLong("flowrutask"))).booleanValue() : Boolean.FALSE.booleanValue();
                ruTaskProLog.set("retrycount", (Object)(ruTaskProLog.getInt("retrycount") + 1));
                ruTaskProLog.set("consumestatus", (Object)(dealStatus ? "20" : "30"));
            }
            FLOW_RUTASK_PROCLOG_SERVICE.save(ruTaskProcLogDyns);
        }
    }
}

