/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.opmc.pbs.common.utils.WorkFlowStack;

public class FlowControlUtils {
    private static final String PRE_AVGTIME = "preavgtime";
    private static final String CURRENT_AVGTIME = "current_avgtime";
    private static final String RECENT_FIVE_AVGTIME = "recent_five_avgtime";
    private static final Map<String, WorkFlowStack<Long>> FLOW_STACK_MAP = new HashMap<String, WorkFlowStack<Long>>(16);
    private static int N_TIME = 5;

    public static WorkFlowStack<Long> initializeFlowStackMap() {
        String tenantId = RequestContext.get().getTenantId();
        if (null == FLOW_STACK_MAP.get(tenantId)) {
            FLOW_STACK_MAP.put(tenantId, new WorkFlowStack());
        }
        return FLOW_STACK_MAP.get(tenantId);
    }

    public static long calcuteRecentFiveAvgTime(WorkFlowStack<Long> flowStack) {
        int size = flowStack.getSize();
        long recentFiveAvgTime = 0L;
        for (int i = 0; i < size; ++i) {
            recentFiveAvgTime += Long.parseLong(flowStack.get(i).toString());
        }
        if (size > 0) {
            recentFiveAvgTime = new BigDecimal(recentFiveAvgTime).divide(BigDecimal.valueOf(size), 2, RoundingMode.HALF_UP).longValue();
        }
        return recentFiveAvgTime;
    }

    public static WorkFlowStack<Long> pushStack(WorkFlowStack<Long> flowStack, long currentAvgTime) {
        if (flowStack.getSize() > N_TIME) {
            flowStack.pop();
        }
        flowStack.push(currentAvgTime);
        return flowStack;
    }
}

