/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.common.utils;

import java.text.ParseException;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class OpmcDateUtils
extends HRDateTimeUtils {
    private static final Log logger = LogFactory.getLog(OpmcDateUtils.class);

    public static String formatTimeUser(Date date) {
        IFormat format = FormatFactory.get((FormatTypes)FormatTypes.Time);
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        return format.getFormat(formatObject).format(date);
    }

    public static String formatDateUser(Date date) {
        IFormat format = FormatFactory.get((FormatTypes)FormatTypes.Date);
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
        return format.getFormat(formatObject).format(date);
    }

    public static Date getMidnight() {
        return OpmcDateUtils.getMidnight(new Date());
    }

    public static Date getDefaultBsled() {
        try {
            return OpmcDateUtils.parseDate((String)"2999-12-31");
        }
        catch (ParseException parseException) {
            logger.error("parse date error!", (Throwable)parseException);
            return null;
        }
    }

    public static Date getMidnight(Date date) {
        if (date == null) {
            return null;
        }
        String dateStr = OpmcDateUtils.format((Date)date, (String)"yyyy-MM-dd");
        try {
            return OpmcDateUtils.parseDate((String)(dateStr + " 00:00:00"));
        }
        catch (ParseException parseException) {
            logger.error("parse date error!", (Throwable)parseException);
            return null;
        }
    }

    public static Date getLastSecond() {
        return OpmcDateUtils.getLastSecond(new Date());
    }

    public static Date getLastSecond(Date date) {
        if (date == null) {
            return null;
        }
        String dateStr = OpmcDateUtils.format((Date)date, (String)"yyyy-MM-dd");
        try {
            return OpmcDateUtils.parseDate((String)(dateStr + " 23:59:59"));
        }
        catch (ParseException parseException) {
            logger.error("parse date error!", (Throwable)parseException);
            return null;
        }
    }
}

