/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.common.utils;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class OpmcDynamicObjectUtils {
    public static String dynamicObjectConvertToStr(DynamicObject srcDynamicObject, String entityType, Boolean isCopyId) {
        DynamicObject dynamicObjectNew = BusinessDataServiceHelper.newDynamicObject((String)entityType);
        DynamicObjectUtils.copy((DynamicObject)srcDynamicObject, (DynamicObject)dynamicObjectNew);
        if (isCopyId.booleanValue()) {
            dynamicObjectNew.set("id", srcDynamicObject.get("id"));
        }
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeDataEntityState(false);
        option.setIncludeComplexProperty(true);
        option.setIncludeCollectionProperty(true);
        option.setIncludeType(false);
        return DataEntitySerializer.serializerToString((Object)dynamicObjectNew, (DataEntitySerializerOption)option);
    }

    public static DynamicObject getDynamicObjFromStr(String dynStr, String entityType) {
        MainEntityType subMainType = EntityMetadataCache.getDataEntityType((String)entityType);
        return (DynamicObject)DataEntitySerializer.deSerializerFromString((String)dynStr, (IDataEntityType)subMainType);
    }

    public static String convertDynObjToStrByDcJson(DynamicObject srcDyn, String entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(srcDyn.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return jser.serializeToString((Object)srcDyn, (Object)new HRBaseServiceHelper(entityType).generateEmptyDynamicObject());
    }

    public static DynamicObject getDynObjFromStrByDcJson(String dynStr, String entityType) {
        DynamicObject targetObj = new HRBaseServiceHelper(entityType).generateEmptyDynamicObject();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(targetObj.getDynamicObjectType());
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        return (DynamicObject)jser.deserializeFromString(dynStr, (Object)targetObj);
    }

    public static DynamicObjectCollection getDynamicObjCollFromStr(DynamicObject model, List<String> jsonList, String entryName) {
        DynamicObjectCollection dyColl = model.getDynamicObjectCollection(entryName);
        dyColl.clear();
        for (String jsonStr : jsonList) {
            DynamicObject dynamicObject = dyColl.addNew();
            Map dyMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
            for (Map.Entry entry : dyMap.entrySet()) {
                if ("_Type_".equals(entry.getKey())) continue;
                dynamicObject.set((String)entry.getKey(), entry.getValue());
            }
        }
        return dyColl;
    }
}

