/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.opplugin.web.nordisrule.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.common.enums.DefaultLevelStyleEnum;

public class NordisRuleRequiredValidator
extends AbstractValidator {
    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        if (dataEntity.getBoolean("isendeflevelrule")) {
            if (ObjectUtils.isEmpty((Object)dataEntity.get("defaultlevelstyle"))) {
                this.addErrorMessage((ExtendedDataEntity)dataEntities[0], ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u9ed8\u8ba4\u8f6c\u7b49\u7ea7\u65b9\u5f0f\u201d\u3002", (String)"NordisRuleRequiredValidator_0", (String)"opmc-pbs-opplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("orgperfentry");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                DynamicObjectCollection entryEntities = dynamicObject.getDynamicObjectCollection("levelconvertentry");
                if (HRStringUtils.equals((String)dataEntity.getString("defaultlevelstyle"), (String)DefaultLevelStyleEnum.SCORE_SEGMENT.getStyle()) && this.checkLevelScoreMap((ExtendedDataEntity)dataEntities[0], entryEntities)) {
                    return;
                }
                if (HRStringUtils.equals((String)dataEntity.getString("defaultlevelstyle"), (String)DefaultLevelStyleEnum.RANKING.getStyle()) && this.checkRankingMap((ExtendedDataEntity)dataEntities[0], entryEntities)) {
                    return;
                }
                this.reEntitySetDefaultValue(entryEntities);
            }
        }
    }

    private void reEntitySetDefaultValue(DynamicObjectCollection entryEntities) {
        for (DynamicObject dynamicObject : entryEntities) {
            if (HRObjectUtils.isEmpty((Object)dynamicObject.get("maxscore"))) {
                dynamicObject.set("maxscore", (Object)0);
            }
            if (HRObjectUtils.isEmpty((Object)dynamicObject.get("minscore"))) {
                dynamicObject.set("minscore", (Object)0);
            }
            if (HRObjectUtils.isEmpty((Object)dynamicObject.get("minrank"))) {
                dynamicObject.set("minrank", (Object)0);
            }
            if (!HRObjectUtils.isEmpty((Object)dynamicObject.get("maxrank"))) continue;
            dynamicObject.set("maxrank", (Object)0);
        }
    }

    private boolean checkRankingMap(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection entryEntities) {
        for (int index = 0; index < entryEntities.size(); ++index) {
            int firstMaxRank;
            if (ObjectUtils.isEmpty((Object)((DynamicObject)entryEntities.get(index)).get("maxrank"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6700\u9ad8\u6392\u540d\u3002", (String)"NordisRuleRequiredValidator_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
            int maxRank = ((DynamicObject)entryEntities.get(index)).getInt("maxrank");
            if (index != entryEntities.size() - 1 && HRObjectUtils.isEmpty((Object)((DynamicObject)entryEntities.get(index)).get("scoremaxoperation"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8fd0\u7b97\u7b26\u201d\u3002", (String)"NordisRuleRequiredValidator_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (index != entryEntities.size() - 1 && (maxRank >= 100 || maxRank <= 0)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u6392\u540d\u5360\u6bd4\u201d\u503c\u5e94\u5927\u4e8e0\u5c0f\u4e8e100\uff0c\u4e14\u4e3a\u6574\u6570\u3002", (String)"NordisRuleRequiredValidator_3", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (index <= 0 || index == entryEntities.size() - 1 || maxRank > (firstMaxRank = ((DynamicObject)entryEntities.get(index - 1)).getInt("maxrank"))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6392\u540d\u5360\u6bd4\u4ece\u4e0a\u5f80\u4e0b\u5347\u5e8f\uff0c\u4e14\u4e3a\u6b63\u6574\u6570\u3002", (String)"NordisRuleRequiredValidator_4", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkLevelScoreMap(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection entryEntities) {
        DynamicObject dynamicObject = extendedDataEntity.getDataEntity().getDynamicObject("scoresystem");
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8bc4\u5206\u5206\u5236\u201d\u3002", (String)"NordisRuleRequiredValidator_5", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        for (int index = 0; index < entryEntities.size(); ++index) {
            if (index != entryEntities.size() - 1 && HRObjectUtils.isEmpty((Object)((DynamicObject)entryEntities.get(index)).get("scoreminoperation"))) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8fd0\u7b97\u7b26\u201d\u3002", (String)"NordisRuleRequiredValidator_2", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
            BigDecimal lastMinScore = ((DynamicObject)entryEntities.get(index)).getBigDecimal("minscore");
            if (index != entryEntities.size() - 1) {
                if (HRObjectUtils.isEmpty((Object)lastMinScore)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6700\u4f4e\u5206\u201d\u3002", (String)"NordisRuleRequiredValidator_6", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    return true;
                }
                if (!HRObjectUtils.isEmpty((Object)dynamicObject) && lastMinScore.compareTo(dynamicObject.getBigDecimal("maxscore")) > 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u5206\u503c\u8303\u56f4\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u201c\u5206\u5236\u57fa\u51c6\u6700\u9ad8\u5206\u201d\u3002", (String)"NordisRuleRequiredValidator_7", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    return true;
                }
                if (!HRObjectUtils.isEmpty((Object)dynamicObject) && lastMinScore.compareTo(dynamicObject.getBigDecimal("minscore")) < 0) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u5206\u503c\u8303\u56f4\u201d\u9700\u5927\u4e8e\u7b49\u4e8e\u201c\u5206\u5236\u57fa\u51c6\u6700\u4f4e\u5206\u201d\u3002", (String)"NordisRuleRequiredValidator_8", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                    return true;
                }
            }
            if (index <= 0 || index == entryEntities.size() - 1) continue;
            BigDecimal firstMinScore = ((DynamicObject)entryEntities.get(index - 1)).getBigDecimal("minscore");
            if (HRObjectUtils.isEmpty((Object)firstMinScore)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6700\u4f4e\u5206\u201d\u3002", (String)"NordisRuleRequiredValidator_6", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (lastMinScore.compareTo(firstMinScore) < 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6700\u4f4e\u5206\u4ece\u4e0a\u5f80\u4e0b\u964d\u5e8f\u3002", (String)"NordisRuleRequiredValidator_9", (String)"opmc-pbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

