/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.opplugin.web.nordisrule.validator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.openapi.common.util.Pair;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.common.enums.ExpTypeEnum;
import kd.opmc.pbs.common.enums.OpeTypeEnum;

public class NordisRuleSubmitOpValidator
extends AbstractValidator {
    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        DynamicObject dataEntity = dataEntities[0].getDataEntity();
        DynamicObjectCollection orgPerfEntry = dataEntity.getDynamicObjectCollection("orgperfentry");
        for (DynamicObject orgPerf : orgPerfEntry) {
            DynamicObjectCollection ratioRuleEntry = orgPerf.getDynamicObjectCollection("ratioruleentry");
            long count = ratioRuleEntry.stream().filter(ratioRule -> ratioRule.getString("exptype").equals(ExpTypeEnum.BETWEEN.getValue())).count();
            if (count == (long)ratioRuleEntry.size()) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntities[0], ResManager.loadKDString((String)"\u5404\u7b49\u7ea7\u6bd4\u4f8b\u89c4\u5219\u4e0d\u652f\u6301\u5168\u90e8\u8bbe\u7f6e\u4e3a\u201c\u533a\u95f4\u201d\u3002", (String)"NordisRuleSubmitOpValidator_0", (String)"opmc-pbs-opplugin", (Object[])new Object[0]));
                return;
            }
            long notLimitCount = ratioRuleEntry.stream().filter(ratioRule -> ratioRule.getString("exptype").equals(ExpTypeEnum.NOT_LIMIT.getValue())).count();
            if (notLimitCount == (long)ratioRuleEntry.size()) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntities[0], ResManager.loadKDString((String)"\u5404\u7b49\u7ea7\u6bd4\u4f8b\u89c4\u5219\u4e0d\u652f\u6301\u5168\u90e8\u8bbe\u7f6e\u4e3a\u201c\u4e0d\u9650\u5236\u201d\u3002", (String)"NordisRuleSubmitOpValidator_1", (String)"opmc-pbs-opplugin", (Object[])new Object[0]));
                return;
            }
            for (int i = 0; i < ratioRuleEntry.size(); ++i) {
                int row = i + 1;
                if (!this.checkRationRuleMustInput((DynamicObject)ratioRuleEntry.get(i))) continue;
                this.addErrorMessage((ExtendedDataEntity)dataEntities[0], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6bd4\u4f8b\u89c4\u5219\u8bbe\u7f6e\u201d\u7b2c{0}\u884c\u5fc5\u586b\u9879\u3002", (String)"NordisRuleSubmitOpValidator_2", (String)"opmc-pbs-opplugin", (Object[])new Object[]{row}));
                return;
            }
            ArrayList<Pair<Integer, Integer>> pairNums = new ArrayList<Pair<Integer, Integer>>(10);
            HashSet comLevelSet = new HashSet(16);
            for (DynamicObject ratioRule2 : ratioRuleEntry) {
                if (ratioRule2.getString("scorelevels").split("\\,").length <= 1) continue;
                JSONArray objects = JSON.parseArray((String)ratioRule2.getString("scorelevels"));
                comLevelSet.addAll(objects);
            }
            boolean flag = false;
            for (int i = 0; i < ratioRuleEntry.size(); ++i) {
                DynamicObject ratioRule3 = (DynamicObject)ratioRuleEntry.get(i);
                if (ratioRule3.getString("scorelevels").split("\\,").length == 1 && comLevelSet.contains(JSON.parseArray((String)ratioRule3.getString("scorelevels")).get(0))) continue;
                String opeTwo = ratioRule3.getString("opetwo");
                pairNums.add(this.buildPairNum(ratioRule3));
                if (OpeTypeEnum.EQUAL.getValue().equals(opeTwo)) continue;
                flag = true;
            }
            if (flag) {
                int sumMin = pairNums.stream().mapToInt(pairNum -> (Integer)pairNum.getKey()).sum();
                int sumMax = pairNums.stream().mapToInt(pairNum -> (Integer)pairNum.getValue()).sum();
                if (sumMin < 100 && sumMax > 100) continue;
                this.addErrorMessage((ExtendedDataEntity)dataEntities[0], ResManager.loadKDString((String)"\u7b49\u7ea7\u5408\u8ba1\u6700\u5927\u6bd4\u4f8b\u5c0f\u4e8e100%\uff08\u5982\u4ee5\u4e0b2\u4e2a\u573a\u666f\uff09 {0}1) A\u7b49\u4e8e30%\uff0cB\u7b49\u4e8e40%\uff0cC\u7b49\u4e8e20% {1}2) A\u7b49\u4e8e30%\uff0cB\u5927\u4e8e20%\u5c0f\u4e8e30%\uff0cC\u5c0f\u4e8e30% \u7b49\u7ea7\u5408\u8ba1\u6700\u5c0f\u6bd4\u4f8b\u5927\u4e8e100%\uff08\u5982\u4ee5\u4e0b2\u4e2a\u573a\u666f\uff09 1)A\u5927\u4e8e30%\uff0cB\u5927\u4e8e70%\uff0cC\u5927\u4e8e10% {2}2) A\u7b49\u4e8e30%\uff0cB\u5927\u4e8e50%\u5c0f\u4e8e60%\uff0cC\u5927\u4e8e30%{3}", (String)"NordisRuleSubmitOpValidator_3", (String)"opmc-pbs-opplugin", (Object[])new Object[]{"\r\n", "\r\n", "\r\n", "\r\n"}));
                return;
            }
            int sumNum = pairNums.stream().mapToInt(pairNum -> (Integer)pairNum.getValue()).sum();
            if (sumNum == 100) continue;
            this.addErrorMessage((ExtendedDataEntity)dataEntities[0], ResManager.loadKDString((String)"\u5f53\u6bd4\u4f8b\u516c\u5f0f\u8bbe\u7f6e\u4e3a\u201c\u9ed8\u8ba4\u201d\u4e14\u503c\u4e3a\u201c=\u201d\u65f6\uff0c\u6bd4\u4f8b\u4e4b\u548c\u9700\u7b49\u4e8e100%\u3002", (String)"NordisRuleSubmitOpValidator_5", (String)"opmc-pbs-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private boolean checkRationRuleMustInput(DynamicObject ratioRule) {
        if (HRStringUtils.isEmpty((String)ratioRule.getString("scorelevels"))) {
            return true;
        }
        int numOne = ratioRule.getInt("numone");
        int numTwo = ratioRule.getInt("numtwo");
        String opeOne = ratioRule.getString("opeone");
        String opeTwo = ratioRule.getString("opetwo");
        String expType = ratioRule.getString("exptype");
        return expType.equals(ExpTypeEnum.DEFAULT.getValue()) ? HRStringUtils.isEmpty((String)opeTwo) || numTwo <= 0 : expType.equals(ExpTypeEnum.BETWEEN.getValue()) && (HRStringUtils.isEmpty((String)opeOne) || numOne <= 0 || HRStringUtils.isEmpty((String)opeTwo) || numTwo <= 0);
    }

    private Pair<Integer, Integer> buildPairNum(DynamicObject ratioRule) {
        Pair result = new Pair((Object)0, (Object)0);
        String opeTwo = ratioRule.getString("opetwo");
        int numOne = ratioRule.getInt("numone");
        int numTwo = ratioRule.getInt("numtwo");
        ExpTypeEnum expType = ExpTypeEnum.valueToEnum((String)ratioRule.getString("exptype"));
        switch (expType) {
            case NOT_LIMIT: {
                result = new Pair((Object)0, (Object)100);
                break;
            }
            case BETWEEN: {
                result = new Pair((Object)numOne, (Object)numTwo);
                break;
            }
            case DEFAULT: {
                if (OpeTypeEnum.LESSTHAN.getValue().equals(opeTwo) || OpeTypeEnum.LESSTHANOREQUAL.getValue().equals(opeTwo)) {
                    result = new Pair((Object)0, (Object)numTwo);
                    break;
                }
                if (OpeTypeEnum.EQUAL.getValue().equals(opeTwo)) {
                    result = new Pair((Object)numTwo, (Object)numTwo);
                    break;
                }
                if (!OpeTypeEnum.GREATERTHAN.getValue().equals(opeTwo) && !OpeTypeEnum.GREATERTHANOREQUAL.getValue().equals(opeTwo)) break;
                result = new Pair((Object)numTwo, (Object)100);
                break;
            }
        }
        return result;
    }
}

