/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.opplugin.web.pot;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.pbs.business.application.service.PerfCecycleApplicationService;

public class CycleDeleteOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject data = dataEntity.getDataEntity();
                    DynamicObject[] dynamicObject = PerfCecycleApplicationService.getInstance().getCycleIns(Long.valueOf(data.getLong("id")));
                    if (HRObjectUtils.isEmpty((Object)dynamicObject) || dynamicObject.length <= 0) continue;
                    String msg = CycleDeleteOp.this.checkRef(dynamicObject);
                    if (HRStringUtils.isNotEmpty((String)msg)) {
                        this.addMessage(dataEntity, msg, ErrorLevel.FatalError);
                        continue;
                    }
                    PerfCecycleApplicationService.getInstance().deleteRunTimeCycleIns(Arrays.stream(dynamicObject).map(dyc -> dyc.getLong("id")).collect(Collectors.toList()));
                }
            }
        });
    }

    private String checkRef(DynamicObject[] dynamicObjects) {
        BasedataEntityType userType = PerfCecycleApplicationService.getInstance().getBaseDataEntityType();
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(true);
        Map checkResult = checker.checkRef(userType, Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).toArray());
        for (Map.Entry objectBaseDataCheckRefrenceResultEntry : checkResult.entrySet()) {
            BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)objectBaseDataCheckRefrenceResultEntry.getValue();
            if (!((BaseDataCheckRefrenceResult)objectBaseDataCheckRefrenceResultEntry.getValue()).isRefence()) continue;
            return this.buildRefMessage(refrenceResult);
        }
        return null;
    }

    private String buildRefMessage(BaseDataCheckRefrenceResult refrenceResult) {
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
        String billName = refMainType.getDisplayName().toString();
        String tableName = refrenceResult.getRefenceKey().getRefTable();
        String fieldName = refrenceResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (this.equalsFieldname(property, tableName, fieldName)) {
                fieldName = property.getDisplayName().toString();
                break;
            }
            if (!this.equalsMulBasedataFieldname(property, tableName, fieldName)) continue;
            fieldName = property.getDisplayName().toString();
            break;
        }
        return ResManager.loadKDString((String)"\u201c{0}\u201d\u7684\u5b57\u6bb5\u201c{1}\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"CycleDeleteOp_0", (String)"opmc-pbs-opplugin", (Object[])new Object[]{billName, fieldName});
    }

    private boolean equalsFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (property instanceof IFieldHandle && property.getParent() != null && property.getParent().getAlias() != null) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)fieldName)) {
                return false;
            }
            String propTableName = property.getParent().getAlias();
            if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
                propTableName = propTableName + "_" + property.getTableGroup();
            }
            return StringUtils.equalsIgnoreCase((CharSequence)propTableName, (CharSequence)tableName);
        }
        return false;
    }

    private boolean equalsMulBasedataFieldname(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof MulBasedataProp)) {
            return false;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
        if (mulBasedataProp.getItemType() != null && mulBasedataProp.getItemType().getAlias() != null) {
            return StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"fbasedataid") && StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)mulBasedataProp.getItemType().getAlias());
        }
        return false;
    }
}

