/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.opplugin.web.workflow;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;

public class FlowRuntimePauseOp
extends HRDataBaseOp {
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APP_SERVICE = FlowRuProcApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("procstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    DynamicObject data = dataEntity.getDataEntity();
                    if (FlowRuProcStatusEnum.RUNNING.getCode().equals(data.getString("procstatus"))) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u201c\u6267\u884c\u4e2d\u201d\u7684\u6d41\u7a0b\u652f\u6301\u201c\u6682\u505c\u201d\u64cd\u4f5c\u3002", (String)"FlowRuntimePauseOp_1", (String)"opmc-pbs-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<Long> ruProcIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            ruProcIds.add((Long)dataEntity.getPkValue());
        }
        String pauseType = this.getOption().getVariableValue("pausetype");
        String describe = this.getOption().getVariableValue("describe");
        FLOW_RU_PROC_APP_SERVICE.pauseProcess(ruProcIds, pauseType, describe);
    }
}

