/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pbs.opplugin.web.workflow;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;

public class FlowRuntimeRestartOp
extends HRDataBaseOp {
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APP_SERVICE = FlowRuProcApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("procstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    DynamicObject data = dataEntity.getDataEntity();
                    String procStatus = data.getString("procstatus");
                    if (!FlowRuProcStatusEnum.PENDING.getCode().equals(procStatus) && !FlowRuProcStatusEnum.STOP.getCode().equals(procStatus)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u201c\u5df2\u6682\u505c\u201d\u53ca\u201c\u5df2\u6302\u8d77\u201d\u7684\u6d41\u7a0b\u652f\u6301\u201c\u91cd\u542f\u201d\u64cd\u4f5c\u3002", (String)"FlowRuntimeRestartOp_2", (String)"opmc-pbs-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!FlowRuProcStatusEnum.PENDING.getCode().equals(procStatus) || !FLOW_RU_PROC_APP_SERVICE.notPrepareRestart((Long)data.getPkValue())) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5904\u7406\u4eba\uff0c\u89d2\u8272\u4e3a\u201c\u5df2\u6302\u8d77\u201d\u72b6\u6001\u3002", (String)"FlowRuntimeRestartOp_1", (String)"opmc-pbs-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<Long> ruProcIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            ruProcIds.add((Long)dataEntity.getPkValue());
        }
        FLOW_RU_PROC_APP_SERVICE.restartProcess(ruProcIds);
    }
}

