/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.business.domain.exportinitdata.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.db.pktemptable.PKTempTables;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ConfigurationUtil;
import kd.hr.hbp.business.openservicehelper.permission.HRPermissionServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.opmc.pbs.business.external.hrcs.IHRCSDataPermissionService;
import kd.opmc.pmd.business.ServiceFactory;
import kd.opmc.pmd.business.domain.perffile.service.PerffileDomainService;

public class ExportInItDataService {
    private static final Log LOG = LogFactory.getLog(ExportInItDataService.class);
    private static final PerffileDomainService PERFFILE_DOMAIN_SERVICE = PerffileDomainService.getInstance();
    private static final IHRCSDataPermissionService IHRCS_DATA_PERMISSION_SERVICE = IHRCSDataPermissionService.getInstance();

    public static ExportInItDataService getInstance() {
        return ServiceFactory.getService(ExportInItDataService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet queryData() {
        String sql = "select \n e.fid id,\n      the.FEMPNUMBER empnumber,\n      f.fname ermname,\n      thd.fadminorgid dempid,\n      o.fnumber orgnumber,\n      o.fname orgname,\n      them.fnumber posinumber,\n      them.fname posiname,\n      f.forgid buid\n   from\n      t_hrpi_empposorgrel e \n   left JOIN\n      t_haos_adminorg o \n         ON o.fid = e.fadminorgid \n   inner JOIN\n      t_hrpi_ermanfile f \n         on f.fempposrelid = e.fid \n   inner join t_hrpi_depemp thd \n     on e.fdepempid = thd.fid \n        and thd.fadminorgid = e.fadminorgid\n   inner join t_hrpi_employee the\n  on e.femployeeid = the.fid \n      inner join t_hbpm_position them\n     on them.fid = thd.fpositionid\n   WHERE\n      e.fiscurrentversion = '1' and e.fisprimary = '1'\n      AND f.fbusinessstatus = '1'  \n      and f.finitstatus = '2'\n      and f.fiscurrentversion  = '1'\n";
        ArrayList<Long> paramList = new ArrayList<Long>(16);
        PKTempTable depEmpTempTable = null;
        PKTempTable adminOrgTempTable = null;
        Integer tempThreshold = ConfigurationUtil.getInteger((String)"orm.opt.in.threshold", (Integer)1000);
        List<Long> depEmpIdList = PERFFILE_DOMAIN_SERVICE.getExistenceDepempIds();
        try {
            DataSet dataSet;
            AuthorizedOrgResult authorizedAdminOrgSet;
            if (depEmpIdList != null && !depEmpIdList.isEmpty()) {
                if (depEmpIdList.size() > tempThreshold) {
                    depEmpTempTable = PKTempTables.createPKLong((DBRoute)DBRoute.of((String)"hr"));
                    depEmpTempTable.insert(depEmpIdList);
                    String tempTableName = depEmpTempTable.getName();
                    sql = sql + " and thd.fid not in ( select fid from " + tempTableName + ")\n";
                } else {
                    StringBuilder builder = new StringBuilder();
                    for (Long ignored : depEmpIdList) {
                        builder.append("?,");
                    }
                    String substring = builder.substring(0, builder.length() - 1);
                    sql = sql + " and thd.fid not in (" + substring + ")\n";
                    paramList.addAll(depEmpIdList);
                }
            }
            if (!(authorizedAdminOrgSet = HRPermissionServiceHelper.getAuthorizedAdminOrgSet((Long)RequestContext.get().getCurrUserId(), (String)"24E05ECYZ6K0", (String)"pmd_perffile", (String)"47150e89000000ac", (String)"affiliateadminorg")).isHasAllOrgPerm()) {
                List authorizedAdminOrgIdSet = authorizedAdminOrgSet.getHasPermOrgs();
                if (authorizedAdminOrgIdSet.size() > tempThreshold) {
                    adminOrgTempTable = PKTempTables.createPKLong((DBRoute)DBRoute.of((String)"hr"));
                    adminOrgTempTable.insert((Collection)authorizedAdminOrgIdSet);
                    String tempTableName = adminOrgTempTable.getName();
                    sql = sql + " and thd.fadminorgid in ( select fid from " + tempTableName + ")\n";
                } else {
                    StringBuilder builder = new StringBuilder();
                    for (Object ignored : authorizedAdminOrgIdSet) {
                        builder.append("?,");
                    }
                    String substring = builder.substring(0, builder.length() - 1);
                    sql = sql + " and thd.fadminorgid in (" + substring + ")\n";
                    paramList.addAll(authorizedAdminOrgIdSet);
                }
            }
            LOG.info("===============================");
            LOG.info(sql);
            LOG.info("===============================");
            if (paramList.isEmpty()) {
                dataSet = HRDBUtil.queryDataSet((String)"opmc_ExportInItDataService_queryData", (DBRoute)DBRoute.of((String)"hr"), (String)sql, null);
                return dataSet;
            }
            dataSet = HRDBUtil.queryDataSet((String)"opmc_ExportInItDataService_queryData", (DBRoute)DBRoute.of((String)"hr"), (String)sql, (Object[])paramList.toArray());
            return dataSet;
        }
        finally {
            if (depEmpTempTable != null) {
                depEmpTempTable.close();
            }
            if (adminOrgTempTable != null) {
                adminOrgTempTable.close();
            }
        }
    }

    public String getOrgFilter() {
        Set params;
        StringBuilder stringBuilder = new StringBuilder();
        QFilter dataRuleFilter = IHRCS_DATA_PERMISSION_SERVICE.getDataRule(RequestContext.get().getCurrUserId(), "24E05ECYZ6K0", "pmd_perffile", "47150e89000000ac", null);
        if (dataRuleFilter != null && dataRuleFilter.getValue() != null && dataRuleFilter.getValue() instanceof Set && (params = (Set)dataRuleFilter.getValue()) != null && !params.isEmpty()) {
            int index = 0;
            for (Object param : params) {
                stringBuilder.append(param);
                if (index != params.size() - 1) {
                    stringBuilder.append(",");
                }
                ++index;
            }
        }
        return stringBuilder.toString();
    }

    public Map<Long, String> queryOrgNumber(List<Long> params) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        String sql = "select fid id,fnumber number from t_ORG_ORG where 1=1";
        if (params != null && !params.isEmpty()) {
            List paramSets = params.stream().distinct().collect(Collectors.toList());
            StringBuilder stringBuilder = new StringBuilder();
            for (int index = 0; index < paramSets.size(); ++index) {
                stringBuilder.append(paramSets.get(index));
                if (index == paramSets.size() - 1) continue;
                stringBuilder.append(",");
            }
            sql = sql + MessageFormat.format(" and fid in ({0})\n", stringBuilder.toString());
        }
        DataSet rows = HRDBUtil.queryDataSet((String)"opmc_ExportInItDataService_queryOrgNumber", (DBRoute)DBRoute.of((String)"sys"), (String)sql, null);
        for (Row row : rows) {
            resultMap.put(row.getLong("id"), row.getString("number"));
        }
        rows.close();
        return resultMap;
    }
}

