/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.business.domain.objective.entityservice;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.pmd.business.ServiceFactory;
import kd.opmc.pmd.business.domain.objective.enums.ObjTypeEnum;
import kd.opmc.pmd.business.domain.objective.enums.ObjectiveStatusEnum;
import kd.opmc.pmd.common.constants.ObjectiveConstants;

public class ObjectiveEntityService
implements ObjectiveConstants {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pmd_objective");

    public static ObjectiveEntityService getInstance() {
        return ServiceFactory.getService(ObjectiveEntityService.class);
    }

    public DynamicObject generateEmpty() {
        return HELPER.generateEmptyDynamicObject();
    }

    public Object saveOne(DynamicObject dynamicObject) {
        return HELPER.saveOne(dynamicObject);
    }

    public Object[] save(DynamicObject[] dynamicObjects) {
        return HELPER.save(dynamicObjects);
    }

    public DynamicObject loadSingle(Long pkId) {
        return HELPER.loadSingle((Object)pkId);
    }

    public DynamicObject[] query(String selectFields, List<QFilter> filters) {
        if (ObjectUtils.isEmpty(filters)) {
            return new DynamicObject[0];
        }
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = "id";
        }
        return HELPER.query(selectFields, filters.toArray(new QFilter[0]), "objstatus asc, risklevel desc");
    }

    public DynamicObject[] queryByIds(String selectFields, List<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return new DynamicObject[0];
        }
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = "id";
        }
        return HELPER.query(selectFields, new QFilter[]{new QFilter("id", "in", ids)}, "objstatus asc, risklevel desc");
    }

    public DynamicObject getObjectiveById(Long id) {
        return HELPER.queryOne("id,objstatus", new QFilter[]{new QFilter("id", "in", (Object)id)});
    }

    public void delete(Object[] pks) {
        HELPER.delete(pks);
    }

    public DynamicObject queryById(String selectFields, Long id) {
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = "id";
        }
        return HELPER.queryOne(selectFields, (Object)id);
    }

    public DynamicObject[] queryByDutyOrgId(long currentPotId) {
        QFilter dutyorg = new QFilter("dutyorg", "=", (Object)currentPotId);
        QFilter objtype = new QFilter("objtype", "=", (Object)ObjTypeEnum.TEAM.getValue());
        return HELPER.query("id", new QFilter[]{dutyorg, objtype});
    }

    public DynamicObject[] queryByDutyPersonId(List<Long> dutyPersonIds) {
        QFilter dutyperson = new QFilter("dutyperson", "in", dutyPersonIds);
        QFilter objtype = new QFilter("objtype", "=", (Object)ObjTypeEnum.PERSONAL.getValue());
        return HELPER.query("id", new QFilter[]{dutyperson, objtype});
    }

    public DynamicObject[] queryDraftsByCurrentUser(QFilter cycleFilter) {
        QFilter createFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter objStatusFilter = new QFilter("objstatus", "=", (Object)ObjectiveStatusEnum.DRAFTING.getStatus());
        return HELPER.query("id", new QFilter[]{createFilter, objStatusFilter, cycleFilter}, "createtime desc");
    }
}

