/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.business.domain.objective.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.pbs.business.domain.pot.enums.TeamRoleEnum;
import kd.opmc.pbs.business.domain.pot.service.PotMemberDomainService;
import kd.opmc.pmd.business.ServiceFactory;
import kd.opmc.pmd.business.application.service.PotApplicationService;
import kd.opmc.pmd.business.application.service.PotMemberApplicationService;
import kd.opmc.pmd.business.domain.objective.entityservice.ObjectiveCoopPersonEntityService;
import kd.opmc.pmd.business.domain.objective.entityservice.ObjectiveEntityService;
import kd.opmc.pmd.business.domain.objective.enums.ObjRelationshipEnum;
import kd.opmc.pmd.business.domain.objective.enums.ObjectiveStatusEnum;

public class ObjectiveDomainService {
    private static final ObjectiveEntityService OBJECTIVE_ENTITY_SERVICE = ObjectiveEntityService.getInstance();
    private static final ObjectiveCoopPersonEntityService COOP_PERSON_ENTITY_SERVICE = ObjectiveCoopPersonEntityService.getInstance();
    private static final PotMemberDomainService POT_MEMBER_BASE_SERVICE = PotMemberDomainService.getInstance();
    private static final PotApplicationService POT_APP_SERVICE = PotApplicationService.getInstance();
    private static final PotMemberApplicationService POT_MEMBER_APP_SERVICE = PotMemberApplicationService.getInstance();

    public static ObjectiveDomainService getInstance() {
        return ServiceFactory.getService(ObjectiveDomainService.class);
    }

    public DynamicObject[] query(String selectFields, List<QFilter> filters) {
        return OBJECTIVE_ENTITY_SERVICE.query(selectFields, filters);
    }

    public DynamicObject[] queryByIds(String selectFields, List<Long> ids) {
        return OBJECTIVE_ENTITY_SERVICE.queryByIds(selectFields, ids);
    }

    public DynamicObject queryById(String selectFields, Long id) {
        return OBJECTIVE_ENTITY_SERVICE.queryById(selectFields, id);
    }

    public Object[] save(DynamicObject[] dynamicObjects) {
        return OBJECTIVE_ENTITY_SERVICE.save(dynamicObjects);
    }

    public void updateObjectiveStatus(Long objId, String status) {
        DynamicObject dynamicObject = OBJECTIVE_ENTITY_SERVICE.getObjectiveById(objId);
        if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
            dynamicObject.set("objstatus", (Object)status);
            OBJECTIVE_ENTITY_SERVICE.saveOne(dynamicObject);
        }
    }

    public DynamicObject loadSingle(Long pkId) {
        return OBJECTIVE_ENTITY_SERVICE.loadSingle(pkId);
    }

    public void confirm(DynamicObject[] dataEntitys) {
        for (DynamicObject dataEntity : dataEntitys) {
            if (!StringUtils.equals((CharSequence)dataEntity.getString("objstatus"), (CharSequence)ObjectiveStatusEnum.CONFIRMATION_IN_PROGRESS.getStatus())) continue;
            this.setObjStatus(dataEntity);
        }
        OBJECTIVE_ENTITY_SERVICE.save(dataEntitys);
    }

    public void accept(Long id) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject memberByUser = POT_MEMBER_BASE_SERVICE.getPotMemberByUser(Long.valueOf(currUserId));
        DynamicObject dynamicObject = OBJECTIVE_ENTITY_SERVICE.queryById("evalperson", id);
        dynamicObject.set("evalperson", (Object)memberByUser);
        OBJECTIVE_ENTITY_SERVICE.saveOne(dynamicObject);
    }

    public void setObjStatus(DynamicObject dataEntity) {
        BigDecimal progress;
        Date now;
        Date startDate = HRDateTimeUtils.truncateDate((Date)dataEntity.getDate("startdate"));
        Date endDate = HRDateTimeUtils.truncateDate((Date)dataEntity.getDate("enddate"));
        if (this.isToBeEvaluated(endDate, now = HRDateTimeUtils.truncateDate((Date)new Date()), progress = dataEntity.getBigDecimal("progress"))) {
            dataEntity.set("objstatus", (Object)ObjectiveStatusEnum.TO_BE_EVALUATED.getStatus());
            this.defaultSettingEvalPerson(dataEntity);
        } else if (this.isInExecution(startDate, endDate, now, progress)) {
            dataEntity.set("objstatus", (Object)ObjectiveStatusEnum.IN_EXECUTION.getStatus());
        } else if (now.before(startDate)) {
            dataEntity.set("objstatus", (Object)ObjectiveStatusEnum.TO_BE_EXECUTED.getStatus());
        }
    }

    private void defaultSettingEvalPerson(DynamicObject dataEntity) {
        DynamicObject evalPerson = dataEntity.getDynamicObject("evalperson");
        if (ObjectUtils.isEmpty((Object)evalPerson)) {
            DynamicObject dutyPerson = dataEntity.getDynamicObject("dutyperson");
            if (ObjectUtils.isEmpty((Object)dutyPerson)) {
                return;
            }
            long teamRoleId = dutyPerson.getLong("teamrole.id");
            if (TeamRoleEnum.TEAM_LEADER.getRoleId() == teamRoleId) {
                this.isTeamLeader(dataEntity, dutyPerson);
            } else {
                DynamicObject parent = dutyPerson.getDynamicObject("parent");
                dataEntity.set("evalperson", (Object)parent);
            }
        }
    }

    private void isTeamLeader(DynamicObject dataEntity, DynamicObject dutyPerson) {
        String cPotLongNum = dutyPerson.getDynamicObject("pot").getString("longnumber");
        String[] numArr = cPotLongNum.split("\\.");
        if (numArr.length >= 2) {
            String parentNum = numArr[numArr.length - 2];
            DynamicObject pot = POT_APP_SERVICE.queryByNum(parentNum);
            if (!ObjectUtils.isEmpty((Object)pot)) {
                long potId = pot.getLong("id");
                DynamicObject teamLeader = POT_MEMBER_APP_SERVICE.queryTeamLeader(potId);
                dataEntity.set("evalperson", (Object)teamLeader);
            }
        } else {
            dataEntity.set("evalperson", (Object)dutyPerson);
        }
    }

    private boolean isInExecution(Date startDate, Date endDate, Date now, BigDecimal progress) {
        return progress.longValue() < 100L && (startDate.before(now) && now.before(endDate) || startDate.equals(now) || now.equals(endDate));
    }

    private boolean isToBeEvaluated(Date endDate, Date now, BigDecimal progress) {
        return endDate.before(now) || progress.longValue() == 100L;
    }

    public void reject(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("objstatus", (Object)ObjectiveStatusEnum.DRAFTING.getStatus());
        }
        OBJECTIVE_ENTITY_SERVICE.save(dataEntities);
    }

    public void abandon(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("objstatus", (Object)ObjectiveStatusEnum.OBSOLETE.getStatus());
        }
        OBJECTIVE_ENTITY_SERVICE.save(dataEntities);
    }

    public void open(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            this.setObjStatus(dataEntity);
        }
        OBJECTIVE_ENTITY_SERVICE.save(dataEntities);
    }

    public List<ObjRelationshipEnum> getObjRelationship(Long objId, DynamicObject[] potMembers) {
        List potIds;
        DynamicObject dutyPerson;
        DynamicObjectCollection coopPersons;
        boolean anyMatch;
        List potMemberIds = Arrays.stream(potMembers).map(potMember -> potMember.getLong("id")).collect(Collectors.toList());
        DynamicObject dynamicObject = OBJECTIVE_ENTITY_SERVICE.loadSingle(objId);
        ArrayList<ObjRelationshipEnum> relationships = new ArrayList<ObjRelationshipEnum>();
        if (potMemberIds.contains(dynamicObject.getLong("dutyperson.id"))) {
            relationships.add(ObjRelationshipEnum.DUTY);
        }
        if (potMemberIds.contains(dynamicObject.getLong("fromperson.id"))) {
            relationships.add(ObjRelationshipEnum.FROM);
        }
        if (potMemberIds.contains(dynamicObject.getLong("evalperson.id"))) {
            relationships.add(ObjRelationshipEnum.EVALUATION);
        }
        if (anyMatch = (coopPersons = dynamicObject.getDynamicObjectCollection("coopperson")).stream().anyMatch(coopPerson -> potMemberIds.contains(coopPerson.getDynamicObject("fbasedataid").getLong("id")))) {
            relationships.add(ObjRelationshipEnum.COOPERATION);
        }
        long potId = 0L;
        DynamicObject dutyOrg = dynamicObject.getDynamicObject("dutyorg");
        if (!ObjectUtils.isEmpty((Object)dutyOrg)) {
            potId = dutyOrg.getLong("id");
        }
        if (!ObjectUtils.isEmpty((Object)(dutyPerson = dynamicObject.getDynamicObject("dutyperson")))) {
            potId = dutyPerson.getLong("pot.id");
        }
        if ((potIds = Arrays.stream(potMembers).map(potMember -> potMember.getLong("pot.id")).collect(Collectors.toList())).contains(potId)) {
            relationships.add(ObjRelationshipEnum.TEAMMEMBER);
        }
        return relationships;
    }

    public List<Long> getObjectiveIdByMember(Collection<Long> memberIds) {
        return COOP_PERSON_ENTITY_SERVICE.getObjectiveIdByMember(memberIds);
    }

    public void delete(Object[] pks) {
        OBJECTIVE_ENTITY_SERVICE.delete(pks);
    }

    public DynamicObject[] queryDraftsByCurrentUser(QFilter cycleFilter) {
        return OBJECTIVE_ENTITY_SERVICE.queryDraftsByCurrentUser(cycleFilter);
    }
}

