/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.business.domain.perffile.service;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.pbs.business.external.hpfs.IPersonChgService;
import kd.opmc.pbs.business.external.hrcs.IStrategyService;
import kd.opmc.pbs.business.external.hrpi.IDepempService;
import kd.opmc.pbs.business.external.hrpi.IEmployeeService;
import kd.opmc.pbs.business.external.hrpi.IHRPIPersonService;
import kd.opmc.pbs.common.utils.OpmcDateUtils;
import kd.opmc.pmd.business.ServiceFactory;
import kd.opmc.pmd.business.domain.perffile.entity.ChgInfoBo;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileChangeEntityService;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;
import kd.opmc.pmd.business.domain.perffile.enums.PersonnelChangeTypeEnum;
import kd.opmc.pmd.business.ext.IPerffileChangeService;
import kd.opmc.pmd.common.constants.PerffilePageConstants;

public class PerffileChangeDomainService {
    private static final Log LOG = LogFactory.getLog(PerffileChangeDomainService.class);
    private static final PerffileChangeEntityService PERFFILE_CHANGE_ENTITY_SERVICE = PerffileChangeEntityService.getInstance();
    private static final PerffileEntityService PERFFILE_ENTITY_SERVICE = PerffileEntityService.getInstance();
    private static final IPersonChgService PERSON_CHG_SERVICE = IPersonChgService.getInstance();
    private static final IDepempService DEPEMP_SERVICE = IDepempService.getInstance();
    private static final IStrategyService STRATEGY_SERVICE = IStrategyService.getInstance();
    private static final IEmployeeService EMPLOYEE_SERVICE = IEmployeeService.getInstance();
    private static final IHRPIPersonService PERSON_SERVICE = IHRPIPersonService.getInstance();
    private static final IPerffileChangeService PERFFILE_CHANGE_SERVICE = IPerffileChangeService.getInstance();
    private static final String DEFAULT_DATA_SOURCE = "30";

    public static PerffileChangeDomainService getInstance() {
        return ServiceFactory.getService(PerffileChangeDomainService.class);
    }

    public void consumePersonnelChange(String name, Long actionId, Long recordId) {
        if (PERFFILE_CHANGE_ENTITY_SERVICE.isExistsChgRecordId(recordId)) {
            throw new KDBizException("repeat consume.");
        }
        ChgInfoBo chgInfoBo = this.parseChgInfo(name, actionId, recordId);
        PersonnelChangeTypeEnum changeTypeEnum = PersonnelChangeTypeEnum.getChangeType(chgInfoBo.getChgCategoryId());
        switch (changeTypeEnum) {
            case ONBRD_HIRE: {
                chgInfoBo = this.getParseChgInfoNew(name, actionId, recordId);
                this.handleOnbrdHire(chgInfoBo);
                break;
            }
            case QUIT_HIRE: {
                this.handleQuitHire(chgInfoBo);
                break;
            }
            case ONBRD_PRACTICE: {
                this.handleOnbrdPractice(chgInfoBo);
                break;
            }
            case INTRA_TRANS: {
                this.handleIntraTrans(chgInfoBo);
                break;
            }
            case CROSS_TRANS: {
                this.handleCrossTrans(chgInfoBo);
                break;
            }
            case QUIT_PRACTICE: {
                this.handleQuitPractice(chgInfoBo);
                break;
            }
            case ASSIGN: {
                this.handleAssign(chgInfoBo);
                break;
            }
            case PART_TIME: {
                this.handlePartTime(chgInfoBo);
                break;
            }
            case TERM_PART_TIME: {
                this.handleTermPartTime(chgInfoBo);
                break;
            }
            case BEAREG_HIRE: {
                this.handleBeARegHire(chgInfoBo);
                break;
            }
            case TERM_ASSIGN: {
                this.handleTermAssign(chgInfoBo);
                break;
            }
            case CHANGE_EMP_INFO: {
                this.handleEmpInfoChange(chgInfoBo);
                break;
            }
        }
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)PERFFILE_CHANGE_SERVICE, IPerffileChangeService.class, (String)"kd.opmc.pmd.business.ext.impl.PerffileChangeServiceImpl#afterConsumePersonnelChange", (PluginFilter)null);
        ChgInfoBo finalChgInfoBo = chgInfoBo;
        pluginProxy.callAfter(p -> {
            p.afterConsumePersonnelChange(finalChgInfoBo);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEmpInfoChange(ChgInfoBo chgInfoBo) {
        DynamicObject[] perffiles = PERFFILE_ENTITY_SERVICE.queryPerffileByPersonId(chgInfoBo.getPersonId());
        if (perffiles.length == 0) {
            LOG.error("no performance file to change");
            return;
        }
        ArrayList newPerffiles = Lists.newArrayListWithExpectedSize((int)perffiles.length);
        DynamicObject perffileChange = null;
        for (DynamicObject perffile : perffiles) {
            perffileChange = this.generateEmpInfoChange(perffile, chgInfoBo, PersonnelChangeTypeEnum.CHANGE_EMP_INFO);
            DynamicObject newPerffile = PERFFILE_ENTITY_SERVICE.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)perffile, (DynamicObject)newPerffile);
            newPerffile.set("billno", (Object)perffileChange.getString("pnumber"));
            newPerffile.set("name", (Object)perffileChange.getString("pname"));
            if (perffileChange.getString("pnumber").equals(perffile.getString("billno")) && perffileChange.getString("pname").equals(perffile.getString("name"))) {
                LOG.error("perffile name or number is not change");
                return;
            }
            newPerffiles.add(newPerffile);
        }
        try (TXHandle txhandle = TX.required();){
            PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
            PERFFILE_ENTITY_SERVICE.saveHis(newPerffiles.toArray(new DynamicObject[0]));
        }
    }

    private void handleBeARegHire(ChgInfoBo chgInfoBo) {
        DynamicObject perffile = PERFFILE_ENTITY_SERVICE.queryPerffileByDepempId(chgInfoBo.getDepempaId());
        if (perffile != null) {
            LOG.error("The performance file already exists, no need to add it.");
            return;
        }
        DynamicObject perffileChange = this.generateAddChange(chgInfoBo, PersonnelChangeTypeEnum.BEAREG_HIRE);
        if (perffileChange == null) {
            throw new KDBizException("no performance BU.");
        }
        PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
    }

    private void handleTermPartTime(ChgInfoBo chgInfoBo) {
        DynamicObject perffile = PERFFILE_ENTITY_SERVICE.queryPerffileByDepempId(chgInfoBo.getDepempbId());
        if (perffile == null) {
            LOG.error("no performance file to expire");
            return;
        }
        DynamicObject perffileChange = this.generateEfficacyChange(chgInfoBo, PersonnelChangeTypeEnum.TERM_PART_TIME, perffile);
        perffileChange.set("processstatus", (Object)"1");
        PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
    }

    private void handlePartTime(ChgInfoBo chgInfoBo) {
        DynamicObject perffileChangeAdd = this.generateAddChange(chgInfoBo, PersonnelChangeTypeEnum.PART_TIME);
        if (perffileChangeAdd == null) {
            LOG.error("no performance BU or no empposrel info by depempid. depempId:", (Object)chgInfoBo.getDepempaId());
            throw new KDBizException("no performance BU or no empposrel info by depempid. depempId: " + chgInfoBo.getDepempaId());
        }
        PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChangeAdd);
    }

    private void handleAssign(ChgInfoBo chgInfoBo) {
        DynamicObject perffileChangeAdd = this.generateAddChange(chgInfoBo, PersonnelChangeTypeEnum.ASSIGN);
        if (perffileChangeAdd == null) {
            LOG.error("no performance BU DepempaId:", (Object)chgInfoBo.getDepempaId());
            throw new KDBizException("no performance BU. DepempaId : " + chgInfoBo.getDepempaId());
        }
        PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChangeAdd);
    }

    private void handleTermAssign(ChgInfoBo chgInfoBo) {
        DynamicObject perffile = PERFFILE_ENTITY_SERVICE.queryPerffileByDepempId(chgInfoBo.getDepempbId());
        if (perffile == null) {
            LOG.error("no performance file to expire");
            return;
        }
        DynamicObject perffileChange = this.generateEfficacyChange(chgInfoBo, PersonnelChangeTypeEnum.TERM_ASSIGN, perffile);
        perffileChange.set("processstatus", (Object)"1");
        PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
    }

    private DynamicObject generateEfficacyChange(ChgInfoBo chgInfoBo, PersonnelChangeTypeEnum changeTypeEnum, DynamicObject beforePerffile) {
        DynamicObject perffileChange = PERFFILE_CHANGE_ENTITY_SERVICE.generateEmpty();
        perffileChange.set("chgrecord", (Object)chgInfoBo.getRecordId());
        perffileChange.set("changetype", (Object)changeTypeEnum.getChangeType());
        perffileChange.set("detailtype", (Object)changeTypeEnum.getDetailType());
        perffileChange.set("person", (Object)chgInfoBo.getPersonId());
        perffileChange.set("employee", (Object)chgInfoBo.getEmployeeId());
        perffileChange.set("depempb", (Object)beforePerffile.getLong("depemp.id"));
        perffileChange.set("affiliateorgb", beforePerffile.get("affiliateadminorg"));
        DynamicObject empInfo = beforePerffile.getDynamicObject("empposrel");
        perffileChange.set("empposrelb", (Object)empInfo.getLong("id"));
        perffileChange.set("perforgb", beforePerffile.get("pmdorg"));
        perffileChange.set("org", beforePerffile.get("pmdorg"));
        perffileChange.set("bsled", empInfo.get("enddate"));
        perffileChange.set("processstatus", (Object)"1");
        perffileChange.set("advise", (Object)"2");
        this.getEfficacyChangeExt(beforePerffile, perffileChange, chgInfoBo);
        return perffileChange;
    }

    private void getEfficacyChangeExt(DynamicObject beforePerffile, DynamicObject perffileChange, ChgInfoBo chgInfoBo) {
        DynamicObject empInfo = beforePerffile.getDynamicObject("empposrel");
        perffileChange.set("chgmode", (Object)"2");
        perffileChange.set("action", (Object)chgInfoBo.getActionId());
        perffileChange.set("changedate", (Object)chgInfoBo.getChangeDate());
        perffileChange.set("company", empInfo.get("company"));
        perffileChange.set("job", empInfo.get("job"));
        perffileChange.set("posenddate", empInfo.get("enddate"));
        perffileChange.set("position", empInfo.get("position"));
        perffileChange.set("postype", empInfo.get("postype"));
        perffileChange.set("adminorg", empInfo.get("adminorg"));
        DynamicObject employee = beforePerffile.getDynamicObject("employee");
        perffileChange.set("laborrelstatus", employee != null ? employee.get("laborrelstatus") : null);
        perffileChange.set("employeedate", beforePerffile.get("employedate"));
        perffileChange.set("createway", (Object)"10");
        perffileChange.set("pname", beforePerffile.get("name"));
        perffileChange.set("pnumber", beforePerffile.get("billno"));
        perffileChange.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"pmd_perffilechange", (DynamicObject)perffileChange, null));
        perffileChange.set("name", (Object)ResManager.loadKDString((String)"%s\u4efb\u52a1", (String)"PerffileChangeDomainService_0", (String)"opmc-pmd-business", (Object[])new Object[]{chgInfoBo.getName()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOnbrdHire(ChgInfoBo chgInfoBo) {
        DynamicObject perffileChange = this.generateAddChange(chgInfoBo, PersonnelChangeTypeEnum.ONBRD_HIRE);
        if (perffileChange == null) {
            throw new KDBizException("no performance BU.");
        }
        DynamicObject perffile = this.generatePerffile(perffileChange);
        perffileChange.set("processstatus", (Object)"2");
        try (TXHandle txhandle = TX.required();){
            PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
            PERFFILE_ENTITY_SERVICE.saveHis(new DynamicObject[]{perffile});
        }
    }

    private void handleQuitHire(ChgInfoBo chgInfoBo) {
        this.cancelChangeOnQuit(chgInfoBo.getEmployeeId());
        DynamicObject[] perffileLeaves = PERFFILE_ENTITY_SERVICE.queryPerffileByEmpId(chgInfoBo.getEmployeeId());
        if (perffileLeaves.length == 0) {
            LOG.error("no performance file to expire, employee id:{}", (Object)chgInfoBo.getEmployeeId());
            return;
        }
        for (DynamicObject perffileLeave : perffileLeaves) {
            DynamicObject perffileChange = this.generateQuitChange(chgInfoBo, PersonnelChangeTypeEnum.QUIT_HIRE, perffileLeave);
            perffileChange.set("processstatus", (Object)"1");
            PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
        }
    }

    private void handleOnbrdPractice(ChgInfoBo chgInfoBo) {
        DynamicObject perffileChange = this.generateAddChange(chgInfoBo, PersonnelChangeTypeEnum.ONBRD_PRACTICE);
        if (perffileChange == null) {
            throw new KDBizException("no performance BU.");
        }
        PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIntraTrans(ChgInfoBo chgInfoBo) {
        this.cancelChangeOnTrans(chgInfoBo.getDepempbId());
        DynamicObject perfFileLeave = PERFFILE_ENTITY_SERVICE.queryPerffileByDepempId(chgInfoBo.getDepempbId());
        ArrayList<DynamicObject> transChangeList = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> perfFileList = new ArrayList<DynamicObject>(2);
        DynamicObject perfFileAddChange = this.generateTransAddChange(chgInfoBo, PersonnelChangeTypeEnum.INTRA_TRANS, perfFileLeave);
        if (perfFileAddChange != null) {
            DynamicObject perfFileAdd = this.generatePerffile(perfFileAddChange);
            perfFileAddChange.set("processstatus", (Object)"2");
            perfFileList.add(perfFileAdd);
            transChangeList.add(perfFileAddChange);
        }
        if (!HRObjectUtils.isEmpty((Object)perfFileLeave)) {
            DynamicObject perfFileLeaveChange = PERFFILE_CHANGE_ENTITY_SERVICE.generateEmpty();
            if (perfFileAddChange != null) {
                HRDynamicObjectUtils.copy((DynamicObject)perfFileAddChange, (DynamicObject)perfFileLeaveChange);
                perfFileLeaveChange.set("org", perfFileLeave.get("pmdorg"));
                perfFileLeaveChange.set("advise", (Object)"2");
                perfFileLeaveChange.set("chgmode", (Object)"2");
            } else {
                this.generateTransLeaveChange(perfFileLeaveChange, chgInfoBo, PersonnelChangeTypeEnum.INTRA_TRANS, perfFileLeave);
            }
            perfFileLeaveChange.set("processstatus", (Object)"2");
            DynamicObject perfFileUpdate = PERFFILE_ENTITY_SERVICE.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)perfFileLeave, (DynamicObject)perfFileUpdate);
            perfFileUpdate.set("bsed", perfFileLeaveChange.get("bsled"));
            perfFileUpdate.set("enddate", perfFileLeaveChange.get("bsled"));
            perfFileUpdate.set("archivesstatus", (Object)"2");
            perfFileList.add(perfFileUpdate);
            transChangeList.add(perfFileLeaveChange);
        }
        if (transChangeList.size() > 0) {
            try (TXHandle txhandle = TX.required();){
                PERFFILE_CHANGE_ENTITY_SERVICE.save(transChangeList.toArray(new DynamicObject[0]));
                PERFFILE_ENTITY_SERVICE.saveHis(perfFileList.toArray(new DynamicObject[0]));
            }
        } else {
            throw new KDBizException("no performance BU or perffile to leave.");
        }
    }

    private void handleCrossTrans(ChgInfoBo chgInfoBo) {
        this.cancelChangeOnTrans(chgInfoBo.getDepempbId());
        DynamicObject perfFileLeave = PERFFILE_ENTITY_SERVICE.queryPerffileByDepempId(chgInfoBo.getDepempbId());
        ArrayList<DynamicObject> transChangeList = new ArrayList<DynamicObject>(2);
        DynamicObject perfFileAddChange = this.generateTransAddChange(chgInfoBo, PersonnelChangeTypeEnum.CROSS_TRANS, perfFileLeave);
        if (perfFileAddChange != null) {
            transChangeList.add(perfFileAddChange);
        }
        if (!HRObjectUtils.isEmpty((Object)perfFileLeave)) {
            DynamicObject perfFileLeaveChange = PERFFILE_CHANGE_ENTITY_SERVICE.generateEmpty();
            if (perfFileAddChange != null) {
                HRDynamicObjectUtils.copy((DynamicObject)perfFileAddChange, (DynamicObject)perfFileLeaveChange);
                perfFileLeaveChange.set("org", perfFileLeave.get("pmdorg"));
                perfFileLeaveChange.set("advise", (Object)"2");
                this.getEfficacyChangeExt(perfFileLeave, perfFileLeaveChange, chgInfoBo);
            } else {
                this.generateTransLeaveChange(perfFileLeaveChange, chgInfoBo, PersonnelChangeTypeEnum.CROSS_TRANS, perfFileLeave);
            }
            transChangeList.add(perfFileLeaveChange);
        }
        if (transChangeList.size() <= 0) {
            throw new KDBizException("no performance BU or perffile to leave.");
        }
        PERFFILE_CHANGE_ENTITY_SERVICE.save(transChangeList.toArray(new DynamicObject[0]));
    }

    private void handleQuitPractice(ChgInfoBo chgInfoBo) {
        this.cancelChangeOnQuit(chgInfoBo.getEmployeeId());
        DynamicObject[] perffileLeaves = PERFFILE_ENTITY_SERVICE.queryPerffileByEmpId(chgInfoBo.getEmployeeId());
        if (perffileLeaves.length == 0) {
            LOG.error("no performance file to expire, employee id:{}", (Object)chgInfoBo.getEmployeeId());
            return;
        }
        for (DynamicObject perffileLeave : perffileLeaves) {
            DynamicObject perffileChange = this.generateQuitChange(chgInfoBo, PersonnelChangeTypeEnum.QUIT_PRACTICE, perffileLeave);
            this.getEfficacyChangeExt(perffileLeave, perffileChange, chgInfoBo);
            PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
        }
    }

    private DynamicObject generateEmpInfoChange(DynamicObject beforePerffile, ChgInfoBo chgInfoBo, PersonnelChangeTypeEnum changeTypeEnum) {
        DynamicObject perffileChange = PERFFILE_CHANGE_ENTITY_SERVICE.generateEmpty();
        perffileChange.set("chgrecord", (Object)chgInfoBo.getRecordId());
        perffileChange.set("changetype", (Object)changeTypeEnum.getChangeType());
        perffileChange.set("detailtype", (Object)changeTypeEnum.getDetailType());
        perffileChange.set("person", (Object)chgInfoBo.getPersonId());
        perffileChange.set("employee", (Object)chgInfoBo.getEmployeeId());
        perffileChange.set("depempa", (Object)beforePerffile.getLong("depemp.id"));
        perffileChange.set("affiliateorga", beforePerffile.get("affiliateadminorg"));
        DynamicObject empInfo = beforePerffile.getDynamicObject("empposrel");
        perffileChange.set("empposrela", (Object)empInfo.getLong("id"));
        perffileChange.set("perforga", beforePerffile.get("pmdorg"));
        perffileChange.set("org", beforePerffile.get("pmdorg"));
        perffileChange.set("processstatus", (Object)"2");
        perffileChange.set("chgmode", (Object)"2");
        perffileChange.set("action", (Object)chgInfoBo.getActionId());
        perffileChange.set("changedate", (Object)chgInfoBo.getChangeDate());
        perffileChange.set("company", empInfo.get("company"));
        perffileChange.set("job", empInfo.get("job"));
        perffileChange.set("posenddate", empInfo.get("enddate"));
        perffileChange.set("position", empInfo.get("position"));
        perffileChange.set("postype", empInfo.get("postype"));
        perffileChange.set("adminorg", empInfo.get("adminorg"));
        DynamicObject employee = beforePerffile.getDynamicObject("employee");
        perffileChange.set("laborrelstatus", employee != null ? employee.get("laborrelstatus") : null);
        perffileChange.set("employeedate", beforePerffile.get("employedate"));
        perffileChange.set("createway", (Object)"10");
        Map personBaseInfo = PERSON_SERVICE.getPersonBaseInfo(chgInfoBo.getPersonId());
        perffileChange.set("pname", personBaseInfo.get("name"));
        perffileChange.set("pnumber", personBaseInfo.get("number"));
        perffileChange.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"pmd_perffilechange", (DynamicObject)perffileChange, null));
        perffileChange.set("name", (Object)ResManager.loadKDString((String)"%s\u4efb\u52a1", (String)"PerffileChangeDomainService_0", (String)"opmc-pmd-business", (Object[])new Object[]{chgInfoBo.getName()}));
        return perffileChange;
    }

    private DynamicObject generateAddChange(ChgInfoBo chgInfoBo, PersonnelChangeTypeEnum changeTypeEnum) {
        Map empposrelInfo = DEPEMP_SERVICE.getEmpOrgrel(chgInfoBo.getDepempaId());
        if (empposrelInfo.size() <= 0) {
            LOG.error("no empposrel info, depempaId:{}", (Object)chgInfoBo.getDepempaId());
            return null;
        }
        Long adminOrgId = (Long)empposrelInfo.get("adminorg_id");
        Long perfOrgId = STRATEGY_SERVICE.getPerfOrgId(adminOrgId);
        if (perfOrgId <= 0L) {
            LOG.error("no performance BU, adminOrgId:{}", (Object)adminOrgId);
            return null;
        }
        DynamicObject perffileChange = PERFFILE_CHANGE_ENTITY_SERVICE.generateEmpty();
        perffileChange.set("affiliateorga", (Object)adminOrgId);
        perffileChange.set("perforga", (Object)perfOrgId);
        perffileChange.set("org", (Object)perfOrgId);
        this.getAddChangeExt(perffileChange, chgInfoBo, empposrelInfo);
        return this.getChangeDynamicObject(chgInfoBo, changeTypeEnum, empposrelInfo, perffileChange);
    }

    private DynamicObject getChangeDynamicObject(ChgInfoBo chgInfoBo, PersonnelChangeTypeEnum changeTypeEnum, Map<String, Object> empposrelInfo, DynamicObject perffileChange) {
        perffileChange.set("empposrela", empposrelInfo.get("boid"));
        perffileChange.set("chgrecord", (Object)chgInfoBo.getRecordId());
        perffileChange.set("changetype", (Object)changeTypeEnum.getChangeType());
        perffileChange.set("detailtype", (Object)changeTypeEnum.getDetailType());
        perffileChange.set("person", (Object)chgInfoBo.getPersonId());
        perffileChange.set("employee", (Object)chgInfoBo.getEmployeeId());
        perffileChange.set("depempa", (Object)chgInfoBo.getDepempaId());
        perffileChange.set("bsed", empposrelInfo.get("startdate"));
        perffileChange.set("processstatus", (Object)"1");
        perffileChange.set("ismanaged", (Object)false);
        perffileChange.set("empgroup", (Object)PerffilePageConstants.DEFULTE_PMDPERSON);
        perffileChange.set("advise", (Object)"1");
        perffileChange.set("assesspolicy", (Object)PerffilePageConstants.DEFULTE_POLICY);
        return perffileChange;
    }

    public DynamicObject generatePerffile(DynamicObject perffileChange) {
        DynamicObject perffile = PERFFILE_ENTITY_SERVICE.generateEmptyDynamicObject();
        perffile.set("depemp", perffileChange.get("depempa"));
        perffile.set("bsed", perffileChange.get("bsed"));
        perffile.set("startdate", perffileChange.get("bsed"));
        perffile.set("enddate", (Object)OpmcDateUtils.getDefaultBsled());
        perffile.set("pmdorg", perffileChange.get("org"));
        perffile.set("org", perffileChange.get("org"));
        perffile.set("affiliateadminorg", perffileChange.get("affiliateorga"));
        perffile.set("person", perffileChange.get("person"));
        perffile.set("employee", perffileChange.get("employee"));
        perffile.set("isescrow", perffileChange.get("ismanaged"));
        perffile.set("archivesstatus", (Object)"1");
        perffile.set("pmdperson", perffileChange.get("empgroup"));
        perffile.set("empposrel", perffileChange.get("empposrela"));
        perffile.getDynamicObjectCollection("policyentryentity").addNew().set("policy", perffileChange.get("assesspolicy"));
        DynamicObject empEntryEntity = perffile.getDynamicObjectCollection("empentryentity").addNew();
        empEntryEntity.set("empposorgrel", perffileChange.get("empposrela"));
        empEntryEntity.set("isprimary", (Object)true);
        String number = CodeRuleServiceHelper.getNumber((String)"pmd_perffile", (DynamicObject)perffile, null);
        perffile.set("number", (Object)number);
        perffile.set("initdatasource", (Object)"0");
        perffile.set("datasource", (Object)DEFAULT_DATA_SOURCE);
        perffile.set("initstatus", (Object)"2");
        perffile.set("billstatus", (Object)"B");
        perffile.set("name", (Object)perffileChange.getString("pname"));
        perffile.set("billno", (Object)perffileChange.getString("pnumber"));
        perffile.set("position", perffileChange.get("position"));
        perffile.set("empposrel", perffileChange.get("empposrela"));
        perffile.set("employedate", perffileChange.get("employeedate"));
        perffile.set("postype", perffileChange.get("postype"));
        perffile.set("company", perffileChange.get("company"));
        perffile.set("adminorg", perffileChange.get("adminorg"));
        perffile.set("job", perffileChange.get("job"));
        return perffile;
    }

    private DynamicObject generateQuitChange(ChgInfoBo chgInfoBo, PersonnelChangeTypeEnum changeTypeEnum, DynamicObject perffileLeave) {
        DynamicObject perffileChange = PERFFILE_CHANGE_ENTITY_SERVICE.generateEmpty();
        perffileChange.set("chgrecord", (Object)chgInfoBo.getRecordId());
        perffileChange.set("changetype", (Object)changeTypeEnum.getChangeType());
        perffileChange.set("detailtype", (Object)changeTypeEnum.getDetailType());
        perffileChange.set("person", (Object)chgInfoBo.getPersonId());
        perffileChange.set("employee", (Object)chgInfoBo.getEmployeeId());
        perffileChange.set("depempb", (Object)perffileLeave.getLong("depemp.id"));
        perffileChange.set("affiliateorgb", perffileLeave.get("affiliateadminorg"));
        perffileChange.set("empposrelb", perffileLeave.get("empposrel"));
        perffileChange.set("perforgb", perffileLeave.get("pmdorg"));
        perffileChange.set("org", perffileLeave.get("pmdorg"));
        Map empInfo = EMPLOYEE_SERVICE.getEmployee(chgInfoBo.getEmployeeId());
        Date empEndDate = (Date)empInfo.get("enddate");
        Date perfBsed = perffileLeave.getDate("bsed");
        perffileChange.set("bsled", (Object)(perfBsed.before(empEndDate) ? empEndDate : OpmcDateUtils.addDay((Date)perfBsed, (long)1L)));
        perffileChange.set("processstatus", (Object)"1");
        perffileChange.set("advise", (Object)"2");
        this.getEfficacyChangeExt(perffileLeave, perffileChange, chgInfoBo);
        return perffileChange;
    }

    private DynamicObject generateTransAddChange(ChgInfoBo chgInfoBo, PersonnelChangeTypeEnum changeTypeEnum, DynamicObject perffileLeave) {
        Map empOrgRel = DEPEMP_SERVICE.getEmpOrgrel(chgInfoBo.getDepempaId());
        Long adminOrgId = (Long)empOrgRel.get("adminorg_id");
        Long perfOrgId = STRATEGY_SERVICE.getPerfOrgId(adminOrgId);
        if (perfOrgId <= 0L) {
            LOG.error("no performance BU, adminOrgId:{}", (Object)adminOrgId);
            return null;
        }
        DynamicObject perffileChange = PERFFILE_CHANGE_ENTITY_SERVICE.generateEmpty();
        perffileChange.set("affiliateorga", (Object)adminOrgId);
        perffileChange.set("perforga", (Object)perfOrgId);
        perffileChange.set("org", (Object)perfOrgId);
        this.getAddChangeExt(perffileChange, chgInfoBo, empOrgRel);
        return this.getPerfChangeDynamicObject(chgInfoBo, changeTypeEnum, perffileLeave, empOrgRel, perffileChange);
    }

    private DynamicObject getPerfChangeDynamicObject(ChgInfoBo chgInfoBo, PersonnelChangeTypeEnum changeTypeEnum, DynamicObject perffileLeave, Map<String, Object> empOrgRel, DynamicObject perffileChange) {
        perffileChange.set("empposrela", empOrgRel.get("boid"));
        perffileChange.set("chgrecord", (Object)chgInfoBo.getRecordId());
        perffileChange.set("changetype", (Object)changeTypeEnum.getChangeType());
        perffileChange.set("detailtype", (Object)changeTypeEnum.getDetailType());
        perffileChange.set("person", (Object)chgInfoBo.getPersonId());
        perffileChange.set("employee", (Object)chgInfoBo.getEmployeeId());
        perffileChange.set("depempa", (Object)chgInfoBo.getDepempaId());
        perffileChange.set("bsed", empOrgRel.get("startdate"));
        perffileChange.set("processstatus", (Object)"1");
        perffileChange.set("ismanaged", (Object)false);
        perffileChange.set("empgroup", (Object)PerffilePageConstants.DEFULTE_PMDPERSON);
        perffileChange.set("advise", (Object)"1");
        perffileChange.set("assesspolicy", (Object)PerffilePageConstants.DEFULTE_POLICY);
        Map depEmpInfo = DEPEMP_SERVICE.getDepemp(chgInfoBo.getDepempbId());
        Long adminOrgBId = (Long)depEmpInfo.get("adminorg_id");
        if (HRObjectUtils.isEmpty((Object)perffileLeave)) {
            perffileChange.set("depempb", (Object)chgInfoBo.getDepempbId());
            perffileChange.set("affiliateorgb", (Object)adminOrgBId);
            Long perfOrgBId = STRATEGY_SERVICE.getPerfOrgId(adminOrgBId);
            perffileChange.set("perforgb", (Object)perfOrgBId);
        } else {
            perffileChange.set("depempb", (Object)chgInfoBo.getDepempbId());
            perffileChange.set("affiliateorgb", perffileLeave.get("affiliateadminorg"));
            perffileChange.set("empposrelb", perffileLeave.get("empposrel"));
            perffileChange.set("perforgb", perffileLeave.get("pmdorg"));
            perffileChange.set("bsled", depEmpInfo.get("enddate"));
        }
        return perffileChange;
    }

    private void getAddChangeExt(DynamicObject perffileChange, ChgInfoBo chgInfoBo, Map<String, Object> depEmpInfo) {
        Map employee = EMPLOYEE_SERVICE.getEmployee(chgInfoBo.getEmployeeId());
        Map personBaseInfo = PERSON_SERVICE.getPersonBaseInfo(chgInfoBo.getPersonId());
        perffileChange.set("chgmode", (Object)"0");
        perffileChange.set("adminorg", depEmpInfo.get("adminorg_id"));
        perffileChange.set("action", (Object)chgInfoBo.getActionId());
        perffileChange.set("changedate", (Object)chgInfoBo.getChangeDate());
        perffileChange.set("company", depEmpInfo.get("company_id"));
        perffileChange.set("job", depEmpInfo.get("job_id"));
        perffileChange.set("posenddate", depEmpInfo.get("enddate"));
        perffileChange.set("position", depEmpInfo.get("position_id"));
        perffileChange.set("postype", depEmpInfo.get("postype_id"));
        perffileChange.set("laborrelstatus", employee.get("laborrelstatus_id"));
        perffileChange.set("employeedate", employee.get("startdate"));
        perffileChange.set("createway", (Object)"10");
        perffileChange.set("pname", personBaseInfo.get("name"));
        perffileChange.set("pnumber", personBaseInfo.get("number"));
        perffileChange.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"pmd_perffilechange", (DynamicObject)perffileChange, null));
        perffileChange.set("name", (Object)ResManager.loadKDString((String)"%s\u4efb\u52a1", (String)"PerffileChangeDomainService_0", (String)"opmc-pmd-business", (Object[])new Object[]{chgInfoBo.getName()}));
    }

    private void generateTransLeaveChange(DynamicObject perfFileLeaveChange, ChgInfoBo chgInfoBo, PersonnelChangeTypeEnum changeTypeEnum, DynamicObject perfFileLeave) {
        perfFileLeaveChange.set("chgrecord", (Object)chgInfoBo.getRecordId());
        perfFileLeaveChange.set("changetype", (Object)changeTypeEnum.getChangeType());
        perfFileLeaveChange.set("detailtype", (Object)changeTypeEnum.getDetailType());
        perfFileLeaveChange.set("person", (Object)chgInfoBo.getPersonId());
        perfFileLeaveChange.set("employee", (Object)chgInfoBo.getEmployeeId());
        perfFileLeaveChange.set("depempb", (Object)perfFileLeave.getLong("depemp.id"));
        perfFileLeaveChange.set("affiliateorgb", perfFileLeave.get("affiliateadminorg"));
        perfFileLeaveChange.set("empposrelb", perfFileLeave.get("empposrel"));
        perfFileLeaveChange.set("perforgb", perfFileLeave.get("pmdorg"));
        perfFileLeaveChange.set("org", perfFileLeave.get("pmdorg"));
        Map depempInfo = DEPEMP_SERVICE.getDepemp(Long.valueOf(perfFileLeave.getLong("depemp.id")));
        perfFileLeaveChange.set("bsled", depempInfo.get("enddate"));
        perfFileLeaveChange.set("processstatus", (Object)"1");
        perfFileLeaveChange.set("advise", (Object)"2");
        Map empOrgRel = DEPEMP_SERVICE.getEmpOrgrel(chgInfoBo.getDepempaId());
        Long adminOrgId = (Long)empOrgRel.get("adminorg_id");
        Long perfOrgId = STRATEGY_SERVICE.getPerfOrgId(adminOrgId);
        perfFileLeaveChange.set("affiliateorga", (Object)adminOrgId);
        perfFileLeaveChange.set("empposrela", empOrgRel.get("boid"));
        perfFileLeaveChange.set("depempa", (Object)chgInfoBo.getDepempaId());
        perfFileLeaveChange.set("perforga", (Object)perfOrgId);
        perfFileLeaveChange.set("bsed", empOrgRel.get("startdate"));
        this.getEfficacyChangeExt(perfFileLeave, perfFileLeaveChange, chgInfoBo);
    }

    private ChgInfoBo parseChgInfo(String name, Long actionId, Long recordId) {
        ChgInfoBo chgInfoBo = new ChgInfoBo();
        chgInfoBo.setRecordId(recordId);
        Map chgInfo = PERSON_CHG_SERVICE.getChgInfoByRecordId(recordId);
        LOG.info("chgInfo :{}", (Object)chgInfo);
        Map data = (Map)chgInfo.get("data");
        if (data.size() == 0) {
            throw new KDBizException("change info is null.");
        }
        Long chgCategoryId = (Long)data.get("chgCategoryId");
        PersonnelChangeTypeEnum changeTypeEnum = PersonnelChangeTypeEnum.getChangeType(chgCategoryId);
        if (changeTypeEnum == null) {
            throw new KDBizException("personnel change type is not support!");
        }
        Date effectTime = new Date((Long)data.get("effectTime"));
        chgInfoBo.setActionId(actionId);
        chgInfoBo.setName(name);
        chgInfoBo.setRecordId(recordId);
        chgInfoBo.setChangeDate(effectTime);
        chgInfoBo.setChgCategoryId(chgCategoryId);
        List changeIdInfoList = (List)data.get("data");
        for (Map changeIdInfo : changeIdInfoList) {
            chgInfoBo.setPersonId((Long)((Map)changeIdInfo.get("hrpi_person")).get("boid"));
            chgInfoBo.setEmployeeId((Long)((Map)changeIdInfo.get("hrpi_employee")).get("boid"));
            Map depEmpMap = (Map)changeIdInfo.get("hrpi_depemp");
            if (CollectionUtils.isEmpty((Map)depEmpMap)) continue;
            String dmpChgMode = (String)depEmpMap.get("chgmode");
            if ("0".equals(dmpChgMode)) {
                chgInfoBo.setDepempaId((Long)depEmpMap.get("boid"));
                continue;
            }
            if ("1".equals(dmpChgMode)) {
                chgInfoBo.setDepempbId((Long)depEmpMap.get("boid"));
                continue;
            }
            if ("2".equals(dmpChgMode)) {
                chgInfoBo.setDepempbId((Long)depEmpMap.get("boid"));
                continue;
            }
            if (changeTypeEnum != PersonnelChangeTypeEnum.BEAREG_HIRE && changeTypeEnum != PersonnelChangeTypeEnum.CHANGE_EMP_INFO) continue;
            chgInfoBo.setDepempaId((Long)depEmpMap.get("boid"));
        }
        return chgInfoBo;
    }

    private ChgInfoBo getParseChgInfoNew(String name, Long actionId, Long recordId) {
        ChgInfoBo chgInfoBo = new ChgInfoBo();
        chgInfoBo.setRecordId(recordId);
        Map chgInfo = PERSON_CHG_SERVICE.getChgInfoByRecordId(recordId);
        LOG.info("chgInfo :{}", (Object)chgInfo);
        Map data = (Map)chgInfo.get("data");
        if (data.size() == 0) {
            throw new KDBizException("change info is null.");
        }
        Long chgCategoryId = (Long)data.get("chgCategoryId");
        PersonnelChangeTypeEnum changeTypeEnum = PersonnelChangeTypeEnum.getChangeType(chgCategoryId);
        if (changeTypeEnum == null) {
            throw new KDBizException("personnel change type is not support!");
        }
        Date effectTime = new Date((Long)data.get("effectTime"));
        chgInfoBo.setActionId(actionId);
        chgInfoBo.setName(name);
        chgInfoBo.setRecordId(recordId);
        chgInfoBo.setChangeDate(effectTime);
        chgInfoBo.setChgCategoryId(chgCategoryId);
        List changeIdInfoList = (List)data.get("data");
        for (Map changeIdInfo : changeIdInfoList) {
            Map depEmpMap;
            String empChgMode;
            String personChgMode;
            Map personChgMap = (Map)changeIdInfo.get("hrpi_person");
            Map empChgMap = (Map)changeIdInfo.get("hrpi_employee");
            if (!CollectionUtils.isEmpty((Map)personChgMap) && "0".equals(personChgMode = (String)personChgMap.get("chgmode"))) {
                chgInfoBo.setPersonId((Long)((Map)changeIdInfo.get("hrpi_person")).get("boid"));
            }
            if (!CollectionUtils.isEmpty((Map)empChgMap) && "0".equals(empChgMode = (String)empChgMap.get("chgmode"))) {
                chgInfoBo.setEmployeeId((Long)((Map)changeIdInfo.get("hrpi_employee")).get("boid"));
            }
            if (CollectionUtils.isEmpty((Map)(depEmpMap = (Map)changeIdInfo.get("hrpi_depemp")))) continue;
            String dmpChgMode = (String)depEmpMap.get("chgmode");
            if ("0".equals(dmpChgMode)) {
                chgInfoBo.setDepempaId((Long)depEmpMap.get("boid"));
                continue;
            }
            if ("1".equals(dmpChgMode)) {
                chgInfoBo.setDepempbId((Long)depEmpMap.get("boid"));
                continue;
            }
            if ("2".equals(dmpChgMode)) {
                chgInfoBo.setDepempbId((Long)depEmpMap.get("boid"));
                continue;
            }
            if (changeTypeEnum != PersonnelChangeTypeEnum.BEAREG_HIRE) continue;
            chgInfoBo.setDepempaId((Long)depEmpMap.get("boid"));
        }
        return chgInfoBo;
    }

    public Object cancelPerffileChange(Long pkId) {
        DynamicObject dynamicObject = PERFFILE_CHANGE_ENTITY_SERVICE.loadSingle(pkId);
        dynamicObject.set("processstatus", (Object)"3");
        return PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(dynamicObject);
    }

    public DynamicObject loadSingle(Long pkId) {
        return PERFFILE_CHANGE_ENTITY_SERVICE.loadSingle(pkId);
    }

    public DynamicObject queryPerffileByDepempId(Long depempId) {
        return PERFFILE_ENTITY_SERVICE.queryPerffileByDepempId(depempId);
    }

    public boolean isExistPerffileByEmpposIdPerOrgId(Long empposId, Long perOrgId) {
        return PERFFILE_ENTITY_SERVICE.isExistPerffileByEmpposIdPerOrgId(empposId, perOrgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPerffileChange(DynamicObject perffileChange) {
        if ("0".equals(perffileChange.getString("chgmode"))) {
            DynamicObject perffile = this.generatePerffile(perffileChange);
            try (TXHandle txhandle = TX.required();){
                PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
                PERFFILE_ENTITY_SERVICE.saveHis(new DynamicObject[]{perffile});
            }
        } else {
            DynamicObject perffileLeave = PERFFILE_ENTITY_SERVICE.queryPerffileByDepempId(perffileChange.getLong("depempb.id"));
            DynamicObject perffileUpdate = PERFFILE_ENTITY_SERVICE.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)perffileLeave, (DynamicObject)perffileUpdate);
            perffileUpdate.set("bsed", perffileChange.get("bsled"));
            perffileUpdate.set("startdate", perffileChange.get("bsled"));
            try {
                perffileUpdate.set("enddate", (Object)HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                LOG.info("[cert]:parse datetime 2999-12-31 error", (Object)e);
            }
            perffileUpdate.set("archivesstatus", (Object)"2");
            try (TXHandle txhandle = TX.required();){
                PERFFILE_CHANGE_ENTITY_SERVICE.saveOne(perffileChange);
                PERFFILE_ENTITY_SERVICE.saveHis(new DynamicObject[]{perffileUpdate});
            }
        }
    }

    private void cancelChangeOnQuit(Long empId) {
        DynamicObject[] dys = PERFFILE_CHANGE_ENTITY_SERVICE.queryChangeByEmpId(empId);
        if (dys.length > 0) {
            for (DynamicObject dy : dys) {
                dy.set("processstatus", (Object)"3");
            }
            PERFFILE_CHANGE_ENTITY_SERVICE.save(dys);
        }
    }

    private void cancelChangeOnTrans(Long depEmpId) {
        DynamicObject[] dys = PERFFILE_CHANGE_ENTITY_SERVICE.queryChangeByDepEmpId(depEmpId);
        if (dys.length > 0) {
            for (DynamicObject dy : dys) {
                dy.set("processstatus", (Object)"3");
            }
            PERFFILE_CHANGE_ENTITY_SERVICE.save(dys);
        }
    }

    public void updateProcessStatus(List<Long> changeIds, String processstatus) {
        DynamicObject[] changeDyns;
        for (DynamicObject changeDyn : changeDyns = PERFFILE_CHANGE_ENTITY_SERVICE.queryChangeByIds(changeIds)) {
            changeDyn.set("processstatus", (Object)processstatus);
        }
        PERFFILE_CHANGE_ENTITY_SERVICE.save(changeDyns);
    }
}

