/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.business.domain.perffile.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.opmc.pmd.business.ServiceFactory;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;

public class PerffileDomainService {
    private static final Log LOG = LogFactory.getLog(PerffileDomainService.class);
    private static final PerffileEntityService PERFFILE_ENTITY_SERVICE = PerffileEntityService.getInstance();

    public static PerffileDomainService getInstance() {
        return ServiceFactory.getService(PerffileDomainService.class);
    }

    public DynamicObject generateEmpty() {
        return PERFFILE_ENTITY_SERVICE.generateEmptyDynamicObject();
    }

    public List<Long> getExistenceDepempIds() {
        DynamicObject[] dynamicObjects = PERFFILE_ENTITY_SERVICE.getExistence();
        List<Long> longList = Arrays.stream(dynamicObjects).map(dyn -> dyn.getLong("depemp.id")).collect(Collectors.toList());
        return longList;
    }

    public DynamicObject[] getPerffileListByIds(String selectFields, List<Long> ids) {
        return PERFFILE_ENTITY_SERVICE.getPerffileListByIds(selectFields, ids);
    }

    public DynamicObject[] loadDynamicObjectArray(List<Long> ids) {
        return PERFFILE_ENTITY_SERVICE.loadDynamicObjectArray(ids.toArray(new Long[0]));
    }

    public DynamicObject[] loadDynamicObjectArray(Object[] ids) {
        return PERFFILE_ENTITY_SERVICE.loadDynamicObjectArray(ids);
    }

    public boolean isExists(QFilter[] filters) {
        return PERFFILE_ENTITY_SERVICE.isExists(filters);
    }

    public boolean isExists(QFilter filter) {
        return PERFFILE_ENTITY_SERVICE.isExists(filter);
    }

    public DynamicObject[] query(String selectFields, QFilter[] filters) {
        return PERFFILE_ENTITY_SERVICE.query(selectFields, filters);
    }

    public Object[] save(DynamicObjectCollection colls) {
        return PERFFILE_ENTITY_SERVICE.save(colls);
    }

    public void abandonPerffile(ArrayList<Long> idList) {
        QFilter qIdFilter = new QFilter("boid", "in", idList);
        DynamicObject[] perfFileDyobjs = PERFFILE_ENTITY_SERVICE.query("billstatus, modifier, modifytime", new QFilter[]{qIdFilter});
        Date currTime = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject perfFileDyobj : perfFileDyobjs) {
            perfFileDyobj.set("billstatus", (Object)"D");
            perfFileDyobj.set("modifier", (Object)userId);
            perfFileDyobj.set("modifytime", (Object)currTime);
        }
        PERFFILE_ENTITY_SERVICE.update(perfFileDyobjs);
    }

    public void deletePerffile(ArrayList<Long> idList) {
        QFilter qIdFilter = new QFilter("boid", "in", idList);
        PERFFILE_ENTITY_SERVICE.deleteByFilter(new QFilter[]{qIdFilter});
    }
}

