/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.business.domain.potmember.entityservice;

import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.pmd.business.ServiceFactory;

public class PotMemberEntityService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pmd_potmember");

    public static PotMemberEntityService getInstance() {
        return ServiceFactory.getService(PotMemberEntityService.class);
    }

    public DynamicObject generateEmpty() {
        return HELPER.generateEmptyDynamicObject();
    }

    public DynamicObject getPotMember(Long dutyPersonId) {
        return HELPER.queryOne("person", new QFilter[]{new QFilter("id", "in", (Object)dutyPersonId)});
    }

    public DynamicObject getPotMemberByUser(Long userId) {
        return HELPER.queryOne("id, person, pot", new QFilter[]{new QFilter("user", "in", (Object)userId)}, "id asc");
    }

    public DynamicObject[] getPotMemberByCurrentUser() {
        long userId = RequestContext.get().getCurrUserId();
        return HELPER.queryOriginalArray("id, pot", new QFilter[]{new QFilter("user", "=", (Object)userId)});
    }

    public boolean isPotMemberOfCurrentUser() {
        long userId = RequestContext.get().getCurrUserId();
        return HELPER.isExists(new QFilter("user", "=", (Object)userId));
    }

    public DynamicObject[] getTeamMembers(Set<Long> potIds) {
        return HELPER.query(new QFilter[]{new QFilter("pot", "in", potIds)});
    }
}

