/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.business.file;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.opmc.pbs.business.license.PBSCertCommonHelper;
import kd.opmc.pmd.common.utils.PMDDateTimeUtils;
import org.apache.commons.collections.ListUtils;

public class PersonCertCommonHelper {
    private static final Log LOGGER = LogFactory.getLog(PersonCertCommonHelper.class);
    private static final String APPID = "24E/XB8SQUZU";

    public static Map<String, Object> verifyCertForApply(List<Long> personIndexIds) {
        return PBSCertCommonHelper.verifyCertByPid((String)APPID, (String)"pmd_perffile", personIndexIds);
    }

    public static Map<String, Object> verifyCert(List<DynamicObject> files) {
        HashSet<Long> successList = new HashSet<Long>(16);
        HashSet failList = new HashSet(16);
        HashSet<Long> requireList = new HashSet<Long>(16);
        for (DynamicObject file : files) {
            Long pid = file.getLong("person.personindexid");
            if (PersonCertCommonHelper.isRequireCert(file)) {
                requireList.add(pid);
                continue;
            }
            successList.add(pid);
        }
        if (requireList.size() == 0) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("MSG", HRCertCommonHelper.verifyCertCount((String)APPID, (String)"pmd_perffile"));
            return result;
        }
        Map<String, Object> resultUsable = PersonCertCommonHelper.verifyCertForApply(new ArrayList<Long>(requireList));
        boolean result = (Boolean)resultUsable.get("result");
        if (result) {
            successList.addAll(requireList);
        } else {
            List noCerts = (List)resultUsable.get("NEXISTID");
            if (failList != null && noCerts != null) {
                failList.addAll(noCerts);
            }
            List hsaDetail = ListUtils.removeAll(requireList, (Collection)noCerts);
            successList.addAll(hsaDetail);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("successList", successList);
        resultMap.put("failList", failList);
        Map checkCountMap = (Map)resultUsable.get("DATA");
        resultMap.put("message", checkCountMap.get("message"));
        resultMap.put("MSG", HRCertCommonHelper.verifyCertCount((String)APPID, (String)"pmd_perffile"));
        return resultMap;
    }

    private static boolean isRequireCert(DynamicObject perfFile) {
        boolean isRequire = false;
        Date bsled = perfFile.getDate("bsled");
        try {
            if (bsled == null) {
                bsled = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
            }
        }
        catch (ParseException e) {
            LOGGER.info("[cert]:parse datetime 2999-12-31 error", (Object)e);
        }
        Date today = PMDDateTimeUtils.getTodayDateWithoutTime();
        String status = perfFile.getString("billstatus");
        return "1".equals(perfFile.getString("archivesstatus")) && !bsled.before(today);
    }

    public static void calPersonCertByPersonId(List<Long> personIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("pmd_perffile");
        QFilter idFilter = new QFilter("person.id", "in", personIds);
        idFilter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        DynamicObject[] fileDys = serviceHelper.query("person.personindexid", new QFilter[]{idFilter});
        List<Long> pIds = Arrays.stream(fileDys).map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toList());
        PersonCertCommonHelper.calPersonCertByIndexId(pIds);
    }

    public static void calPersonCertByIndexId(List<Long> personIndexIds) {
        List releaseDelIds;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("pmd_perffile");
        QFilter pIdFilter = new QFilter("person.personindexid", "in", personIndexIds);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter isVersionFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter archiveFilter = new QFilter("archivesstatus", "=", (Object)"1");
        QFilter[] params = new QFilter[]{pIdFilter, statusFilter, isVersionFilter, archiveFilter};
        DynamicObject[] fileDys = serviceHelper.query("person.personindexid", params);
        Set requireCertIds = Arrays.stream(fileDys).map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toSet());
        if (requireCertIds.size() > 0) {
            PBSCertCommonHelper.updateUsedCertCount((String)APPID, (String)"pmd_perffile", new ArrayList(requireCertIds));
        }
        if ((releaseDelIds = ListUtils.removeAll(personIndexIds, requireCertIds)).size() > 0) {
            PBSCertCommonHelper.releaseCertByPersonId((String)APPID, (String)"pmd_perffile", (List)releaseDelIds);
        }
    }

    public static void showWarningTip(IFormView showView, String preMsg, List<DynamicObject> dys) {
        Map<String, Object> resultUsable = PersonCertCommonHelper.verifyCert(dys);
        Map checkCountMap = (Map)resultUsable.get("msg");
        String showMessageType = (String)checkCountMap.get("showMessageType");
        if ("false".equals(checkCountMap.get("showMessage"))) {
            showView.showTipNotification(preMsg + (String)checkCountMap.get("message"));
        }
    }

    public static Map verifyCertCount(List files) {
        return PBSCertCommonHelper.prepareVerifyCertCount((String)APPID, (String)"pmd_perffile", (List)files);
    }
}

