/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.business.task;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.pbs.business.external.hrcs.IStrategyService;
import kd.opmc.pbs.business.external.hrpi.IDepempService;
import kd.opmc.pbs.common.utils.ListUtils;
import kd.opmc.pmd.business.ServiceFactory;
import kd.opmc.pmd.business.domain.perffile.service.PerffileDepempDomainService;
import kd.opmc.pmd.business.domain.perffile.service.PerffileDomainService;
import kd.opmc.pmd.common.constants.PerffilePageConstants;

public class PerffileInitTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PerffileInitTask.class);
    private static final PerffileDepempDomainService perffileDepempDomainService = ServiceFactory.getService(PerffileDepempDomainService.class);
    private static final PerffileDomainService PERFFILE_DOMAIN_SERVICE = PerffileDomainService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"PerffileInitTask#&", (int)2, (int)5);
    private static final int MAX_INIT = 1000;
    private static final Semaphore SEMAPHORE = new Semaphore(5);
    private static final LocalMemoryCache LOCALCACHE;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info(MessageFormat.format("=================start init {0}=================", Thread.currentThread().getName()));
        long startTime = System.currentTimeMillis();
        DynamicObject[] dynamicObjects = perffileDepempDomainService.queryDepemp();
        LOG.info(MessageFormat.format("queryDepemp cost:{0} ms", System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        List<Long> depempIds = PERFFILE_DOMAIN_SERVICE.getExistenceDepempIds();
        LOG.info(MessageFormat.format("getExistenceDepempIds cost:{0} ms", System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        List initIds = Arrays.stream(dynamicObjects).map(dys -> dys.getLong("id")).filter(dyc -> depempIds != null && !depempIds.contains(dyc)).collect(Collectors.toList());
        LOG.info(MessageFormat.format("get initIds cost:{0} ms", System.currentTimeMillis() - startTime));
        LOG.info(MessageFormat.format("initIds size:{0}", String.valueOf(initIds.size())));
        startTime = System.currentTimeMillis();
        ListUtils.excute(initIds, (int)1000, this::batchInitPerffile);
        LOG.info(MessageFormat.format("excute cost:{0} ms", System.currentTimeMillis() - startTime));
        LOG.info(MessageFormat.format("=================end init {0}=================", Thread.currentThread().getName()));
    }

    private void batchInitPerffile(List<Long> ids) {
        try {
            LOG.info("==================start batchInitPerffile==================");
            SEMAPHORE.acquire();
            LOG.info("==================acquire semaphore batchInitPerffile==================");
            THREAD_POOL.execute(() -> {
                try {
                    DynamicObject[] dycs;
                    LOG.info(ids.toString());
                    long startTime = System.currentTimeMillis();
                    DynamicObject[] dynamicObjects = perffileDepempDomainService.queryDepempByIds(ids);
                    LOG.info(MessageFormat.format("queryDepempByIds cost:{0} ms", System.currentTimeMillis() - startTime));
                    startTime = System.currentTimeMillis();
                    List dycIds = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                    List resultList = IDepempService.getInstance().listDataEmpOrgrelDys(dycIds);
                    Map<Long, DynamicObject> resultMap = resultList.stream().collect(Collectors.toMap(dyc -> dyc.getLong("depemp.id"), dyc -> dyc, (key, keylast) -> keylast));
                    ArrayList<DynamicObject> batchDyc = new ArrayList<DynamicObject>();
                    this.initData(dynamicObjects, resultMap, batchDyc);
                    LOG.info(MessageFormat.format("initDynamicObject cost:{0} ms", System.currentTimeMillis() - startTime));
                    if (!ObjectUtils.isEmpty(batchDyc)) {
                        CodeRuleServiceHelper.injectNumbers((String)"pmd_perffile", batchDyc);
                    }
                    if (HRObjectUtils.isEmpty((Object)(dycs = batchDyc.toArray(new DynamicObject[0]))) || dycs.length == 0) {
                        return;
                    }
                    HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
                    hisVersionParamBo.setEffImmediately(Boolean.TRUE.booleanValue());
                    hisVersionParamBo.setAtomicTrans(Boolean.TRUE.booleanValue());
                    hisVersionParamBo.setEntityNumber("pmd_perffile_base");
                    hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
                    hisVersionParamBo.setHisDyns(dycs);
                    startTime = System.currentTimeMillis();
                    HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
                    LOG.info(MessageFormat.format("hisVersionChange cost:{0} ms", System.currentTimeMillis() - startTime));
                }
                catch (Exception exception) {
                    LOG.error("==================batchInitPerffile==================", (Throwable)exception);
                }
                finally {
                    SEMAPHORE.release();
                    LOG.info("==================release semaphore batchInitPerffile==================");
                }
            }, RequestContext.get());
        }
        catch (InterruptedException interruptedException) {
            LOG.error("==================batchInitPerffile InterruptedException==================", (Throwable)interruptedException);
        }
    }

    private void initData(DynamicObject[] dynamicObjects, Map<Long, DynamicObject> resultMap, List<DynamicObject> batchDyc) {
        for (DynamicObject dyc : dynamicObjects) {
            DynamicObject dynamicObject = this.initDynamicObject(dyc, resultMap);
            if (dynamicObject == null) continue;
            batchDyc.add(dynamicObject);
        }
    }

    private DynamicObject initDynamicObject(DynamicObject dyc, Map<Long, DynamicObject> depempMap) {
        long startTime = System.currentTimeMillis();
        DynamicObject depemp = depempMap.get(dyc.getLong("id"));
        if (HRObjectUtils.isEmpty((Object)depemp)) {
            return null;
        }
        Long pmdgroup = null;
        if (LOCALCACHE.get(String.valueOf(depemp.get("adminorg_id"))) != null) {
            pmdgroup = (Long)LOCALCACHE.get(String.valueOf(depemp.get("adminorg_id")));
        }
        if (ObjectUtils.isEmpty(pmdgroup) || pmdgroup <= 0L) {
            pmdgroup = IStrategyService.getInstance().getPerfOrgId((Long)depemp.get("adminorg_id"));
        }
        LOG.info(MessageFormat.format("getPerfOrgId cost:{0} ms", System.currentTimeMillis() - startTime));
        if (ObjectUtils.isEmpty((Object)pmdgroup) || pmdgroup <= 0L) {
            return null;
        }
        return this.getDynamicObject(dyc, depemp, pmdgroup);
    }

    private DynamicObject getDynamicObject(DynamicObject dyc, DynamicObject depemp, Long pmdgroup) {
        LOCALCACHE.put(String.valueOf(depemp.get("adminorg_id")), (Object)pmdgroup);
        DynamicObject dynamicObject = PERFFILE_DOMAIN_SERVICE.generateEmpty();
        dynamicObject.set("depemp", (Object)dyc.getLong("id"));
        dynamicObject.set("bsed", (Object)new Date());
        dynamicObject.set("startdate", (Object)new Date());
        try {
            Date maxDate = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
            dynamicObject.set("bsled", (Object)maxDate);
            dynamicObject.set("enddate", (Object)maxDate);
        }
        catch (ParseException e) {
            LOG.error((Throwable)e);
        }
        Object bsed = depemp.get("bsed");
        if (!ObjectUtils.isEmpty((Object)bsed)) {
            dynamicObject.set("bsed", bsed);
            dynamicObject.set("startdate", bsed);
        }
        dynamicObject.set("empposrel", depemp.get("id"));
        dynamicObject.set("pmdorg", (Object)pmdgroup);
        dynamicObject.set("org", (Object)pmdgroup);
        dynamicObject.set("affiliateadminorg", dyc.get("adminorg"));
        dynamicObject.set("person", dyc.get("person"));
        dynamicObject.set("employee", dyc.get("employee"));
        dynamicObject.set("isescrow", (Object)Boolean.FALSE);
        dynamicObject.set("archivesstatus", (Object)"1");
        dynamicObject.set("pmdperson", (Object)PerffilePageConstants.DEFULTE_PMDPERSON);
        dynamicObject.getDynamicObjectCollection("policyentryentity").addNew().set("policy", (Object)PerffilePageConstants.DEFULTE_POLICY);
        dynamicObject.getDynamicObjectCollection("empentryentity").addNew().set("empposorgrel", depemp.get("id"));
        return dynamicObject;
    }

    static {
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(50);
        localConfig.setTimeout(600);
        LOCALCACHE = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("hr_opmc", "perffileInitTask", localConfig);
    }
}

