/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.business.task;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.opmc.pbs.business.external.hrpi.IDepempService;
import kd.opmc.pbs.business.external.hrpi.IEmployeeService;
import kd.opmc.pbs.common.utils.ListUtils;
import kd.opmc.pmd.business.domain.perffile.service.PerffileDomainService;

public class PerffileUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PerffileUpdateTask.class);
    private static final PerffileDomainService PERFFILE_DOMAIN_SERVICE = PerffileDomainService.getInstance();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"PerffileUpdateTask#&", (int)2, (int)5);
    private static final int MAX_Update = 1000;
    private static final Semaphore SEMAPHORE = new Semaphore(5);
    private static final String POSITION_ID = "position_id";
    private static final String EMPLOYEE_DATE = "employedate";
    private static final String POSTYPE_ID = "postype_id";
    private static final String COMPANY_ID = "company_id";
    private static final String ADMINORG = "adminorg_id";
    private static final String JOB_ID = "job_id";
    private static final String STARTDATE = "startdate";
    private static final String EMPLOYEE_ID = "employee_id";
    private static final IEmployeeService EMPLOYEE_SERVICE = IEmployeeService.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info(MessageFormat.format("=================start Update {0}=================", Thread.currentThread().getName()));
        long startTime = System.currentTimeMillis();
        DynamicObject[] dynamicObjects = PERFFILE_DOMAIN_SERVICE.query("person.name,person.number,company.id,postype.id,name,billno,adminorg.id,employedate,position.id,depemp.id,empposrel.id,job.id", new QFilter[]{new QFilter("billstatus", "!=", (Object)"E")});
        LOG.info(MessageFormat.format("queryDepemp cost:{0} ms", System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        List updateIds = Arrays.stream(dynamicObjects).map(data -> data.getLong("id")).collect(Collectors.toList());
        ListUtils.excute(updateIds, (int)1000, this::batchUpdatePerffile);
        LOG.info(MessageFormat.format("excute cost:{0} ms", System.currentTimeMillis() - startTime));
        LOG.info(MessageFormat.format("=================end Update {0}=================", Thread.currentThread().getName()));
    }

    private void batchUpdatePerffile(List<Long> ids) {
        try {
            LOG.info("==================start batchUpdatePerffile==================");
            SEMAPHORE.acquire();
            LOG.info("==================acquire semaphore batchUpdatePerffile==================");
            THREAD_POOL.execute(() -> {
                try {
                    DynamicObject[] dynamicObjects;
                    LOG.info(ids.toString());
                    long startTime = System.currentTimeMillis();
                    DynamicObjectCollection collection = new DynamicObjectCollection();
                    for (DynamicObject dynamicObject : dynamicObjects = PERFFILE_DOMAIN_SERVICE.query("person.name,person.number,company.id,postype.id,name,billno,adminorg.id,employedate,position.id,depemp.id,empposrel.id,job.id", new QFilter[]{new QFilter("billstatus", "!=", (Object)"E"), new QFilter("id", "in", (Object)ids)})) {
                        if (StringUtils.isEmpty((String)dynamicObject.getString("name")) || dynamicObject.getDynamicObject("adminorg") == null || dynamicObject.getDynamicObject("job") == null) {
                            Map stringEmpOrgrelMap = IDepempService.getInstance().getEmpOrgrel(Long.valueOf(dynamicObject.getLong("depemp.id")));
                            dynamicObject.set("adminorg", stringEmpOrgrelMap.get(ADMINORG));
                            if (dynamicObject.getDynamicObject("person") != null) {
                                dynamicObject.set("name", (Object)dynamicObject.getDynamicObject("person").getString("name"));
                                dynamicObject.set("billno", (Object)dynamicObject.getDynamicObject("person").getString("number"));
                            }
                            dynamicObject.set("position", stringEmpOrgrelMap.get(POSITION_ID));
                            dynamicObject.set("empposrel", stringEmpOrgrelMap.get("id"));
                            dynamicObject.set("empposorgrel", stringEmpOrgrelMap.get("id"));
                            Map employee = EMPLOYEE_SERVICE.getEmployee((Long)stringEmpOrgrelMap.get(EMPLOYEE_ID));
                            dynamicObject.set(EMPLOYEE_DATE, (Object)((Date)employee.get(STARTDATE)));
                            dynamicObject.set("postype", stringEmpOrgrelMap.get(POSTYPE_ID));
                            dynamicObject.set("company", stringEmpOrgrelMap.get(COMPANY_ID));
                            dynamicObject.set("job", stringEmpOrgrelMap.get(JOB_ID));
                            collection.add((Object)dynamicObject);
                        }
                        if (collection.size() != 100) continue;
                        PERFFILE_DOMAIN_SERVICE.save(collection);
                        collection = new DynamicObjectCollection();
                    }
                    if (collection.size() > 0) {
                        PERFFILE_DOMAIN_SERVICE.save(collection);
                    }
                }
                catch (Exception exception) {
                    LOG.error("==================batchUpdatePerffile==================", (Throwable)exception);
                }
                finally {
                    SEMAPHORE.release();
                    LOG.info("==================release semaphore batchUpdatePerffile==================");
                }
            }, RequestContext.get());
        }
        catch (InterruptedException interruptedException) {
            LOG.error("==================batchUpdatePerffile InterruptedException==================", (Throwable)interruptedException);
        }
    }
}

