/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pmd.business.file.PersonCertCommonHelper;

public class PersonCertValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(PersonCertValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validatePerfFileImportCert(dataEntities);
    }

    private void validatePerfFileImportCert(ExtendedDataEntity[] dataEntities) {
        Map map;
        ArrayList<DynamicObject> files = new ArrayList<DynamicObject>(dataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            files.add(data);
        }
        Map veryfiResult = PersonCertCommonHelper.verifyCert(files);
        Set failList = (Set)veryfiResult.get("failList");
        String message = (String)veryfiResult.get("message");
        if (failList != null) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                Long pid = dataEntity.getDataEntity().getLong("person.personindexid");
                if (!failList.contains(pid)) continue;
                LOGGER.info("[cert]:validateSalaryfileImportCert cert fail,pid={}", (Object)pid);
                this.addFatalErrorMessage(dataEntity, message);
            }
        }
        if (veryfiResult.get("successList") != null) {
            List list = ((Set)veryfiResult.get("successList")).stream().collect(Collectors.toList());
            veryfiResult = PersonCertCommonHelper.verifyCertCount(list);
            message = (String)((Map)veryfiResult.get("DATA")).get("message");
            if (HRStringUtils.equalsIgnoreCase((String)((String)((Map)veryfiResult.get("DATA")).get("infoType")), (String)"FORBIDDEN") && list != null) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Long pid = dataEntity.getDataEntity().getLong("person.personindexid");
                    if (!list.contains(pid)) continue;
                    LOGGER.info("[cert]:validateSalaryfileImportCert cert fail,pid={}", (Object)pid);
                    this.addFatalErrorMessage(dataEntity, "error" + message);
                }
            }
        }
        Map map2 = map = (Map)veryfiResult.get("DATA") != null ? (Map)veryfiResult.get("DATA") : (Map)veryfiResult.get("MSG");
        if ("true".equals(map.get("showMessage"))) {
            this.getOption().setVariableValue("showWarningTip", (String)map.get("message"));
        }
    }
}

