/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.opplugin.web;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.pmd.business.file.PersonCertCommonHelper;
import kd.opmc.pmd.opplugin.validator.PersonCertValidator;

public class PerfFileChangeOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PerfFileChangeOp.class);
    private static final HRBaseServiceHelper PEFFILE_HELPER = new HRBaseServiceHelper("pmd_perffile");

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("person.personindexid");
        fieldKeys.add("person.name");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PersonCertValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject dataEntity = e.getDataEntities()[0];
        dataEntity.set("startdate", (Object)dataEntity.getDate("bsed"));
        dataEntity.set("enddate", (Object)dataEntity.getDate("bsled"));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] perffiles;
        this.dataEntities = e.getDataEntities();
        DynamicObject perffile = this.dataEntities[0];
        QFilter boIdFilter = new QFilter("boid", "=", (Object)perffile.getLong("boid"));
        for (DynamicObject newperffile : perffiles = PEFFILE_HELPER.query("id,startdate,enddate,bsed,bsled", new QFilter[]{boIdFilter})) {
            newperffile.set("startdate", (Object)newperffile.getDate("bsed"));
            newperffile.set("enddate", (Object)newperffile.getDate("bsled"));
        }
        PEFFILE_HELPER.updateDatas(perffiles);
        List pIds = Arrays.stream(this.dataEntities).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        PersonCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String showWarningTip = this.getOption().getVariableValue("showWarningTip", null);
        if (showWarningTip != null) {
            this.getOperationResult().setMessage(showWarningTip + "filecertwarn");
            this.getOperationResult().setShowMessage(true);
        }
    }
}

