/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.opplugin.web;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.pmd.business.application.service.PerffileChangeApplicationService;

public class PerffileChangeSaveOp
extends HRDataBaseOp {
    private static final PerffileChangeApplicationService PERFFILE_CHANGE_APP_SERVICE = PerffileChangeApplicationService.getInstance();
    private static final HRBaseServiceHelper PEFFILE_HELPER = new HRBaseServiceHelper("pmd_perffile");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject dynamicObject = args.getDataEntities()[0];
        if ("0".equals(dynamicObject.getString("chgmode"))) {
            dynamicObject.set("org", dynamicObject.get("perforga"));
        }
        dynamicObject.set("processstatus", (Object)"2");
        PERFFILE_CHANGE_APP_SERVICE.processPerffileChange(dynamicObject);
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    boolean exist;
                    DynamicObject data = dataEntity.getDataEntity();
                    DynamicObject oldChange = PERFFILE_CHANGE_APP_SERVICE.loadSingle((Long)data.getPkValue());
                    if (!"0".equals(oldChange.getString("chgmode")) || !(exist = PERFFILE_CHANGE_APP_SERVICE.isExistPerffileByEmpposIdPerOrgId(Long.valueOf(data.getDynamicObject("empposrela").getLong("id")), Long.valueOf(data.getDynamicObject("perforga").getLong("id"))))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u4efb\u804c\u7684\u6863\u6848\u3002", (String)"PerffileChangeSaveOp_0", (String)"opmc-pmd-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] perffiles;
        QFilter billstatusFilter;
        QFilter empposrelFilter;
        QFilter pmdorgFilter;
        QFilter depempbFilter;
        DynamicObject perffileChange = e.getDataEntities()[0];
        if ("0".equals(perffileChange.getString("chgmode"))) {
            depempbFilter = new QFilter("depemp.id", "=", (Object)perffileChange.getLong("depempa.id"));
            pmdorgFilter = new QFilter("pmdorg.id", "=", (Object)perffileChange.getLong("perforga.id"));
            empposrelFilter = new QFilter("empposrel.id", "=", (Object)perffileChange.getLong("empposrela.id"));
            billstatusFilter = new QFilter("billstatus", "!=", (Object)"D");
            perffiles = PEFFILE_HELPER.query("id,startdate,enddate,bsed,bsled", new QFilter[]{depempbFilter, pmdorgFilter, empposrelFilter, billstatusFilter});
        } else {
            depempbFilter = new QFilter("depemp.id", "=", (Object)perffileChange.getLong("depempb.id"));
            pmdorgFilter = new QFilter("pmdorg.id", "=", (Object)perffileChange.getLong("perforgb.id"));
            empposrelFilter = new QFilter("empposrel.id", "=", (Object)perffileChange.getLong("empposrelb.id"));
            billstatusFilter = new QFilter("billstatus", "!=", (Object)"D");
            perffiles = PEFFILE_HELPER.query("id,startdate,enddate,bsed,bsled", new QFilter[]{depempbFilter, pmdorgFilter, empposrelFilter, billstatusFilter});
        }
        for (DynamicObject newperffile : perffiles) {
            newperffile.set("startdate", (Object)newperffile.getDate("bsed"));
            newperffile.set("enddate", (Object)newperffile.getDate("bsled"));
        }
        PEFFILE_HELPER.updateDatas(perffiles);
    }
}

