/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.opplugin.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.pmd.business.application.service.PerffileApplicationService;
import kd.opmc.pmd.business.application.service.evaluobject.PerfFileEvaluObjectApplicationService;
import kd.opmc.pmd.business.file.PersonCertCommonHelper;

public class PerffileInvalidOp
extends HRDataBaseOp {
    private static final PerfFileEvaluObjectApplicationService perfFileEvaluObjectApplicationService = PerfFileEvaluObjectApplicationService.getInstance();
    private static final PerffileApplicationService perffileApplicationService = PerffileApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bsled");
        fieldKeys.add("person");
        fieldKeys.add("archivesstatus");
        fieldKeys.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List ids = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
                DynamicObject[] evaObjects = perfFileEvaluObjectApplicationService.getActEvalObjByFileIds(ids);
                Map map = Arrays.stream(evaObjects).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("perffile.id"), Function.identity(), (key1, key2) -> key2));
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    if (map.get(dataEntity2.getDataEntity().getString("id")) == null) continue;
                    this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u6863\u6848\u5df2\u53c2\u4e0e\u7ee9\u6548\u8003\u6838\u6d3b\u52a8\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"PerffileInvalidOp_0", (String)"opmc-pmd-opplugin", (Object[])new Object[]{dataEntity2.getDataEntity().getString("number")}));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] selectedRows = args.getDataEntities();
        if (selectedRows != null) {
            ArrayList<Long> idDelList = new ArrayList<Long>(16);
            ArrayList<Long> idAbandonList = new ArrayList<Long>(16);
            ArrayList<Long> abandonPidList = new ArrayList<Long>(16);
            for (DynamicObject selectedRow : selectedRows) {
                if ("A".equals(selectedRow.getString("billstatus"))) {
                    idDelList.add(selectedRow.getLong("id"));
                    continue;
                }
                idAbandonList.add(selectedRow.getLong("id"));
                abandonPidList.add(selectedRow.getLong("person.id"));
            }
            if (!idDelList.isEmpty()) {
                perffileApplicationService.deleteSalaryfile(idDelList);
            }
            if (!idAbandonList.isEmpty()) {
                perffileApplicationService.abandonPerffile(idAbandonList);
                PersonCertCommonHelper.calPersonCertByPersonId(abandonPidList);
            }
        }
    }
}

