/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.opplugin.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.opmc.pmd.business.application.service.PerffileApplicationService;
import kd.opmc.pmd.business.domain.perffile.service.PerffileDomainService;
import kd.opmc.pmd.business.file.PersonCertCommonHelper;
import kd.opmc.pmd.opplugin.validator.PersonCertValidator;

public class PerffileListAuditOp
extends AbstractOperationServicePlugIn {
    private static final PerffileApplicationService perffileApplicationService = PerffileApplicationService.getInstance();
    private static final PerffileDomainService perffileDomainService = PerffileDomainService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bsled");
        fieldKeys.add("person");
        fieldKeys.add("archivesstatus");
        fieldKeys.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new PersonCertValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] perfflies;
        Object[] selectedRows = args.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])selectedRows)) {
            return;
        }
        List fileIds = Arrays.stream(selectedRows).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFilter boIdFilter = new QFilter("boid", "in", fileIds);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)"C");
        QFilter versionFilter = new QFilter("iscurrentversion", "!=", (Object)"1");
        for (DynamicObject perffile : perfflies = perffileDomainService.query("billstatus", new QFilter[]{boIdFilter, statusFilter, versionFilter})) {
            perffile.set("billstatus", (Object)"C");
        }
        DynamicObjectCollection fileDyns = new DynamicObjectCollection();
        fileDyns.addAll((Collection)Arrays.stream(perfflies).collect(Collectors.toList()));
        perffileDomainService.save(fileDyns);
        List pIds = Arrays.stream(selectedRows).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        PersonCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String showWarningTip = this.getOption().getVariableValue("showWarningTip", null);
        String preMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"PerffileListAuditOp_0", (String)"opmc-pmd-opplugin", (Object[])new Object[0]);
        if (showWarningTip != null) {
            this.getOperationResult().setMessage(showWarningTip + "filecertwarn");
        }
        this.getOperationResult().setShowMessage(true);
    }
}

