/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.opplugin.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.pmd.business.file.PersonCertCommonHelper;

public class PerffileModifySaveOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper PEFFILE_HELPER = new HRBaseServiceHelper("pmd_perffile");
    private static final HRBaseServiceHelper MODIFY_HELPER = new HRBaseServiceHelper("pmd_perffilemodify");
    private static final Log LOG = LogFactory.getLog(PerffileModifySaveOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] perffiles;
        DynamicObject dynamicObject = args.getDataEntities()[0];
        int newarchivesstatus = dynamicObject.getInt("newarchivesstatus");
        DynamicObject perffile = dynamicObject.getDynamicObject("pmdfile");
        QFilter boIdFilter = new QFilter("boid", "=", (Object)perffile.getLong("boid"));
        QFilter bsledFilter = new QFilter("bsled", ">", (Object)new Date());
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)"1");
        for (DynamicObject newperffile : perffiles = PEFFILE_HELPER.query("id,archivesstatus,modifytime", new QFilter[]{boIdFilter, bsledFilter, datastatusFilter})) {
            newperffile.set("archivesstatus", (Object)newarchivesstatus);
            newperffile.set("modifytime", (Object)new Date());
        }
        try (TXHandle txHandle = TX.required();){
            try {
                PEFFILE_HELPER.updateDatas(perffiles);
                MODIFY_HELPER.saveOne(dynamicObject);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
                txHandle.markRollback();
                throw ex;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                ArrayList<DynamicObject> files = new ArrayList<DynamicObject>(dataEntities.length);
                for (ExtendedDataEntity changeData : dataEntities) {
                    Map checkCountMap;
                    Map veryfiResult;
                    DynamicObject data = changeData.getDataEntity();
                    DynamicObject file = PEFFILE_HELPER.queryOne((Object)data.getLong("pmdfile.id"));
                    file.set("archivesstatus", (Object)data.getString("newarchivesstatus"));
                    files.add(file);
                    if (!HRStringUtils.equals((String)data.getString("newarchivesstatus"), (String)"1") || (veryfiResult = PersonCertCommonHelper.verifyCert(files)).size() <= 0) continue;
                    Set failList = (Set)veryfiResult.get("failList");
                    String message = (String)veryfiResult.get("message");
                    if (failList != null) {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            Long pid = dataEntity.getDataEntity().getLong("person.personindexid");
                            if (!failList.contains(pid)) continue;
                            LOG.info("[cert]:validateSalaryfileImportCert cert fail,pid={}", (Object)pid);
                            this.addFatalErrorMessage(dataEntity, message);
                        }
                    }
                    if (veryfiResult.get("successList") != null) {
                        List successList = ((Set)veryfiResult.get("successList")).stream().collect(Collectors.toList());
                        veryfiResult = PersonCertCommonHelper.verifyCertCount(successList);
                        message = (String)((Map)veryfiResult.get("DATA")).get("message");
                        if (HRStringUtils.equalsIgnoreCase((String)((String)((Map)veryfiResult.get("DATA")).get("infoType")), (String)"FORBIDDEN") && successList != null) {
                            for (ExtendedDataEntity dataEntity : dataEntities) {
                                Long pid = dataEntity.getDataEntity().getLong("person.personindexid");
                                if (!successList.contains(pid)) continue;
                                LOG.info("[cert]:validateSalaryfileImportCert cert fail,pid={}", (Object)pid);
                                this.addFatalErrorMessage(dataEntity, message);
                            }
                        }
                    }
                    Map map = checkCountMap = (Map)veryfiResult.get("MSG") != null ? (Map)veryfiResult.get("MSG") : (Map)veryfiResult.get("DATA");
                    if (!"true".equals(checkCountMap.get("showMessage"))) continue;
                    this.getOption().setVariableValue("showWarningTip", (String)checkCountMap.get("message"));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        Object[] perfModifys = args.getDataEntities();
        String showWarningTip = this.getOption().getVariableValue("showWarningTip", null);
        if (showWarningTip != null) {
            this.getOperationResult().setMessage(showWarningTip + "filecertwarn");
            this.getOperationResult().setShowMessage(true);
        }
        if (ArrayUtils.isEmpty((Object[])perfModifys)) {
            return;
        }
        List pIds = Arrays.stream(perfModifys).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        PersonCertCommonHelper.calPersonCertByPersonId(pIds);
    }
}

