/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.opplugin.web;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.pbs.business.external.hrpi.IDepempService;
import kd.opmc.pbs.common.utils.OpmcDateUtils;
import kd.opmc.pmd.business.application.service.PerffileApplicationService;

public class PerffileSaveOp
extends HRDataBaseOp {
    private static final String STARTDATE = "startdate";
    private static final PerffileApplicationService perffileApplicationService = PerffileApplicationService.getInstance();
    private static Log log = LogFactory.getLog(PerffileSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    if (HRObjectUtils.isEmpty((Object)dataEntity.getDataEntity().getDynamicObject("depemp"))) continue;
                    Map stringEmpOrgrelMap = IDepempService.getInstance().getEmpOrgrel(Long.valueOf(dataEntity.getDataEntity().getDynamicObject("depemp").getLong("id")));
                    DynamicObject data = dataEntity.getDataEntity();
                    if (!ObjectUtils.isEmpty((Object)data.getDate(PerffileSaveOp.STARTDATE)) && !ObjectUtils.isEmpty(stringEmpOrgrelMap.get(PerffileSaveOp.STARTDATE)) && HRDateTimeUtils.dayBefore((Date)data.getDate(PerffileSaveOp.STARTDATE), (Date)((Date)stringEmpOrgrelMap.get(PerffileSaveOp.STARTDATE)))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6863\u6848\u751f\u6548\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u201c\u5de5\u4f5c\u7ecf\u5386\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"PerffileSaveOp_0", (String)"opmc-pmd-opplugin", (Object[])new Object[0]));
                    }
                    QFilter qFilter = new QFilter("depemp.id", "=", (Object)data.getLong("depemp.id"));
                    qFilter.and(new QFilter("pmdorg.id", "=", (Object)data.getLong("pmdorg.id")));
                    qFilter.and(new QFilter("billstatus", "!=", (Object)"D"));
                    qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
                    qFilter.and(new QFilter("pmdorg", "=", (Object)data.getLong("pmdorg.id")));
                    if (Long.compare(data.getLong("id"), 0L) != 0) continue;
                    qFilter.and(new QFilter("id", "!=", (Object)data.getLong("id")));
                    if (!perffileApplicationService.isExists(qFilter)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7ee9\u6548\u7ba1\u7406\u7ec4\u7ec7\u5df2\u5b58\u5728\u8be5\u4eba\u5458\u6863\u6848\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u521b\u5efa\u3002", (String)"PerffileSaveOp_1", (String)"opmc-pmd-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject dataEntity = e.getDataEntities()[0];
        dataEntity.set("bsed", (Object)dataEntity.getDate(STARTDATE));
        if (dataEntity.get("enddate") == null) {
            dataEntity.set("enddate", (Object)OpmcDateUtils.getDefaultBsled());
        }
    }
}

