/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.formplugin.web.exportinitdata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.openservicehelper.permission.HRPermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportDataHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.common.utils.ListUtils;
import kd.opmc.pmd.business.application.service.exportinitdata.ExportInItDataApplicationService;

public class ExportInitDataPlugin
extends AbstractFormPlugin {
    private static final ExportInItDataApplicationService EXPORT_INIT_DATA_APPLICATION_SERVICE = ExportInItDataApplicationService.getInstance();
    private static final Log LOG = LogFactory.getLog(ExportInitDataPlugin.class);
    private static final int MAX_INIT = 60000;

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("exportinitdata".equals(operateKey)) {
            try {
                Map<String, String> exportData;
                Set authorizedAdminOrgIdSet;
                AuthorizedOrgResultWithSub authorizedAdminOrgsWithSub = HRPermissionServiceHelper.getAuthorizedAdminOrgsWithSub((Long)RequestContext.get().getCurrUserId(), (String)"24E05ECYZ6K0", (String)"pmd_perffile", (String)"47150e89000000ac", (String)"affiliateadminorg");
                LOG.info("====AuthorizedOrgResultWithSub: {}", (Object)authorizedAdminOrgsWithSub);
                if (!authorizedAdminOrgsWithSub.isHasAllOrgPerm() && (authorizedAdminOrgIdSet = authorizedAdminOrgsWithSub.getHasPermOrgsWithSub().stream().map(OrgSubInfo::getOrgId).collect(Collectors.toSet())).isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u7ee9\u6548\u6863\u6848\u6570\u636e\u6743\u9650\u3002", (String)"ExportInitDataPlugin_11", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                    return;
                }
                DataSet rows = EXPORT_INIT_DATA_APPLICATION_SERVICE.queryData();
                if (rows.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u521b\u5efa\u6863\u6848\u6570\u636e\u3002", (String)"ExportInitDataPlugin_12", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                    rows.close();
                    return;
                }
                ArrayList<Map<String, String>> exportDataList = new ArrayList<Map<String, String>>(16);
                ArrayList<Long> buIds = new ArrayList<Long>(16);
                for (Row row : rows) {
                    exportData = new HashMap<String, String>(16);
                    exportData.put("id", row.getString("id"));
                    exportData.put("empnumber", row.getString("empnumber"));
                    exportData.put("ermname", row.getString("ermname"));
                    exportData.put("dempid", row.getString("dempid"));
                    exportData.put("orgnumber", row.getString("orgnumber"));
                    exportData.put("orgname", row.getString("orgname"));
                    exportData.put("posinumber", row.getString("posinumber"));
                    exportData.put("posiname", row.getString("posiname"));
                    exportData.put("perfgroupid", "1090_S");
                    exportData.put("buid", (String)((Object)row.getLong("buid")));
                    exportDataList.add(exportData);
                    buIds.add(row.getLong("buid"));
                }
                rows.close();
                Map orgNumber = EXPORT_INIT_DATA_APPLICATION_SERVICE.queryOrgNumber(buIds);
                Iterator iterator = exportDataList.iterator();
                while (iterator.hasNext()) {
                    exportData.put("buid", orgNumber.get((Long)(exportData = (Map)iterator.next()).get("buid")) == null ? "" : orgNumber.get((Long)exportData.get("buid")));
                }
                ListUtils.excute(exportDataList, (int)60000, this::makeExcel);
            }
            catch (Exception exception) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExportInitDataPlugin_13", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                LOG.error((Throwable)exception);
            }
        }
    }

    private void makeExcel(List<Map<String, Object>> exportDataList) {
        String excelName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_\u7ee9\u6548\u6863\u6848\u5bfc\u5165\u6570\u636e_{0}", (String)"ExportInitDataPlugin_0", (String)"opmc-pmd-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List<HRExportHeadObject> headDataList = this.getExportHead();
        try {
            String exportUrl = HRExportDataHelper.getExportExcelUrl((String)excelName, exportDataList, headDataList);
            if (!HRStringUtils.isEmpty((String)exportUrl)) {
                DisposableUrlParam param = new DisposableUrlParam();
                param.setEntityNum(this.getView().getEntityId());
                param.setPath(UrlService.getDomainContextUrl() + "/" + exportUrl);
                param.setPermItem("4730fc9f000004ae");
                param.setPkId((Object)0L);
                String attachUrl = AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)param);
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                clientViewProxy.addAction("download", (Object)attachUrl);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private List<HRExportHeadObject> getExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("id", ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386ID", (String)"ExportInitDataPlugin_1", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("empnumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"ExportInitDataPlugin_2", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("ermname", ResManager.loadKDString((String)"\u59d3\u540d", (String)"ExportInitDataPlugin_3", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("dempid", ResManager.loadKDString((String)"\u7ec4\u7ec7\u4eba\u7684\u884c\u653f\u7ec4\u7ec7ID", (String)"ExportInitDataPlugin_4", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("orgnumber", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801", (String)"ExportInitDataPlugin_5", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("orgname", ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u540d\u79f0", (String)"ExportInitDataPlugin_6", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("posinumber", ResManager.loadKDString((String)"\u5c97\u4f4d\u7f16\u7801", (String)"ExportInitDataPlugin_7", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("posiname", ResManager.loadKDString((String)"\u5c97\u4f4d\u540d\u79f0", (String)"ExportInitDataPlugin_8", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("buid", ResManager.loadKDString((String)"\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7.\u7f16\u7801", (String)"ExportInitDataPlugin_9", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("perfgroupid", ResManager.loadKDString((String)"\u7ee9\u6548\u4eba\u5458\u7ec4\u7f16\u7801", (String)"ExportInitDataPlugin_10", (String)"opmc-pmd-formplugin", (Object[])new Object[0])));
        return headDataList;
    }
}

