/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.formplugin.web.objective;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.application.service.pot.PotMemberApplicationService;

public class ObjectiveTreeListPlugin
extends StandardTreeListPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener {
    private static final PotMemberApplicationService POT_MEMBER_SERVICE = PotMemberApplicationService.getInstance();

    public void setTreeListView(ITreeListView treeListView) {
        super.setTreeListView(treeListView);
        this.getView().setVisible(Boolean.TRUE, new String[]{"iscontainlower"});
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        TreeView tv1 = (TreeView)this.getView().getControl("treeview");
        tv1.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tv1.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        TreeNode rootNode = this.getTreeModel().getRoot();
        rootNode.setChildren(this.buildTreeNode(rootNode.getId()));
        this.getTreeModel().setRoot(rootNode);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (HRStringUtils.equals((String)"tblrefresh", (String)evt.getItemKey())) {
            this.refreshTreeView(this.getTreeModel().getRoot().getId());
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        super.treeNodeClick(treeNodeEvent);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public void setFilter(SetFilterEvent filterEvent) {
        DynamicObjectCollection potCollection;
        super.setFilter(filterEvent);
        List qFilters = filterEvent.getQFilters();
        if (CollectionUtils.isEmpty((Collection)qFilters)) {
            return;
        }
        for (QFilter qFilter : qFilters) {
            if (!qFilter.getProperty().equals("parent")) continue;
            qFilters.remove(qFilter);
            break;
        }
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
            return;
        }
        ArrayList<Long> potIds = new ArrayList<Long>(10);
        potIds.add(Long.valueOf(currentNodeId));
        Boolean isContainLower = (Boolean)this.getModel().getValue("iscontainlower");
        if (isContainLower.booleanValue() && (potCollection = POT_MEMBER_SERVICE.queryPotByParentId(Long.valueOf(currentNodeId))).size() > 0) {
            potCollection.forEach(pot -> potIds.add((Long)pot.get("Id")));
        }
        qFilters.add(new QFilter("dutyorg", "in", potIds));
    }

    public void search(SearchEnterEvent evt) {
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        String currentNodeId = (String)treeNodeEvent.getNodeId();
        this.refreshTreeView(currentNodeId);
    }

    private void refreshTreeView(String currentNodeId) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        ArrayList childNodes = this.buildTreeNode(currentNodeId);
        TreeNode currentNode = rootNode.getTreeNode(currentNodeId);
        currentNode.setChildren((List)(childNodes.size() > 0 ? childNodes : new ArrayList(10)));
        this.getTreeListView().getTreeView().updateNode(currentNode);
    }

    private List<TreeNode> buildTreeNode(String nodeId) {
        Long parentId = this.getTreeModel().getRoot().getId().equals(nodeId) ? Long.valueOf(0L) : Long.valueOf(nodeId);
        DynamicObjectCollection potCollection = POT_MEMBER_SERVICE.queryPotByParentId(parentId);
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(10);
        if (potCollection.size() > 0) {
            for (DynamicObject pot : potCollection) {
                String id = pot.getString("Id");
                String name = pot.getString("name");
                String enable = pot.getString("enable");
                if (!HRStringUtils.equals((String)"1", (String)enable)) continue;
                TreeNode node = new TreeNode(nodeId, id, name);
                childNodes.add(node);
                node.setChildren(this.buildTreeNode(id));
            }
        }
        return childNodes;
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        Boolean oldValue;
        String fieldKey = changedArgs.getProperty().getName();
        if (!HRStringUtils.equals((String)"iscontainlower", (String)fieldKey)) {
            return;
        }
        Boolean newValue = (Boolean)changedArgs.getChangeSet()[0].getNewValue();
        if (!newValue.equals(oldValue = (Boolean)changedArgs.getChangeSet()[0].getOldValue())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }
}

