/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.formplugin.web.perffile;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class PerffileBillListPlugin
extends HRDataBaseList {
    private static final String DEPEMP_PERSON_NAME = "depemp_person_name";
    private static final String SHOWHISVERSION = "hisversion";
    private static final String HISVERSION_FORMID = "pmd_perffilehislist";
    private static final String AUDIT = "audit";
    private static final String CANCEL = "unsubmit";
    private static final String SUBMIT = "submit";
    private static final String DELETE = "donothing_delete";
    private static final String INVALID = "invalid";
    private static final String TREE_FORMID = "pmd_perffiletreelist";
    private static final Log LOGGER = LogFactory.getLog(PerffileBillListPlugin.class);
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pmd_perffile");
    private static final String NAME = "name";
    private static final String BILLNO = "billno";
    private static final String MODIFY = "modifyarchivesstatus";
    private static final String MDOIFYRECORD = "modifyrecord";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        IFormView formView;
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (NAME.equals(fieldName) && (formView = this.getView()) instanceof IListView) {
            IListView listView = (IListView)formView;
            Long perffileId = (Long)listView.getFocusRowPkId();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("pmd_perffile_detail");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            DynamicObject perfiles = HELPER.queryOne("billstatus", (Object)perffileId);
            if (!"A".equals(perfiles.getString("billstatus"))) {
                showParameter.setStatus(OperationStatus.VIEW);
            } else {
                showParameter.setCustomParam("fromPage", (Object)"revise");
            }
            showParameter.setPkId((Object)perffileId);
            showParameter.setPageId(this.getView().getPageId() + this.getView().getFormShowParameter().getAppId() + this.getFocusRowPkId());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "epa_apphome".equals(parentView.getFormShowParameter().getFormId())) {
            return;
        }
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId());
        if (!result.hasAllOrgPerm()) {
            e.setMainOrgQFilter(new QFilter("pmdorg", "in", (Object)result.getHasPermOrgs()));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "depemp.person.name", "depemp.person.number", "number", NAME, BILLNO);
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (parameter.isLookUp()) {
            IListColumn listColumn = args.getListColumn(NAME);
            listColumn.setHyperlink(false);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public List<QFilter> getQFilters() {
                List qFilters = super.getQFilters();
                for (QFilter qFilter : qFilters) {
                    String property = qFilter.getProperty();
                    if (!property.contains("person")) continue;
                    List nests = qFilter.getNests(true);
                    for (QFilter.QFilterNest nest : nests) {
                        QFilter filter = nest.getFilter();
                        if (!"OR".equals(nest.getOp()) || !QEmptyValue.value.equals(filter.getValue())) continue;
                        LOGGER.info("before clear nest filter string : " + qFilter.toString());
                        nest.remove();
                        LOGGER.info("cleared nest filter string : " + qFilter.toString());
                    }
                }
                return qFilters;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operationKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operationKey = afterDoOperationEventArgs.getOperateKey()) {
            case "hisversion": {
                this.showHisVersionListPage();
                break;
            }
            case "audit": {
                this.postAuditErrInfosProcess(AUDIT, afterDoOperationEventArgs);
                this.buildAuditTips(afterDoOperationEventArgs);
                break;
            }
            case "unsubmit": {
                this.postAuditErrInfosProcess(CANCEL, afterDoOperationEventArgs);
                break;
            }
            case "submit": {
                this.postAuditErrInfosProcess(SUBMIT, afterDoOperationEventArgs);
                break;
            }
            case "donothing_delete": {
                this.postAuditErrInfosProcess(DELETE, afterDoOperationEventArgs);
                IListView listView = (IListView)this.getView();
                listView.clearSelection();
                listView.refresh();
                break;
            }
            case "invalid": {
                this.postAuditErrInfosProcess(INVALID, afterDoOperationEventArgs);
                break;
            }
            case "modifyarchivesstatus": {
                this.modifyArchivesStatus(afterDoOperationEventArgs);
                break;
            }
            case "modifyrecord": {
                this.showModifyRecordListPage();
                break;
            }
        }
    }

    private void buildAuditTips(AfterDoOperationEventArgs eventArgs) {
        OperationResult operationResult = eventArgs.getOperationResult();
        if (operationResult != null) {
            String message;
            ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
            if (!validateResultCollection.isSuccess()) {
                List validateResults = validateResultCollection.getValidateErrors();
                for (ValidateResult reslut : validateResults) {
                    List operateErrorInfos = reslut.getAllErrorInfo();
                    for (int i = 0; i < operateErrorInfos.size(); ++i) {
                        OperateErrorInfo operateErrorInfo = (OperateErrorInfo)operateErrorInfos.get(i);
                        String message2 = operateErrorInfo.getMessage();
                        if (!HRStringUtils.isNotEmpty((String)message2)) continue;
                        operationResult.setShowMessage(true);
                        if (!message2.contains("error")) continue;
                        operateErrorInfos.remove(i);
                        --i;
                        if (operateErrorInfo.getLevel().getValue() == 0) {
                            if (this.getSelectedRows().size() == 1) {
                                operationResult.setShowMessage(false);
                                String preMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\u3002", (String)"PerffileBillListPlugin_0", (String)"opmc-pmd-formplugin", (Object[])new Object[0]);
                                this.getView().showErrorNotification(preMsg);
                            }
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u4e0e\u7ee9\u6548\u7ba1\u7406\u5e94\u7528\u5206\u7ec4\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5df2\u8d85\u51fa\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"PerffileBillListPlugin_1", (String)"opmc-pmd-formplugin", (Object[])new Object[0]), new Object[0]));
                            continue;
                        }
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u4e0e\u7ee9\u6548\u7ba1\u7406\u5e94\u7528\u5206\u7ec4\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5373\u5c06\u8fbe\u5230\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u53ca\u65f6\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"PerffileBillListPlugin_2", (String)"opmc-pmd-formplugin", (Object[])new Object[0]), new Object[0]));
                    }
                    if (operateErrorInfos.size() != 0) continue;
                    operationResult.setShowMessage(false);
                }
            }
            if (HRStringUtils.isNotEmpty((String)(message = operationResult.getMessage())) && message.contains("filecertwarn")) {
                ValidateResultCollection validateResult = eventArgs.getOperationResult().getValidateResult();
                if (validateResult.isSuccess()) {
                    operationResult.setShowMessage(false);
                    String preMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"PerffileBillListPlugin_3", (String)"opmc-pmd-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(preMsg);
                }
                String result = message.replace("filecertwarn", "");
                this.getView().showTipNotification(result);
            }
        }
    }

    private void postAuditErrInfosProcess(String operation, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult().getValidateResult().errorSize() > 0) {
            List errInfos = ((ValidateResult)afterDoOperationEventArgs.getOperationResult().getValidateResult().getValidateErrors().get(0)).getAllErrorInfo();
            Map billNos = afterDoOperationEventArgs.getOperationResult().getBillNos();
            List retErrorInfos = errInfos.stream().map(errorInfo -> {
                String message = errorInfo.getMessage();
                if (HRStringUtils.equals((String)SUBMIT, (String)operation)) {
                    message = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u63d0\u4ea4\u201c\u6682\u5b58\u201d\u72b6\u6001\u7684\u5355\u636e\u3002", (String)"PerffileBillListPlugin_4", (String)"opmc-pmd-formplugin", (Object[])new Object[0]);
                }
                if (errInfos.size() > 1) {
                    if (!message.contains((CharSequence)billNos.get(errorInfo.getPkValue().toString()))) {
                        errorInfo.setMessage((String)billNos.get(errorInfo.getPkValue().toString()) + ":" + message);
                    }
                } else {
                    errorInfo.setMessage(message);
                }
                return errorInfo;
            }).collect(Collectors.toList());
            ((ValidateResult)afterDoOperationEventArgs.getOperationResult().getValidateResult().getValidateErrors().get(0)).setAllErrorInfo(retErrorInfos);
        }
    }

    private void showHisVersionListPage() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("billstatus", "in", (Object)new String[]{"C", "D"}));
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("iscurrentversion", "!=", (Object)"1"));
        showParameter.setBillFormId(HISVERSION_FORMID);
        showParameter.setFormId(TREE_FORMID);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void modifyArchivesStatus(AfterDoOperationEventArgs args) {
        if (this.getSelectedRows().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u529f\u80fd\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"PerffileBillListPlugin_5", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
            return;
        }
        Long perffileId = (Long)this.getSelectedRows().getPrimaryKeyValues()[0];
        DynamicObject perfiles = HELPER.loadSingle((Object)perffileId);
        if (!"C".equals(perfiles.getString("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6863\u6848\u672a\u5ba1\u6838\uff0c\u4e0d\u652f\u6301\u4fee\u8ba2\u8003\u6838\u72b6\u6001\u3002", (String)"PerffileBillListPlugin_6", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("pmd_perffilemodify");
        baseShowParameter.setCustomParam("perffileId", (Object)perffileId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void showModifyRecordListPage() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("pmd_perffilemodify");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

