/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.formplugin.web.perffile;

import java.util.Arrays;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class PerffileHisListPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(PerffileHisListPlugin.class);
    private static final String NAME = "name";
    private static final String BILLNO = "billno";
    private static final String HISVERSION = "hisversion";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        IFormView formView;
        args.setCancel(true);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (NAME.equals(fieldName) && (formView = this.getView()) instanceof IListView) {
            this.openDetailPage((IListView)formView);
        }
    }

    private void openDetailPage(IListView formView) {
        String perffileId = formView.getFocusRowPkId().toString();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("pmd_perffile_detail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("fromPage", (Object)"openVersionPage");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setPkId((Object)perffileId);
        showParameter.setPageId(this.getView().getPageId() + this.getView().getFormShowParameter().getAppId() + this.getFocusRowPkId());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "depemp.person.name", "depemp.person.number", "number", NAME, BILLNO, HISVERSION);
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
        ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (parameter.isLookUp()) {
            IListColumn listColumn = args.getListColumn("person.name");
            listColumn.setHyperlink(false);
        }
    }
}

