/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.formplugin.web.perffile;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class PerffileModifyEditPlugin
extends HRDataBaseEdit {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("pmd_perffile");

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        Long perffileId = (Long)this.getView().getFormShowParameter().getCustomParam("perffileId");
        DynamicObject perffiles = HELPER.loadSingle((Object)perffileId);
        this.initPerffileInfo(perffiles);
    }

    private void initPerffileInfo(DynamicObject perffiles) {
        this.getView().setFormTitle(ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u4fee\u8ba2\u8003\u6838\u72b6\u6001", (String)"PerffileModifyEditPlugin_0", (String)"opmc-pmd-formplugin", (Object[])new Object[0]), (String)"PerffileModifyEditPlugin_0", (String)"opmc-pmd-formplugin"));
        this.getModel().setValue("pmdfile", (Object)perffiles.getLong("id"));
        String archivesstatus = perffiles.getString("archivesstatus");
        this.getModel().setValue("oldarchivesstatus", (Object)archivesstatus);
        this.getModel().setValue("person", (Object)perffiles.getDynamicObject("person").getLong("id"));
        this.getModel().setValue("employee", (Object)perffiles.getDynamicObject("employee").getLong("id"));
        if ("1".equals(archivesstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"normalarchives"});
            this.getModel().setValue("newarchivesstatus", (Object)2);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancelarchives"});
            this.getModel().setValue("newarchivesstatus", (Object)1);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
        if (!validateResultCollection.isSuccess()) {
            OperateErrorInfo operateErrorInfo = (OperateErrorInfo)((ValidateResult)validateResultCollection.getValidateErrors().get(0)).getAllErrorInfo().get(0);
            String message = operateErrorInfo.getMessage();
            if (HRStringUtils.isNotEmpty((String)message)) {
                operationResult.setShowMessage(false);
                if (operateErrorInfo.getLevel().getValue() == 0) {
                    String preMsg = ResManager.loadKDString((String)"\u4fee\u8ba2\u5931\u8d25", (String)"PerffileModifyEditPlugin_1", (String)"opmc-pmd-formplugin", (Object[])new Object[0]);
                    this.getView().getParentView().showErrorNotification(preMsg);
                    this.getView().getParentView().showErrorNotification(message);
                } else {
                    this.getView().getParentView().showTipNotification(message);
                }
            }
        } else {
            String message = operationResult.getMessage();
            if (HRStringUtils.isNotEmpty((String)message) && message.contains("filecertwarn")) {
                String result = message.replace("filecertwarn", "");
                operationResult.setShowMessage(false);
                String preMsg = ResManager.loadKDString((String)"\u4fee\u8ba2\u6210\u529f", (String)"PerffileModifyEditPlugin_2", (String)"opmc-pmd-formplugin", (Object[])new Object[0]);
                this.getView().getParentView().showSuccessNotification(preMsg);
                this.getView().getParentView().showTipNotification(result);
            }
        }
        if ("savemofify".equals(key)) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }
}

