/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.formplugin.web.perffile.perimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.opmc.pmd.common.constants.PerffilePageConstants;

public class PerffileBatchImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(PerffileBatchImportPlugin.class);
    private static final String ROW_NUM = "rowNum";
    private static final String POLICY = "policy";
    private static final String PERSON_NUMBER = "person.number";
    private static final String POLICY_FIELD = "policyfield";
    private static final String IMPORT_PROP = "importprop";

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                FormView formView = (FormView)view.get(ctx);
                formView.setVisible(Boolean.valueOf(false), new String[]{"radiofield1", "radiofield2", "keyfields"});
            }
            catch (IllegalAccessException e) {
                LOGGER.error(e.getMessage());
            }
        }
        catch (NoSuchFieldException e) {
            LOGGER.error(e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected void beforeSave(List<ImportBillData> billDataList, ImportLogger logger) {
        super.beforeSave(billDataList, logger);
        if (CollectionUtils.isEmpty(billDataList)) {
            return;
        }
        billDataList.forEach(billData -> {
            JSONObject policyfieldObj = billData.getData().getJSONObject(POLICY_FIELD);
            JSONArray policyentryentity = new JSONArray();
            billData.getData().put("policyentryentity", (Object)policyentryentity);
            JSONObject policyentryObj = this.requireDefaultPolicy();
            policyentryObj.put(ROW_NUM, billData.getData().get((Object)ROW_NUM));
            if (!CollectionUtils.isEmpty((Map)policyfieldObj)) {
                policyentryObj.put(POLICY, billData.getData().remove((Object)POLICY_FIELD));
            }
            policyentryentity.add((Object)policyentryObj);
        });
    }

    private JSONObject requireDefaultPolicy() {
        JSONObject policyentryObj = new JSONObject();
        JSONObject defaultPolicyObj = new JSONObject();
        defaultPolicyObj.put(IMPORT_PROP, (Object)"id");
        defaultPolicyObj.put("id", (Object)PerffilePageConstants.DEFULTE_POLICY);
        policyentryObj.put(POLICY, (Object)defaultPolicyObj);
        return policyentryObj;
    }
}

