/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.pmd.mservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.pbs.business.external.hrcs.IHRCSMsgService;
import kd.opmc.pmd.business.ServiceFactory;
import kd.opmc.pmd.business.application.service.PerffileChangeApplicationService;
import kd.opmc.pmd.mservice.api.IPersonnelChangePerffileService;
import kd.opmc.pmd.mservice.extpoint.ConsumePersonnelService;
import kd.opmc.pmd.mservice.extpoint.impl.ConsumePersonnelServiceImpl;

public class PersonnelChangePerffileServiceImpl
implements IPersonnelChangePerffileService {
    private static final Log LOG = LogFactory.getLog(PersonnelChangePerffileServiceImpl.class);
    private static final PerffileChangeApplicationService perffileChangeService = (PerffileChangeApplicationService)ServiceFactory.getService(PerffileChangeApplicationService.class);
    private static final IHRCSMsgService IHRCS_MSG_SERVICE = IHRCSMsgService.getInstance();

    public HRMServiceResult consumerSaveMsg(DynamicObject dy) {
        String contentBase64 = dy.getString("msgcontent");
        Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)contentBase64);
        Object recordId = msgContent.get("recordId");
        Object actionId = dy.get("msgaction");
        String msgName = dy.getString("name");
        LOG.info("peronnel change, recordID: {}", recordId);
        if (recordId == null) {
            return HRMServiceResult.fail((String)"recordId is null");
        }
        try {
            ConsumePersonnelServiceImpl consumePersonnelServiceImpl = new ConsumePersonnelServiceImpl();
            HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)consumePersonnelServiceImpl, ConsumePersonnelService.class, (String)"kd.opmc.pmd.mservice.extpoint.ConsumePersonnelService#consumePersonnelChange", (PluginFilter)null);
            proxy.callReplaceIfPresent(p -> {
                p.consumePersonnelChange(msgName, Long.valueOf(actionId.toString()), Long.valueOf(recordId.toString()));
                return null;
            });
            this.updateConsumeMsgInfo(dy, null);
            return HRMServiceResult.success();
        }
        catch (Exception exception) {
            LOG.error("consume personnel change fail", (Throwable)exception);
            this.updateConsumeMsgInfo(dy, String.format("consume personnel change fail; cause  %s; traceId: %s", exception.getMessage(), RequestContext.get().getTraceId()));
            return HRMServiceResult.fail((String)"consume personnel change fail");
        }
    }

    private void updateConsumeMsgInfo(DynamicObject dy, String msg) {
        HashMap<String, Object> consumeMsgMap = new HashMap<String, Object>(16);
        consumeMsgMap.put("msgCenterId", dy.getLong("msgcenterbo"));
        consumeMsgMap.put("msgSubNo", dy.get("msgsubno"));
        consumeMsgMap.put("businessTypeId", dy.getLong("msgbusinesstype"));
        consumeMsgMap.put("handleStatus", HRStringUtils.isEmpty((String)msg) ? "1" : "3");
        consumeMsgMap.put("consumeMsg", msg);
        IHRCS_MSG_SERVICE.updateConsumeMsgInfo(consumeMsgMap);
    }
}

