/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;

public class ChgAuditHelper {
    public void synChgBillData2ChgAuditf7(String appId, DynamicObject chgAuditObj, String operateKey) {
        if ("delete".equals(operateKey)) {
            this.deleteChgAuditF7Data(appId, chgAuditObj);
        } else {
            this.updateChgAuditF7Data(appId, chgAuditObj);
        }
    }

    protected void deleteChgAuditF7Data(String appId, DynamicObject chgAuditObj) {
        DeleteServiceHelper.delete((String)MetaDataUtil.getEntityId((String)appId, (String)"chgaudit_f7"), (QFilter[])new QFilter[]{new QFilter("billid", "=", chgAuditObj.getPkValue())});
    }

    protected void updateChgAuditF7Data(String appId, DynamicObject chgAuditObj) {
        DynamicObject f7Obj;
        String f7EntityId = MetaDataUtil.getEntityId((String)appId, (String)"chgaudit_f7");
        MainEntityType f7Type = EntityMetadataCache.getDataEntityType((String)f7EntityId);
        Map<Long, DynamicObject> oldF7DataMap = this.queryChgAuditF7Data((DynamicObjectType)f7Type, chgAuditObj);
        DynamicObject conObj = chgAuditObj.getDynamicObject("contractbill");
        Long conId = null;
        if (conObj != null) {
            conId = (Long)conObj.getPkValue();
        }
        if (null == (f7Obj = oldF7DataMap.get(conId))) {
            f7Obj = new DynamicObject((DynamicObjectType)f7Type);
            f7Obj.set("id", chgAuditObj.getPkValue());
        } else {
            oldF7DataMap.remove(conId);
        }
        this.setChgAuditF7Data(f7Obj, chgAuditObj, conObj);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{f7Obj});
        this.deleteOldF7Data((DynamicObjectType)f7Type, oldF7DataMap);
    }

    protected Map<Long, DynamicObject> queryChgAuditF7Data(DynamicObjectType f7Type, DynamicObject chgAuditObj) {
        List f7Pks = QueryServiceHelper.queryPrimaryKeys((String)f7Type.getName(), (QFilter[])new QFilter[]{new QFilter("billid", "=", chgAuditObj.getPkValue())}, null, (int)-1);
        if (f7Pks.size() == 0) {
            return Collections.emptyMap();
        }
        DynamicObject[] f7s = BusinessDataServiceHelper.load((Object[])f7Pks.toArray(), (DynamicObjectType)f7Type);
        HashMap<Long, DynamicObject> f7Data = new HashMap<Long, DynamicObject>(f7s.length);
        for (DynamicObject f7Obj : f7s) {
            f7Data.put((Long)f7Obj.getDynamicObject("contractbill").getPkValue(), f7Obj);
        }
        return f7Data;
    }

    protected void setChgAuditF7Data(DynamicObject f7Obj, DynamicObject chgAuditObj, DynamicObject conObj) {
        f7Obj.set("contractbill", (Object)conObj);
        f7Obj.set("billtype", (Object)chgAuditObj.getDynamicObjectType().getName());
        f7Obj.set("billid", chgAuditObj.getPkValue());
        f7Obj.set("number", chgAuditObj.get("billno"));
        f7Obj.set("name", chgAuditObj.get("billname"));
        f7Obj.set("billstatus", chgAuditObj.get("billstatus"));
        f7Obj.set("bizstatus", chgAuditObj.get("bizstatus"));
        f7Obj.set("currency", chgAuditObj.get("currency"));
        f7Obj.set("oricurrency", chgAuditObj.get("oricurrency"));
        f7Obj.set("taxrate", chgAuditObj.get("taxrate"));
        f7Obj.set("applyoriamt", chgAuditObj.get("applyoriamt"));
        f7Obj.set("applyamt", chgAuditObj.get("applyamt"));
        f7Obj.set("oriamt", chgAuditObj.get("oriamt"));
        f7Obj.set("amount", chgAuditObj.get("amount"));
        f7Obj.set("org", chgAuditObj.get("org"));
        f7Obj.set("project", chgAuditObj.get("project"));
        f7Obj.set("refbillstatus", chgAuditObj.get("refbillstatus"));
        f7Obj.set("refbillid", null);
        f7Obj.set("urgentdegree", chgAuditObj.get("urgentdegree"));
        f7Obj.set("changereason", chgAuditObj.get("changereason"));
        f7Obj.set("bizdate", chgAuditObj.get("bizdate"));
        f7Obj.set("handler", chgAuditObj.get("handler"));
        f7Obj.set("creator", chgAuditObj.get("creator"));
        f7Obj.set("createtime", chgAuditObj.get("createtime"));
        DataEntityPropertyCollection properties = chgAuditObj.getDynamicObjectType().getProperties();
        if (null != properties.get((Object)"supplier")) {
            f7Obj.set("supplier", chgAuditObj.get("supplier"));
        }
        if (null != properties.get((Object)"suppliername")) {
            f7Obj.set("suppliername", chgAuditObj.get("suppliername"));
        }
    }

    protected void deleteOldF7Data(DynamicObjectType f7Type, Map<Long, DynamicObject> oldF7DataMap) {
        if (oldF7DataMap.size() == 0) {
            return;
        }
        Object[] pks = new Object[oldF7DataMap.size()];
        int idx = 0;
        for (Map.Entry<Long, DynamicObject> entry : oldF7DataMap.entrySet()) {
            pks[idx++] = entry.getValue().getPkValue();
        }
        DeleteServiceHelper.delete((IDataEntityType)f7Type, (Object[])pks);
    }

    public DynamicObject[] getChgAuditAmountByContract(String appId, long conId, boolean onlyAuditted, Long[] excludeBillIds) {
        if (null == excludeBillIds) {
            excludeBillIds = new Long[]{0L};
        }
        QFilter[] filters = null;
        filters = onlyAuditted ? new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("refbillstatus", "!=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("billid", "not in", (Object)excludeBillIds), new QFilter("contractbill", "=", (Object)conId)} : new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMITTED.getValue(), BillStatusEnum.AUDITTED.getValue()}), new QFilter("refbillstatus", "not in", (Object)new String[]{BillStatusEnum.AUDITTED.getValue()}), new QFilter("billid", "not in", (Object)excludeBillIds), new QFilter("contractbill", "=", (Object)conId)};
        return BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"chgaudit_f7"), (String)this.getSelectColumn(), (QFilter[])filters);
    }

    protected String getSelectColumn() {
        return String.join((CharSequence)",", "refbillstatus", "billstatus", "bizstatus", "oriamt", "amount", "tax");
    }
}

