/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.business.helper.ChgAuditHelper;
import kd.pccs.concs.business.helper.ChgCfmBillHelper;
import kd.pccs.concs.business.helper.SupplyConBillHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;

public class ChgBillHelper {
    public Map<String, BigDecimal> getChgAmtExcSupply(String appId, long conId, boolean onlyAuditted, Long[] excludeBillIds) {
        DynamicObject[] chgAuditColl;
        if (0L == conId) {
            return new HashMap<String, BigDecimal>(2);
        }
        boolean existFlag = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)conId)});
        if (!existFlag) {
            return new HashMap<String, BigDecimal>(2);
        }
        BigDecimal chgOriAmt = null;
        BigDecimal chgAmt = null;
        BigDecimal chgTax = null;
        DynamicObject[] chgCfmColl = new ChgCfmBillHelper().getChgCfmAmountByContract(appId, conId, onlyAuditted, excludeBillIds);
        if (null != chgCfmColl && chgCfmColl.length > 0) {
            for (DynamicObject chgCfmObj : chgCfmColl) {
                BigDecimal oriAmt = chgCfmObj.getBigDecimal("oriamt");
                String billStatus = chgCfmObj.getString("billstatus");
                if (!onlyAuditted && !BillStatusEnum.AUDITTED.getValue().equals(billStatus) && NumberUtil.isNegativeNum((Object)oriAmt)) continue;
                chgOriAmt = NumberUtil.add(chgOriAmt, (Object)chgCfmObj.getBigDecimal("oriamt"));
                chgAmt = NumberUtil.add(chgAmt, (Object)chgCfmObj.getBigDecimal("amount"));
                chgTax = NumberUtil.add(chgTax, (Object)chgCfmObj.getBigDecimal("tax"));
            }
        }
        if (null != (chgAuditColl = new ChgAuditHelper().getChgAuditAmountByContract(appId, conId, onlyAuditted, excludeBillIds)) && chgAuditColl.length > 0) {
            for (DynamicObject chgAuditObj : chgAuditColl) {
                BigDecimal oriAmt = chgAuditObj.getBigDecimal("oriamt");
                String billStatus = chgAuditObj.getString("billstatus");
                if (!onlyAuditted && !BillStatusEnum.AUDITTED.getValue().equals(billStatus) && NumberUtil.isNegativeNum((Object)oriAmt)) continue;
                chgOriAmt = NumberUtil.add((Object)chgOriAmt, (Object)chgAuditObj.getBigDecimal("oriamt"));
                chgAmt = NumberUtil.add((Object)chgAmt, (Object)chgAuditObj.getBigDecimal("amount"));
                chgTax = NumberUtil.add((Object)chgTax, (Object)chgAuditObj.getBigDecimal("tax"));
            }
        }
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(8);
        result.put("oriamt", chgOriAmt);
        result.put("amount", chgAmt);
        result.put("tax", chgTax);
        return result;
    }

    public Map<String, BigDecimal> getChgAmtIncSupply(String appId, long conId, boolean onlyAuditted, Long[] excludeBillIds) {
        if (0L == conId) {
            return new HashMap<String, BigDecimal>(2);
        }
        boolean existFlag = QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)conId)});
        if (!existFlag) {
            return new HashMap<String, BigDecimal>(2);
        }
        BigDecimal chgOriAmt = null;
        BigDecimal chgAmt = null;
        BigDecimal chgTax = null;
        DynamicObject[] supplyColl = SupplyConBillHelper.getSupplyConAmountByContract(appId, conId, onlyAuditted, excludeBillIds);
        if (null != supplyColl && supplyColl.length > 0) {
            for (DynamicObject supplyObj : supplyColl) {
                BigDecimal oriAmt = supplyObj.getBigDecimal("oriamt");
                String billStatus = supplyObj.getString("billstatus");
                if ("balanceCtrl".equals(supplyObj.get("ctrlmode")) || !onlyAuditted && !BillStatusEnum.AUDITTED.getValue().equals(billStatus) && NumberUtil.isNegativeNum((Object)oriAmt)) continue;
                chgOriAmt = NumberUtil.add((Object)chgOriAmt, (Object)supplyObj.getBigDecimal("oriamt"));
                chgAmt = NumberUtil.add((Object)chgAmt, (Object)supplyObj.getBigDecimal("amount"));
                chgTax = NumberUtil.add((Object)chgTax, (Object)supplyObj.getBigDecimal("tax"));
            }
        }
        Map<String, BigDecimal> result = this.getChgAmtExcSupply(appId, conId, onlyAuditted, excludeBillIds);
        chgOriAmt = NumberUtil.add((Object)result.get("oriamt"), chgOriAmt);
        chgAmt = NumberUtil.add((Object)result.get("amount"), chgAmt);
        chgTax = NumberUtil.add((Object)result.get("tax"), chgTax);
        result.put("oriamt", chgOriAmt);
        result.put("amount", chgAmt);
        result.put("tax", chgTax);
        return result;
    }
}

