/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pccs.concs.common.constant.FiCasConst;
import kd.pccs.concs.common.entity.ConPayPlanConst;
import kd.pccs.concs.common.enums.ConPayWayEnum;
import kd.pccs.concs.common.util.DateUtil;
import kd.pccs.concs.common.util.DynamicObjectUtil;
import kd.pccs.concs.common.util.MetaDataUtil;
import kd.pccs.concs.common.util.NumberUtil;
import org.apache.commons.lang.StringUtils;

public class ConPayPlanHelper {
    protected static final Set<String> COPY_IGNORE_KEYS = new HashSet<String>();

    public static DynamicObject calcConPayPlanData(String appId, DynamicObject conPayPlanObj) {
        if (null == conPayPlanObj) {
            return null;
        }
        DynamicObjectCollection paySchColl = (DynamicObjectCollection)conPayPlanObj.get("conpayplanschedule");
        DynamicObjectCollection planDataColl = conPayPlanObj.getDynamicObjectCollection("conpayplandata");
        planDataColl.clear();
        if (null == paySchColl || paySchColl.size() == 0) {
            return conPayPlanObj;
        }
        DynamicObject contractObj = conPayPlanObj.getDynamicObject("contractbill");
        BigDecimal exChangeRate = new BigDecimal(1);
        String entityId = MetaDataUtil.getEntityId((String)appId, (String)"contractbill_f7");
        if (null != contractObj && QueryServiceHelper.exists((String)entityId, (Object)contractObj.getPkValue())) {
            contractObj = BusinessDataServiceHelper.loadSingle((Object)contractObj.getPkValue(), (String)entityId);
            exChangeRate = contractObj.getBigDecimal("exchangerate");
        }
        DynamicObject prePaySchObj = null;
        TreeMap<Integer, DynamicObject> planDataMap = new TreeMap<Integer, DynamicObject>();
        DynamicObjectType planDataDt = planDataColl.getDynamicObjectType();
        int isize = paySchColl.size();
        for (int i = 0; i < isize; ++i) {
            DynamicObject paySchObj = (DynamicObject)paySchColl.get(i);
            BigDecimal planPayOriAmt = paySchObj.getBigDecimal("schentry_payoriamt");
            BigDecimal preFlushOriAmt = paySchObj.getBigDecimal("schentry_preflushoriamt");
            paySchObj.set("schentry_payamt", (Object)NumberUtil.multiply((Object)planPayOriAmt, (Object)exChangeRate));
            paySchObj.set("schentry_preflushamt", (Object)NumberUtil.multiply((Object)preFlushOriAmt, (Object)exChangeRate));
            if (NumberUtil.isZero((Object)planPayOriAmt)) continue;
            DynamicObject payTypeObj = paySchObj.getDynamicObject("schentry_paymenttype");
            if (null != payTypeObj && FiCasConst.PRE_PAYMENT.equals(payTypeObj.getPkValue())) {
                prePaySchObj = paySchObj;
                continue;
            }
            ConPayPlanHelper.handlePayScheduleData(planDataMap, paySchObj, planDataDt);
        }
        if (null != prePaySchObj) {
            ConPayPlanHelper.handlePrePaySchedule(planDataMap, prePaySchObj, planDataDt);
        }
        if (planDataMap.size() > 0) {
            for (Map.Entry entry : planDataMap.entrySet()) {
                planDataColl.add(entry.getValue());
            }
        }
        return conPayPlanObj;
    }

    private static void handlePrePaySchedule(Map<Integer, DynamicObject> planDataMap, DynamicObject prePaySchObj, DynamicObjectType planDataDt) {
        prePaySchObj.set("schentry_preflushoriamt", (Object)BigDecimal.ZERO);
        prePaySchObj.set("schentry_preflushamt", (Object)BigDecimal.ZERO);
        ConPayPlanHelper.handlePayScheduleData(planDataMap, prePaySchObj, planDataDt);
    }

    private static void handlePayScheduleData(Map<Integer, DynamicObject> planDataMap, DynamicObject paySchObj, DynamicObjectType planDataDt) {
        if (null == paySchObj) {
            return;
        }
        BigDecimal planPayOriAmt = paySchObj.getBigDecimal("schentry_payoriamt");
        BigDecimal planPayAmt = paySchObj.getBigDecimal("schentry_payamt");
        BigDecimal preflushoriamt = paySchObj.getBigDecimal("schentry_preflushoriamt");
        BigDecimal preflushamt = paySchObj.getBigDecimal("schentry_preflushamt");
        planPayOriAmt = NumberUtil.subtract((Object)planPayOriAmt, (Object)preflushoriamt);
        planPayAmt = NumberUtil.subtract((Object)planPayAmt, (Object)preflushamt);
        if (ConPayWayEnum.BYMONTH.getValue().equals(paySchObj.get("schentry_payway"))) {
            DynamicObject planEntryObj;
            Date beginDate = paySchObj.getDate("schentry_begindate");
            Date endDate = paySchObj.getDate("schentry_enddate");
            Map<Integer, BigDecimal> payScaleMap = ConPayPlanHelper.calcPayScale(beginDate, endDate);
            BigDecimal tempPlanPayOriAmt = planPayOriAmt;
            BigDecimal tempPlanPayAmt = planPayAmt;
            BigDecimal maxValOriAmt = null;
            int maxValMonth = 0;
            for (Map.Entry<Integer, BigDecimal> entry : payScaleMap.entrySet()) {
                int payMonth = entry.getKey();
                BigDecimal payScale = entry.getValue();
                BigDecimal payOriAmt = NumberUtil.multiply((Object)planPayOriAmt, (Object)payScale, (int)2);
                BigDecimal payAmt = NumberUtil.multiply((Object)planPayAmt, (Object)payScale, (int)2);
                DynamicObject planEntryObj2 = planDataMap.get(payMonth);
                if (null == planEntryObj2) {
                    planEntryObj2 = new DynamicObject(planDataDt);
                    planEntryObj2.set("planentry_paymonth", (Object)payMonth);
                    planDataMap.put(payMonth, planEntryObj2);
                }
                planEntryObj2.set("planentry_payoriamt", (Object)NumberUtil.add((Object)planEntryObj2.get("planentry_payoriamt"), (Object)payOriAmt));
                planEntryObj2.set("planentry_payamt", (Object)NumberUtil.add((Object)planEntryObj2.get("planentry_payamt"), (Object)payAmt));
                tempPlanPayOriAmt = NumberUtil.subtract((Object)tempPlanPayOriAmt, (Object)payOriAmt);
                tempPlanPayAmt = NumberUtil.subtract((Object)tempPlanPayAmt, (Object)payAmt);
                if (NumberUtil.compareTo(maxValOriAmt, (Object)payOriAmt) > 0) continue;
                maxValOriAmt = payOriAmt;
                maxValMonth = payMonth;
            }
            if (NumberUtil.compareTo((Object)tempPlanPayOriAmt, (Object)BigDecimal.ZERO) != 0 && null != (planEntryObj = planDataMap.get(maxValMonth))) {
                planEntryObj.set("planentry_payoriamt", (Object)NumberUtil.add((Object)planEntryObj.get("planentry_payoriamt"), (Object)tempPlanPayOriAmt));
            }
            if (NumberUtil.compareTo((Object)tempPlanPayAmt, (Object)BigDecimal.ZERO) != 0 && null != (planEntryObj = planDataMap.get(maxValMonth))) {
                planEntryObj.set("planentry_payamt", (Object)NumberUtil.add((Object)planEntryObj.get("planentry_payamt"), (Object)tempPlanPayAmt));
            }
        } else {
            int payMonth;
            DynamicObject planEntryObj;
            Date payDate = paySchObj.getDate("schentry_paydate");
            if (null == payDate) {
                payDate = new Date();
            }
            if (null == (planEntryObj = planDataMap.get(payMonth = DateUtil.getYearMonth((Date)payDate)))) {
                planEntryObj = new DynamicObject(planDataDt);
                planEntryObj.set("planentry_paymonth", (Object)payMonth);
                planDataMap.put(payMonth, planEntryObj);
            }
            planEntryObj.set("planentry_payoriamt", (Object)NumberUtil.add((Object)planEntryObj.get("planentry_payoriamt"), (Object)planPayOriAmt));
            planEntryObj.set("planentry_payamt", (Object)NumberUtil.add((Object)planEntryObj.get("planentry_payamt"), (Object)planPayAmt));
        }
    }

    private static Map<Integer, BigDecimal> calcPayScale(Date beginDate, Date endDate) {
        TreeMap<Integer, BigDecimal> payScaleMap = new TreeMap<Integer, BigDecimal>();
        int beginMonth = DateUtil.getYearMonth((Date)beginDate);
        int endMonth = DateUtil.getYearMonth((Date)endDate);
        int totalDays = DateUtil.getDiffDays((Date)beginDate, (Date)endDate);
        Calendar cal = Calendar.getInstance();
        int month = beginMonth;
        while (month <= endMonth) {
            int daysOfMonth;
            BigDecimal payScale = null;
            if (month == beginMonth) {
                if (month == endMonth) {
                    payScale = BigDecimal.ONE;
                } else {
                    daysOfMonth = DateUtil.getDiffDays((Date)beginDate, (Date)DateUtil.getLastDayOfMonth((Date)beginDate));
                    payScale = NumberUtil.divide((Object)daysOfMonth, (Object)totalDays, (int)10);
                }
            } else if (month == endMonth) {
                cal.setTime(endDate);
                daysOfMonth = cal.get(5);
                payScale = NumberUtil.divide((Object)daysOfMonth, (Object)totalDays, (int)10);
            } else {
                cal.set(1, month / 100);
                cal.set(2, month % 100 - 1);
                cal.set(5, 1);
                cal.add(2, 1);
                cal.add(5, -1);
                daysOfMonth = cal.get(5);
                payScale = NumberUtil.divide((Object)daysOfMonth, (Object)totalDays, (int)10);
            }
            payScaleMap.put(month, payScale);
            month = DateUtil.getNextYearMonth((int)month);
        }
        return payScaleMap;
    }

    public static List<Integer> getPayPlanMonths(String appId, Long entityId, String filterKey) {
        LinkedList<Integer> months = new LinkedList<Integer>();
        if (null == entityId || entityId == 0L) {
            return months;
        }
        DynamicObject conPayPlanObj = BusinessDataServiceHelper.loadSingle((String)MetaDataUtil.getEntityId((String)appId, (String)"conpayplan"), (String)String.join((CharSequence)",", "planentry_paymonth", "actualentry_paymonth"), (QFilter[])new QFilter[]{new QFilter(filterKey, "=", (Object)entityId)});
        HashSet monthSet = new HashSet();
        if (conPayPlanObj != null) {
            conPayPlanObj.getDynamicObjectCollection("conpayplandata").forEach(obj -> monthSet.add(obj.getInt("planentry_paymonth")));
            conPayPlanObj.getDynamicObjectCollection("conpayplanactdata").forEach(obj -> monthSet.add(obj.getInt("actualentry_paymonth")));
        }
        months.addAll(monthSet);
        months.sort(Comparator.comparingInt(Integer::intValue));
        return months;
    }

    public static String getMonthColKey(int month) {
        return "M" + month;
    }

    public static String getLocalMonthColKey(int month) {
        return "localm" + month;
    }

    public static boolean existsConPayPlan(String appId, Long conId, boolean isConRevise) {
        return QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)appId, (String)"conpayplan"), (QFilter[])new QFilter[]{new QFilter(isConRevise ? "conrevisebill" : "contractbill", "=", (Object)conId)});
    }

    public static void genPlanEntryViewData(String appId, DynamicObject conPayPlanObj) {
        if (null == conPayPlanObj) {
            return;
        }
        DynamicObjectCollection planEntryViewColl = conPayPlanObj.getDynamicObjectCollection("conpayplandata_view");
        planEntryViewColl.clear();
        DynamicObject planEntryObj = planEntryViewColl.addNew();
        planEntryObj.set("col1", (Object)ConPayPlanConst.ENTITY_CONPAYPLANDATA_VIEW_COL_1_row1);
        DynamicObjectCollection planEntryColl = conPayPlanObj.getDynamicObjectCollection("conpayplandata");
        BigDecimal sumOriAmt = null;
        BigDecimal sumAmt = null;
        for (DynamicObject entryObj : planEntryColl) {
            BigDecimal payOriAmt = entryObj.getBigDecimal("planentry_payoriamt");
            BigDecimal payAmt = entryObj.getBigDecimal("planentry_payamt");
            planEntryObj.set(ConPayPlanHelper.getMonthColKey(entryObj.getInt("planentry_paymonth")), (Object)payOriAmt);
            planEntryObj.set(ConPayPlanHelper.getLocalMonthColKey(entryObj.getInt("planentry_paymonth")), (Object)payAmt);
            sumOriAmt = NumberUtil.add(sumOriAmt, (Object)payOriAmt);
            sumAmt = NumberUtil.add(sumAmt, (Object)payAmt);
        }
        planEntryObj.set("sum", sumOriAmt);
        planEntryObj.set("localsum", sumAmt);
        DynamicObjectCollection payEntryColl = conPayPlanObj.getDynamicObjectCollection("conpayplanactdata");
        if (payEntryColl.size() > 0) {
            DynamicObject payEntryObj = planEntryViewColl.addNew();
            payEntryObj.set("col1", (Object)ConPayPlanConst.ENTITY_CONPAYPLANDATA_VIEW_COL_1_row2);
            sumAmt = null;
            for (DynamicObject entryObj : payEntryColl) {
                int month = entryObj.getInt("actualentry_paymonth");
                if (month == 0) continue;
                BigDecimal payOriAmt = entryObj.getBigDecimal("actualentry_payoriamt");
                payEntryObj.set(ConPayPlanHelper.getMonthColKey(month), (Object)payOriAmt);
                sumAmt = NumberUtil.add((Object)sumAmt, (Object)payOriAmt);
            }
            payEntryObj.set("sum", (Object)sumAmt);
        }
    }

    public static void checkScheduleEntryAmount(String appId, DynamicObject conPayPlanObj) {
        DynamicObjectCollection schEntryColl = conPayPlanObj.getDynamicObjectCollection("conpayplanschedule");
        if (null == schEntryColl || schEntryColl.size() == 0) {
            return;
        }
        BigDecimal sumScale = null;
        BigDecimal sumPayOriAmt = null;
        BigDecimal sumPreflushOriAmt = null;
        DynamicObject preSchEntryObj = null;
        int isize = schEntryColl.size();
        for (int i = 0; i < isize; ++i) {
            DynamicObject schEntryObj = (DynamicObject)schEntryColl.get(i);
            DynamicObject payMentType = schEntryObj.getDynamicObject("schentry_paymenttype");
            String payWay = schEntryObj.getString("schentry_payway");
            int seq = i + 1;
            if (ConPayWayEnum.BYMONTH.getValue().equals(payWay)) {
                Date beginDate = schEntryObj.getDate("schentry_begindate");
                if (null == beginDate) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6\u7b2c%d\u884c\"\u5f00\u59cb\u65e5\u671f\"\u4e3a\u7a7a,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConPayPlanHelper_0", (String)"pccs-concs-business", (Object[])new Object[0]), seq));
                }
                Date endDate = schEntryObj.getDate("schentry_enddate");
                if (null == endDate) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6\u7b2c%d\u884c\"\u7ed3\u675f\u65e5\u671f\"\u4e3a\u7a7a,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConPayPlanHelper_1", (String)"pccs-concs-business", (Object[])new Object[0]), seq));
                }
                if (DateUtil.getDiffDays((Date)beginDate, (Date)endDate) < 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6\u7b2c%d\u884c\"\u5f00\u59cb\u65e5\u671f\"\u665a\u4e8e\u7ed3\u675f\u65e5\u671f,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConPayPlanHelper_2", (String)"pccs-concs-business", (Object[])new Object[0]), seq));
                }
            } else if (null == schEntryObj.getDate("schentry_paydate")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6\u7b2c%d\u884c\"\u8ba1\u5212\u652f\u4ed8\u65e5\u671f\"\u4e3a\u7a7a,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConPayPlanHelper_3", (String)"pccs-concs-business", (Object[])new Object[0]), seq));
            }
            if (null != payMentType && FiCasConst.PRE_PAYMENT.equals(payMentType.getPkValue())) {
                preSchEntryObj = schEntryObj;
                continue;
            }
            if (NumberUtil.compareTo((Object)schEntryObj.getBigDecimal("schentry_payoriamt"), (Object)schEntryObj.getBigDecimal("schentry_preflushoriamt")) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6\u7b2c%d\u884c\"\u9884\u4ed8\u6b3e\u51b2\u9500\u91d1\u989d\"\u5927\u4e8e\"\u8ba1\u5212\u652f\u4ed8\u91d1\u989d\",\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConPayPlanHelper_4", (String)"pccs-concs-business", (Object[])new Object[0]), seq));
            }
            sumScale = NumberUtil.add(sumScale, (Object)schEntryObj.getBigDecimal("schentry_payscale"));
            sumPayOriAmt = NumberUtil.add(sumPayOriAmt, (Object)schEntryObj.getBigDecimal("schentry_payoriamt"));
            sumPreflushOriAmt = NumberUtil.add(sumPreflushOriAmt, (Object)schEntryObj.getBigDecimal("schentry_preflushoriamt"));
        }
        if (null != preSchEntryObj) {
            if (NumberUtil.compareTo((Object)preSchEntryObj.getBigDecimal("schentry_payoriamt"), (Object)conPayPlanObj.getBigDecimal("oriamt")) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6\u4e2d\u9884\u4ed8\u6b3e\u8ba1\u5212\u652f\u4ed8\u91d1\u989d\u5927\u4e8e\u9884\u5408\u7ea6\u91d1\u989d,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConPayPlanHelper_5", (String)"pccs-concs-business", (Object[])new Object[0]));
            }
            if (NumberUtil.compareTo((Object)preSchEntryObj.getBigDecimal("schentry_payoriamt"), sumPreflushOriAmt) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u91d1\u989d\u5c1a\u672a\u5b8c\u5168\u51b2\u9500\uff0c\u8bf7\u76f8\u5e94\u8c03\u6574!", (String)"ConPayPlanHelper_6", (String)"pccs-concs-business", (Object[])new Object[0]));
            }
        }
        if (NumberUtil.compareTo((Object)NumberUtil.ONE_HUNDRED, sumScale) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9664\u9884\u4ed8\u6b3e\u5916,\u7ea6\u5b9a\u652f\u4ed8\u6bd4\u4f8b\u9700\u8fbe\u5230100%,\u8bf7\u4fee\u6539\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c!", (String)"ConPayPlanHelper_7", (String)"pccs-concs-business", (Object[])new Object[0]));
        }
        if (NumberUtil.compareTo((Object)NumberUtil.ONE_HUNDRED, sumScale) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9664\u9884\u4ed8\u6b3e\u5916,\u7ea6\u5b9a\u652f\u4ed8\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100%,\u8bf7\u4fee\u6539\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c!", (String)"ConPayPlanHelper_8", (String)"pccs-concs-business", (Object[])new Object[0]));
        }
        if (NumberUtil.compareTo((Object)conPayPlanObj.getBigDecimal("oriamt"), sumPayOriAmt) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6\u4e2d\u8ba1\u5212\u652f\u4ed8\u91d1\u989d\u5408\u8ba1\u503c\u4e0d\u7b49\u4e8e\u5408\u7ea6\u91d1\u989d,\u4e0d\u80fd\u63d0\u4ea4!", (String)"ConPayPlanHelper_9", (String)"pccs-concs-business", (Object[])new Object[0]));
        }
    }

    public static boolean checkHasPrePayment(String appId, DynamicObjectCollection conPayPlanSchedule) {
        for (int i = 0; i < conPayPlanSchedule.size(); ++i) {
            DynamicObject conPayPlan = (DynamicObject)conPayPlanSchedule.get(i);
            DynamicObject paymentType = conPayPlan.getDynamicObject("schentry_paymenttype");
            if (null == paymentType || !FiCasConst.PRE_PAYMENT.equals(paymentType.getPkValue())) continue;
            return true;
        }
        return false;
    }

    public static DynamicObject getConPayPlan(String appId, String relationKey, Long keyId) {
        if (null == keyId || keyId == 0L || StringUtils.isEmpty((String)relationKey)) {
            return null;
        }
        DynamicObject conPayPlanObj = null;
        List pks = QueryServiceHelper.queryPrimaryKeys((String)MetaDataUtil.getEntityId((String)appId, (String)"conpayplan"), (QFilter[])new QFilter[]{new QFilter(relationKey, "=", (Object)keyId)}, null, (int)1);
        if (null != pks && pks.size() > 0) {
            conPayPlanObj = BusinessDataServiceHelper.loadSingle(pks.get(0), (String)MetaDataUtil.getEntityId((String)appId, (String)"conpayplan"));
        }
        return conPayPlanObj;
    }

    public static void syncConPayPlanData(String appId, Long conreviseId, Long conId) {
        DynamicObject oldConPayPlanObj = ConPayPlanHelper.getConPayPlan(appId, "contractbill", conId);
        DynamicObject newConPayPlanObj = ConPayPlanHelper.getConPayPlan(appId, "conrevisebill", conreviseId);
        if (null == oldConPayPlanObj) {
            if (null == newConPayPlanObj) {
                return;
            }
            oldConPayPlanObj = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityType)newConPayPlanObj.getDynamicObjectType(), (Object)newConPayPlanObj);
            DynamicObject conF7Obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill_f7")));
            conF7Obj.set("id", (Object)conId);
            oldConPayPlanObj.set("contractbill", (Object)conF7Obj);
            oldConPayPlanObj.set("conrevisebill", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oldConPayPlanObj});
        } else if (null != newConPayPlanObj) {
            DynamicObjectUtil.copy((DynamicObject)newConPayPlanObj, (DynamicObject)oldConPayPlanObj, COPY_IGNORE_KEYS);
            DynamicObject conF7Obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)MetaDataUtil.getEntityId((String)appId, (String)"contractbill_f7")));
            conF7Obj.set("id", (Object)conId);
            oldConPayPlanObj.set("contractbill", (Object)conF7Obj);
            oldConPayPlanObj.set("conrevisebill", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oldConPayPlanObj});
        }
    }

    static {
        COPY_IGNORE_KEYS.add("id");
        COPY_IGNORE_KEYS.add("creator");
        COPY_IGNORE_KEYS.add("createtime");
        COPY_IGNORE_KEYS.add("modifier");
        COPY_IGNORE_KEYS.add("modifytime");
        COPY_IGNORE_KEYS.add("auditor");
        COPY_IGNORE_KEYS.add("auditdate");
        COPY_IGNORE_KEYS.add("billstatus");
        COPY_IGNORE_KEYS.add("bizstatus");
        COPY_IGNORE_KEYS.add("bizdate");
        COPY_IGNORE_KEYS.add("handler");
        COPY_IGNORE_KEYS.add("conpayplandata_view");
    }
}

