/*
 * Decompiled with CFR 0.152.
 */
package kd.pccs.concs.business.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pccs.concs.common.enums.BillStatusEnum;
import kd.pccs.concs.common.util.MetaDataUtil;

public class ConSettleBillHelper {
    public static boolean hasSettled(String appId, long conId) {
        return QueryServiceHelper.exists((String)MetaDataUtil.getEntityId((String)appId, (String)"consettlebill"), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("contractbill", "=", (Object)conId)});
    }

    public static DynamicObject[] getSettleAmountByContract(String appId, long conId, boolean onlyAudited) {
        QFilter[] filters = null;
        filters = onlyAudited ? new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITTED.getValue()), new QFilter("contractbill", "=", (Object)conId)} : new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SUBMITTED.getValue(), BillStatusEnum.AUDITTED.getValue()}), new QFilter("contractbill", "=", (Object)conId)};
        return BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"consettlebill"), (String)String.join((CharSequence)",", "billstatus", "bizstatus", "settletype", "oriamt", "amount", "tax"), (QFilter[])filters);
    }

    public static Set<Long> getHasSettledConIds(String appId, long currentOrgId) {
        QFilter[] filters = new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVED.getValue(), BillStatusEnum.SUBMITTED.getValue(), BillStatusEnum.AUDITTED.getValue()}), new QFilter("org", "=", (Object)currentOrgId)};
        DynamicObject[] settleBillColl = BusinessDataServiceHelper.load((String)MetaDataUtil.getEntityId((String)appId, (String)"consettlebill"), (String)"contractbill", (QFilter[])filters);
        HashSet<Long> conIdSet = new HashSet<Long>();
        if (settleBillColl.length > 0) {
            for (DynamicObject settleBill : settleBillColl) {
                DynamicObject contract = settleBill.getDynamicObject("contractbill");
                if (null == contract) continue;
                conIdSet.add(Long.valueOf(contract.getPkValue().toString()));
            }
        }
        return conIdSet;
    }
}

